/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.resourcepack;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;
import net.mehvahdjukaar.selene.resourcepack.ResType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class RPUtils {
    public static String serializeJson(JsonElement json) throws IOException {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        jsonWriter.setLenient(true);
        jsonWriter.setIndent("  ");
        Streams.write((JsonElement)json, (JsonWriter)jsonWriter);
        return stringWriter.toString();
    }

    public static JsonObject deserializeJson(InputStream stream) {
        JsonElement element = new JsonParser().parse((Reader)new InputStreamReader(stream));
        return element.getAsJsonObject();
    }

    public static NativeImage findFirstBlockTexture(ResourceManager manager, Block block) throws FileNotFoundException {
        String loc = RPUtils.findFirstBlockTextureLocation(manager, block, s -> true);
        try {
            return NativeImage.m_85058_((InputStream)manager.m_142591_(ResType.TEXTURES.getPath(loc)).m_6679_());
        }
        catch (IOException e) {
            throw new FileNotFoundException("Could not resolve texture " + loc);
        }
    }

    public static NativeImage findFirstItemTexture(ResourceManager manager, Item item) throws FileNotFoundException {
        String loc = RPUtils.findFirstItemTextureLocation(manager, item, s -> true);
        try {
            return NativeImage.m_85058_((InputStream)manager.m_142591_(ResType.TEXTURES.getPath(loc)).m_6679_());
        }
        catch (IOException e) {
            throw new FileNotFoundException("Could not resolve texture " + loc);
        }
    }

    public static String findFirstBlockTextureLocation(ResourceManager manager, Block block, Predicate<String> texturePredicate) throws FileNotFoundException {
        try {
            JsonObject modelElement;
            ResourceLocation res = block.getRegistryName();
            Resource blockState = manager.m_142591_(ResType.BLOCKSTATES.getPath(res));
            JsonObject bsElement = RPUtils.deserializeJson(blockState.m_6679_());
            String modelPath = RPUtils.findAllResourcesInJsonRecursive((JsonElement)bsElement.getAsJsonObject(), s -> s.equals("model")).get(0);
            try {
                Resource model = manager.m_142591_(ResType.MODELS.getPath(modelPath));
                modelElement = RPUtils.deserializeJson(model.m_6679_());
            }
            catch (Exception e) {
                throw new Exception("Failed to parse model at " + modelPath);
            }
            return RPUtils.findAllResourcesInJsonRecursive((JsonElement)modelElement.getAsJsonObject().getAsJsonObject("textures")).stream().filter(texturePredicate).findAny().get();
        }
        catch (Exception e) {
            throw new FileNotFoundException("Could not find any texture associated to the given block " + block.getRegistryName());
        }
    }

    public static String findFirstItemTextureLocation(ResourceManager manager, Item item, Predicate<String> texturePredicate) throws FileNotFoundException {
        try {
            ResourceLocation res = item.getRegistryName();
            Resource itemModel = manager.m_142591_(ResType.ITEM_MODELS.getPath(res));
            JsonObject bsElement = RPUtils.deserializeJson(itemModel.m_6679_());
            return RPUtils.findAllResourcesInJsonRecursive((JsonElement)bsElement.getAsJsonObject().getAsJsonObject("textures")).stream().filter(texturePredicate).findAny().get();
        }
        catch (Exception e) {
            throw new FileNotFoundException("Could not find any texture associated to the given item " + item.getRegistryName());
        }
    }

    public static String findFirstResourceInJsonRecursive(JsonElement element) throws NoSuchElementException {
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            return RPUtils.findFirstResourceInJsonRecursive(array.get(0));
        }
        if (element instanceof JsonObject) {
            Set entries = element.getAsJsonObject().entrySet();
            JsonElement child = (JsonElement)((Map.Entry)entries.stream().findAny().get()).getValue();
            return RPUtils.findFirstResourceInJsonRecursive(child);
        }
        return element.getAsString();
    }

    public static List<String> findAllResourcesInJsonRecursive(JsonElement element) {
        return RPUtils.findAllResourcesInJsonRecursive(element, s -> true);
    }

    public static List<String> findAllResourcesInJsonRecursive(JsonElement element, Predicate<String> filter) {
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            ArrayList<String> list = new ArrayList<String>();
            array.forEach(e -> list.addAll(RPUtils.findAllResourcesInJsonRecursive(e)));
            return list;
        }
        if (element instanceof JsonObject) {
            JsonObject json = (JsonObject)element;
            Set entries = json.entrySet();
            ArrayList<String> list = new ArrayList<String>();
            for (Map.Entry c : entries) {
                if (((JsonElement)c.getValue()).isJsonPrimitive() && !filter.test((String)c.getKey())) continue;
                List<String> l = RPUtils.findAllResourcesInJsonRecursive((JsonElement)c.getValue(), filter);
                list.addAll(l);
            }
            return list;
        }
        return List.of(element.getAsString());
    }
}

