/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.resourcepack.asset_generators.textures;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.mehvahdjukaar.selene.resourcepack.asset_generators.textures.Palette;
import net.mehvahdjukaar.selene.resourcepack.asset_generators.textures.PaletteColor;
import org.jetbrains.annotations.Nullable;

public class Respriter {
    private final NativeImage templateImage;
    private final Palette originalPalette;

    public Respriter(NativeImage templateImage) {
        this(templateImage, templateImage);
    }

    public Respriter(NativeImage templateImage, Palette originalPalette) {
        this.templateImage = templateImage;
        this.originalPalette = originalPalette;
    }

    public Respriter(NativeImage imageToRecolor, NativeImage paletteFrom) {
        this(imageToRecolor, Palette.fromImage(paletteFrom, null));
    }

    public NativeImage recolorImage(Palette targetPalette) {
        Map<Integer, Integer> paletteMap = this.getColorToColorMap(targetPalette);
        NativeImage newImage = new NativeImage(this.templateImage.m_84982_(), this.templateImage.m_85084_(), false);
        if (paletteMap != null) {
            newImage.m_85054_(this.templateImage);
            for (int x = 0; x < newImage.m_84982_(); ++x) {
                for (int y = 0; y < newImage.m_85084_(); ++y) {
                    int oldValue = newImage.m_84985_(x, y);
                    Integer newValue = paletteMap.get(oldValue);
                    if (newValue == null) continue;
                    newImage.m_84988_(x, y, newValue.intValue());
                }
            }
        }
        return newImage;
    }

    public NativeImage recolorImage(NativeImage targetPaletteImage, @Nullable NativeImage mask) {
        return this.recolorImage(Palette.fromImage(targetPaletteImage, mask));
    }

    @Nullable
    private Map<Integer, Integer> getColorToColorMap(Palette toPalette) {
        toPalette.matchSize(this.originalPalette.size());
        if (toPalette.size() != this.originalPalette.size()) {
            return null;
        }
        return this.zipToMap(this.originalPalette.getValues(), toPalette.getValues());
    }

    private Map<Integer, Integer> zipToMap(List<PaletteColor> keys, List<PaletteColor> values) {
        return IntStream.range(0, keys.size()).boxed().collect(Collectors.toMap(i -> ((PaletteColor)keys.get((int)i.intValue())).color, i -> ((PaletteColor)values.get((int)i.intValue())).color));
    }
}

