/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.util;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Utils {
    public static final PrimitiveCodec<Integer> HEX_CODEC = new PrimitiveCodec<Integer>(){

        public <T> DataResult<Integer> read(DynamicOps<T> ops, T input) {
            return ops.getStringValue(input).map(s -> {
                if (s.contains("0x") || s.contains("#")) {
                    return Integer.parseUnsignedInt(s.replace("0x", "").replace("#", ""), 16);
                }
                return Integer.parseUnsignedInt(s, 10);
            }).map(Number::intValue);
        }

        public <T> T write(DynamicOps<T> ops, Integer value) {
            String hex = Integer.toHexString(value);
            return (T)ops.createString("#" + hex);
        }

        public String toString() {
            return "Int";
        }
    };

    public static void swapItem(Player player, InteractionHand hand, ItemStack oldItem, ItemStack newItem, boolean bothsides) {
        if (!player.f_19853_.f_46443_ || bothsides) {
            player.m_21008_(hand, ItemUtils.m_41817_((ItemStack)oldItem.m_41777_(), (Player)player, (ItemStack)newItem, (boolean)player.m_7500_()));
        }
    }

    public static void swapItem(Player player, InteractionHand hand, ItemStack oldItem, ItemStack newItem) {
        if (!player.f_19853_.f_46443_) {
            player.m_21008_(hand, ItemUtils.m_41817_((ItemStack)oldItem.m_41777_(), (Player)player, (ItemStack)newItem, (boolean)player.m_7500_()));
        }
    }

    public static void swapItemNBT(Player player, InteractionHand hand, ItemStack oldItem, ItemStack newItem) {
        if (!player.f_19853_.f_46443_) {
            player.m_21008_(hand, ItemUtils.m_41817_((ItemStack)oldItem.m_41777_(), (Player)player, (ItemStack)newItem, (boolean)false));
        }
    }

    public static void swapItem(Player player, InteractionHand hand, ItemStack newItem) {
        if (!player.f_19853_.f_46443_) {
            player.m_21008_(hand, ItemUtils.m_41817_((ItemStack)player.m_21120_(hand).m_41777_(), (Player)player, (ItemStack)newItem, (boolean)player.m_7500_()));
        }
    }

    public static void addStackToExisting(Player player, ItemStack stack) {
        Inventory inv = player.m_150109_();
        boolean added = false;
        for (int j = 0; j < inv.f_35974_.size(); ++j) {
            if (!inv.m_8020_(j).m_150930_(stack.m_41720_()) || !inv.m_36040_(j, stack)) continue;
            added = true;
            break;
        }
        if (!added && inv.m_36054_(stack)) {
            player.m_36176_(stack, false);
        }
    }

    public static int getXPinaBottle(int bottleCount, Random rand) {
        int xp = 0;
        for (int i = 0; i < bottleCount; ++i) {
            xp += 3 + rand.nextInt(5) + rand.nextInt(5);
        }
        return xp;
    }

    public static VoxelShape rotateVoxelShape(VoxelShape source, Direction direction) {
        AtomicReference<VoxelShape> newShape = new AtomicReference<VoxelShape>(Shapes.m_83040_());
        source.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            Vec3 min = new Vec3(minX - 0.5, minY - 0.5, minZ - 0.5);
            Vec3 max = new Vec3(maxX - 0.5, maxY - 0.5, maxZ - 0.5);
            Vec3 v1 = Utils.rotateVec3(min, direction);
            Vec3 v2 = Utils.rotateVec3(max, direction);
            VoxelShape s = Shapes.m_166049_((double)(0.5 + Math.min(v1.f_82479_, v2.f_82479_)), (double)(0.5 + Math.min(v1.f_82480_, v2.f_82480_)), (double)(0.5 + Math.min(v1.f_82481_, v2.f_82481_)), (double)(0.5 + Math.max(v1.f_82479_, v2.f_82479_)), (double)(0.5 + Math.max(v1.f_82480_, v2.f_82480_)), (double)(0.5 + Math.max(v1.f_82481_, v2.f_82481_)));
            newShape.set(Shapes.m_83110_((VoxelShape)((VoxelShape)newShape.get()), (VoxelShape)s));
        });
        return newShape.get();
    }

    public static Vec3 rotateVec3(Vec3 vec, Direction dir) {
        double cos = 1.0;
        double sin = 0.0;
        switch (dir) {
            case SOUTH: {
                cos = -1.0;
                sin = 0.0;
                break;
            }
            case WEST: {
                cos = 0.0;
                sin = 1.0;
                break;
            }
            case EAST: {
                cos = 0.0;
                sin = -1.0;
            }
        }
        double d0 = vec.f_82479_ * cos + vec.f_82481_ * sin;
        double d1 = vec.f_82480_;
        double d2 = vec.f_82481_ * cos - vec.f_82479_ * sin;
        return new Vec3(d0, d1, d2);
    }
}

