/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.config;

import mekanism.additions.common.registries.AdditionsEntityTypes;
import mekanism.api.providers.IEntityTypeProvider;
import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedBooleanValue;
import mekanism.common.config.value.CachedDoubleValue;
import mekanism.common.config.value.CachedResourceLocationListValue;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class AdditionsCommonConfig
extends BaseMekanismConfig {
    private final ForgeConfigSpec configSpec;
    public final SpawnConfig babyCreeper;
    public final SpawnConfig babyEnderman;
    public final SpawnConfig babySkeleton;
    public final SpawnConfig babyStray;
    public final SpawnConfig babyWitherSkeleton;

    AdditionsCommonConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Mekanism Additions Common Config. This config is not sync'd between server and client.").push("additions-common");
        builder.comment("Config options regarding spawning of entities.").push("spawning");
        this.babyCreeper = new SpawnConfig((IMekanismConfig)this, builder, "baby creepers", (IEntityTypeProvider)AdditionsEntityTypes.BABY_CREEPER, () -> EntityType.f_20558_);
        this.babyEnderman = new SpawnConfig((IMekanismConfig)this, builder, "baby endermen", (IEntityTypeProvider)AdditionsEntityTypes.BABY_ENDERMAN, () -> EntityType.f_20566_);
        this.babySkeleton = new SpawnConfig((IMekanismConfig)this, builder, "baby skeletons", (IEntityTypeProvider)AdditionsEntityTypes.BABY_SKELETON, () -> EntityType.f_20524_);
        this.babyStray = new SpawnConfig((IMekanismConfig)this, builder, "baby strays", (IEntityTypeProvider)AdditionsEntityTypes.BABY_STRAY, () -> EntityType.f_20481_);
        this.babyWitherSkeleton = new SpawnConfig((IMekanismConfig)this, builder, "baby wither skeletons", (IEntityTypeProvider)AdditionsEntityTypes.BABY_WITHER_SKELETON, () -> EntityType.f_20497_);
        builder.pop(2);
        this.configSpec = builder.build();
    }

    public String getFileName() {
        return "additions-common";
    }

    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    public ModConfig.Type getConfigType() {
        return ModConfig.Type.COMMON;
    }

    public static class SpawnConfig {
        public final CachedBooleanValue shouldSpawn;
        public final CachedDoubleValue weightPercentage;
        public final CachedDoubleValue minSizePercentage;
        public final CachedDoubleValue maxSizePercentage;
        public final CachedDoubleValue spawnCostPerEntityPercentage;
        public final CachedDoubleValue maxSpawnCostPercentage;
        public final CachedResourceLocationListValue biomeBlackList;
        public final CachedResourceLocationListValue structureBlackList;
        public final IEntityTypeProvider entityTypeProvider;
        public final IEntityTypeProvider parentTypeProvider;

        private SpawnConfig(IMekanismConfig config, ForgeConfigSpec.Builder builder, String name, IEntityTypeProvider entityTypeProvider, IEntityTypeProvider parentTypeProvider) {
            this.entityTypeProvider = entityTypeProvider;
            this.parentTypeProvider = parentTypeProvider;
            builder.comment("Config options regarding " + name + ".").push(name.replace(" ", "-"));
            this.shouldSpawn = CachedBooleanValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Enable the spawning of " + name + ". Think baby zombies.").worldRestart().define("shouldSpawn", true));
            this.weightPercentage = CachedDoubleValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("The multiplier for weight of " + name + " spawns, compared to the adult mob.").worldRestart().defineInRange("weightPercentage", 0.5, 0.0, 100.0));
            this.minSizePercentage = CachedDoubleValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("The multiplier for minimum group size of " + name + " spawns, compared to the adult mob.").worldRestart().defineInRange("minSizePercentage", 0.5, 0.0, 100.0));
            this.maxSizePercentage = CachedDoubleValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("The multiplier for maximum group size of " + name + " spawns, compared to the adult mob.").worldRestart().defineInRange("maxSizePercentage", 0.5, 0.0, 100.0));
            this.spawnCostPerEntityPercentage = CachedDoubleValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("The multiplier for spawn cost per entity of " + name + " spawns, compared to the adult mob.").worldRestart().defineInRange("spawnCostPerEntityPercentage", 1.0, 0.0, 100.0));
            this.maxSpawnCostPercentage = CachedDoubleValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("The multiplier for max spawn cost of " + name + " spawns, compared to the adult mob.").worldRestart().defineInRange("maxSpawnCostPercentage", 1.0, 0.0, 100.0));
            this.biomeBlackList = CachedResourceLocationListValue.define((IMekanismConfig)config, (ForgeConfigSpec.Builder)builder.comment("The list of biome ids that " + name + " will not spawn in even if the normal mob variant can spawn.").worldRestart(), (String)"biomeBlackList", arg_0 -> ((IForgeRegistry)ForgeRegistries.BIOMES).containsKey(arg_0));
            this.structureBlackList = CachedResourceLocationListValue.define((IMekanismConfig)config, (ForgeConfigSpec.Builder)builder.comment("The list of structure ids that " + name + " will not spawn in even if the normal mob variant can spawn.").worldRestart(), (String)"structureBlackList", arg_0 -> ((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES).containsKey(arg_0));
            builder.pop();
        }
    }
}

