/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.level.biome.forge;

import com.google.common.collect.Lists;
import dev.architectury.hooks.level.biome.BiomeHooks;
import dev.architectury.hooks.level.biome.BiomeProperties;
import dev.architectury.hooks.level.biome.ClimateProperties;
import dev.architectury.hooks.level.biome.EffectsProperties;
import dev.architectury.hooks.level.biome.GenerationProperties;
import dev.architectury.hooks.level.biome.SpawnProperties;
import dev.architectury.registry.level.biome.BiomeModifications;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="architectury")
public class BiomeModificationsImpl {
    private static final List<Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>> ADDITIONS = Lists.newArrayList();
    private static final List<Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>> POST_PROCESSING = Lists.newArrayList();
    private static final List<Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>> REMOVALS = Lists.newArrayList();
    private static final List<Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>> REPLACEMENTS = Lists.newArrayList();

    public static void addProperties(Predicate<BiomeModifications.BiomeContext> predicate, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable> modifier) {
        ADDITIONS.add((Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>)Pair.of(predicate, modifier));
    }

    public static void postProcessProperties(Predicate<BiomeModifications.BiomeContext> predicate, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable> modifier) {
        POST_PROCESSING.add((Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>)Pair.of(predicate, modifier));
    }

    public static void removeProperties(Predicate<BiomeModifications.BiomeContext> predicate, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable> modifier) {
        REMOVALS.add((Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>)Pair.of(predicate, modifier));
    }

    public static void replaceProperties(Predicate<BiomeModifications.BiomeContext> predicate, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable> modifier) {
        REPLACEMENTS.add((Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>)Pair.of(predicate, modifier));
    }

    private static BiomeModifications.BiomeContext wrapSelectionContext(final BiomeLoadingEvent event) {
        return new BiomeModifications.BiomeContext(){
            BiomeProperties properties;
            {
                this.properties = new BiomeWrapped(event);
            }

            @Override
            public ResourceLocation getKey() {
                return event.getName();
            }

            @Override
            public BiomeProperties getProperties() {
                return this.properties;
            }
        };
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void processAdditions(BiomeLoadingEvent event) {
        BiomeModificationsImpl.modifyBiome(event, ADDITIONS);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void processRemovals(BiomeLoadingEvent event) {
        BiomeModificationsImpl.modifyBiome(event, REMOVALS);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void processReplacements(BiomeLoadingEvent event) {
        BiomeModificationsImpl.modifyBiome(event, REPLACEMENTS);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void postProcessBiomes(BiomeLoadingEvent event) {
        BiomeModificationsImpl.modifyBiome(event, POST_PROCESSING);
    }

    private static void modifyBiome(BiomeLoadingEvent event, List<Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>> list) {
        BiomeModifications.BiomeContext biomeContext = BiomeModificationsImpl.wrapSelectionContext(event);
        MutableBiomeWrapped mutableBiome = new MutableBiomeWrapped(event);
        for (Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>> pair : list) {
            if (!((Predicate)pair.getLeft()).test(biomeContext)) continue;
            ((BiConsumer)pair.getRight()).accept(biomeContext, mutableBiome);
        }
        MutableClimatePropertiesWrapped climateProperties = (MutableClimatePropertiesWrapped)mutableBiome.getClimateProperties();
        if (climateProperties.dirty) {
            event.setClimate(new Biome.ClimateSettings(climateProperties.precipitation, climateProperties.temperature, climateProperties.temperatureModifier, climateProperties.downfall));
        }
    }

    public static class MutableBiomeWrapped
    extends BiomeWrapped
    implements BiomeProperties.Mutable {
        public MutableBiomeWrapped(BiomeLoadingEvent event) {
            super(event, new MutableClimatePropertiesWrapped(event.getClimate()), new BiomeHooks.EffectsWrapped(event.getEffects()), new MutableGenerationSettingsBuilderWrapped(event.getGeneration()), new MutableSpawnSettingsBuilderWrapped(event.getSpawns()));
        }

        @Override
        public ClimateProperties.Mutable getClimateProperties() {
            return (ClimateProperties.Mutable)super.getClimateProperties();
        }

        @Override
        public EffectsProperties.Mutable getEffectsProperties() {
            return (EffectsProperties.Mutable)super.getEffectsProperties();
        }

        @Override
        public GenerationProperties.Mutable getGenerationProperties() {
            return (GenerationProperties.Mutable)super.getGenerationProperties();
        }

        @Override
        public SpawnProperties.Mutable getSpawnProperties() {
            return (SpawnProperties.Mutable)super.getSpawnProperties();
        }

        @Override
        public BiomeProperties.Mutable setCategory(Biome.BiomeCategory category) {
            this.event.setCategory(category);
            return this;
        }
    }

    public static class MutableClimatePropertiesWrapped
    implements ClimateProperties.Mutable {
        public Biome.Precipitation precipitation;
        public float temperature;
        public Biome.TemperatureModifier temperatureModifier;
        public float downfall;
        public boolean dirty;

        public MutableClimatePropertiesWrapped(Biome.ClimateSettings settings) {
            this(settings.f_47680_, settings.f_47681_, settings.f_47682_, settings.f_47683_);
        }

        public MutableClimatePropertiesWrapped(Biome.Precipitation precipitation, float temperature, Biome.TemperatureModifier temperatureModifier, float downfall) {
            this.precipitation = precipitation;
            this.temperature = temperature;
            this.temperatureModifier = temperatureModifier;
            this.downfall = downfall;
        }

        @Override
        public Biome.Precipitation getPrecipitation() {
            return this.precipitation;
        }

        @Override
        public float getTemperature() {
            return this.temperature;
        }

        @Override
        public Biome.TemperatureModifier getTemperatureModifier() {
            return this.temperatureModifier;
        }

        @Override
        public float getDownfall() {
            return this.downfall;
        }

        @Override
        public ClimateProperties.Mutable setPrecipitation(Biome.Precipitation precipitation) {
            this.precipitation = precipitation;
            this.dirty = true;
            return this;
        }

        @Override
        public ClimateProperties.Mutable setTemperature(float temperature) {
            this.temperature = temperature;
            this.dirty = true;
            return this;
        }

        @Override
        public ClimateProperties.Mutable setTemperatureModifier(Biome.TemperatureModifier temperatureModifier) {
            this.temperatureModifier = temperatureModifier;
            this.dirty = true;
            return this;
        }

        @Override
        public ClimateProperties.Mutable setDownfall(float downfall) {
            this.downfall = downfall;
            this.dirty = true;
            return this;
        }
    }

    private static class MutableSpawnSettingsBuilderWrapped
    extends SpawnSettingsBuilderWrapped
    implements SpawnProperties.Mutable {
        public MutableSpawnSettingsBuilderWrapped(MobSpawnSettingsBuilder builder) {
            super(builder);
        }

        @Override
        public SpawnProperties.Mutable setCreatureProbability(float probability) {
            this.builder.m_48368_(probability);
            return this;
        }

        @Override
        public SpawnProperties.Mutable addSpawn(MobCategory category, MobSpawnSettings.SpawnerData data) {
            this.builder.m_48376_(category, data);
            return this;
        }

        @Override
        public boolean removeSpawns(BiPredicate<MobCategory, MobSpawnSettings.SpawnerData> predicate) {
            boolean removed = false;
            for (MobCategory type : this.builder.getSpawnerTypes()) {
                if (!this.builder.getSpawner(type).removeIf(data -> predicate.test(type, (MobSpawnSettings.SpawnerData)data))) continue;
                removed = true;
            }
            return removed;
        }

        @Override
        public SpawnProperties.Mutable setSpawnCost(EntityType<?> entityType, MobSpawnSettings.MobSpawnCost cost) {
            this.builder.m_48370_(entityType, cost.m_48400_(), cost.m_48395_());
            return this;
        }

        @Override
        public SpawnProperties.Mutable setSpawnCost(EntityType<?> entityType, double mass, double gravityLimit) {
            this.builder.m_48370_(entityType, mass, gravityLimit);
            return this;
        }

        @Override
        public SpawnProperties.Mutable clearSpawnCost(EntityType<?> entityType) {
            this.getMobSpawnCosts().remove(entityType);
            return this;
        }
    }

    private static class MutableGenerationSettingsBuilderWrapped
    extends GenerationSettingsBuilderWrapped
    implements GenerationProperties.Mutable {
        public MutableGenerationSettingsBuilderWrapped(BiomeGenerationSettingsBuilder generation) {
            super(generation);
        }

        @Override
        public GenerationProperties.Mutable addFeature(GenerationStep.Decoration decoration, Holder<PlacedFeature> feature) {
            this.generation.m_204201_(decoration, feature);
            return this;
        }

        @Override
        public GenerationProperties.Mutable addCarver(GenerationStep.Carving carving, Holder<ConfiguredWorldCarver<?>> feature) {
            this.generation.m_204198_(carving, feature);
            return this;
        }

        @Override
        public GenerationProperties.Mutable removeFeature(GenerationStep.Decoration decoration, ResourceKey<PlacedFeature> feature) {
            this.generation.getFeatures(decoration).removeIf(supplier -> supplier.m_203565_(feature));
            return this;
        }

        @Override
        public GenerationProperties.Mutable removeCarver(GenerationStep.Carving carving, ResourceKey<ConfiguredWorldCarver<?>> feature) {
            this.generation.getCarvers(carving).removeIf(supplier -> supplier.m_203565_(feature));
            return this;
        }
    }

    private static class SpawnSettingsBuilderWrapped
    implements SpawnProperties {
        protected final MobSpawnSettingsBuilder builder;

        public SpawnSettingsBuilderWrapped(MobSpawnSettingsBuilder builder) {
            this.builder = builder;
        }

        @Override
        public float getCreatureProbability() {
            return this.builder.getProbability();
        }

        @Override
        public Map<MobCategory, List<MobSpawnSettings.SpawnerData>> getSpawners() {
            return this.builder.f_48362_;
        }

        @Override
        public Map<EntityType<?>, MobSpawnSettings.MobSpawnCost> getMobSpawnCosts() {
            return this.builder.f_48363_;
        }
    }

    private static class GenerationSettingsBuilderWrapped
    implements GenerationProperties {
        protected final BiomeGenerationSettingsBuilder generation;

        public GenerationSettingsBuilderWrapped(BiomeGenerationSettingsBuilder generation) {
            this.generation = generation;
        }

        @Override
        public Iterable<Holder<ConfiguredWorldCarver<?>>> getCarvers(GenerationStep.Carving carving) {
            return this.generation.getCarvers(carving);
        }

        @Override
        public Iterable<Holder<PlacedFeature>> getFeatures(GenerationStep.Decoration decoration) {
            return this.generation.getFeatures(decoration);
        }

        @Override
        public List<Iterable<Holder<PlacedFeature>>> getFeatures() {
            return this.generation.f_47828_;
        }
    }

    public static class BiomeWrapped
    implements BiomeProperties {
        protected final BiomeLoadingEvent event;
        protected final ClimateProperties climateProperties;
        protected final EffectsProperties effectsProperties;
        protected final GenerationProperties generationProperties;
        protected final SpawnProperties spawnProperties;

        public BiomeWrapped(BiomeLoadingEvent event) {
            this(event, new BiomeHooks.ClimateWrapped(event.getClimate()), new BiomeHooks.EffectsWrapped(event.getEffects()), new GenerationSettingsBuilderWrapped(event.getGeneration()), new SpawnSettingsBuilderWrapped(event.getSpawns()));
        }

        public BiomeWrapped(BiomeLoadingEvent event, ClimateProperties climateProperties, EffectsProperties effectsProperties, GenerationProperties generationProperties, SpawnProperties spawnProperties) {
            this.event = event;
            this.climateProperties = climateProperties;
            this.effectsProperties = effectsProperties;
            this.generationProperties = generationProperties;
            this.spawnProperties = spawnProperties;
        }

        @Override
        public ClimateProperties getClimateProperties() {
            return this.climateProperties;
        }

        @Override
        public EffectsProperties getEffectsProperties() {
            return this.effectsProperties;
        }

        @Override
        public GenerationProperties getGenerationProperties() {
            return this.generationProperties;
        }

        @Override
        public SpawnProperties getSpawnProperties() {
            return this.spawnProperties;
        }

        @Override
        public Biome.BiomeCategory getCategory() {
            return this.event.getCategory();
        }
    }
}

