/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.render.curio.model;

import com.google.common.collect.ImmutableList;
import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class HeadModel
extends HumanoidModel<LivingEntity> {
    public HeadModel(ModelPart part, Function<ResourceLocation, RenderType> renderType) {
        super(part, renderType);
    }

    public HeadModel(ModelPart part) {
        this(part, RenderType::m_110458_);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.f_102808_);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of();
    }

    public static MeshDefinition createEmptyHat(CubeListBuilder head) {
        MeshDefinition mesh = HeadModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f);
        mesh.m_171576_().m_171599_("head", head, PartPose.f_171404_);
        return mesh;
    }

    public static MeshDefinition createHat(CubeListBuilder head) {
        CubeDeformation deformation = new CubeDeformation(0.5f);
        head.m_171514_(0, 0);
        head.m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, deformation);
        return HeadModel.createEmptyHat(head);
    }

    public static MeshDefinition createDiagonalHat(CubeListBuilder head, CubeListBuilder diagonalParts, String partName) {
        MeshDefinition mesh = HeadModel.createHat(head);
        mesh.m_171576_().m_171597_("head").m_171599_(partName, diagonalParts, PartPose.m_171430_((float)0.7853982f, (float)0.0f, (float)0.0f));
        return mesh;
    }

    public static MeshDefinition createDrinkingHat() {
        CubeListBuilder head = CubeListBuilder.m_171558_();
        CubeListBuilder straws = CubeListBuilder.m_171558_();
        head.m_171514_(32, 11);
        head.m_171481_(-4.0f, -6.0f, -8.0f, 8.0f, 1.0f, 4.0f);
        head.m_171514_(32, 0);
        head.m_171481_(4.0f, -11.0f, -1.0f, 3.0f, 6.0f, 3.0f);
        head.m_171514_(44, 0);
        head.m_171481_(-7.0f, -11.0f, -1.0f, 3.0f, 6.0f, 3.0f);
        head.m_171514_(32, 9);
        head.m_171481_(-6.0f, -1.0f, -5.0f, 12.0f, 1.0f, 1.0f);
        straws.m_171514_(0, 16);
        straws.m_171481_(5.0f, -4.0f, -3.0f, 1.0f, 1.0f, 8.0f);
        straws.m_171514_(18, 16);
        straws.m_171481_(-6.0f, -4.0f, -3.0f, 1.0f, 1.0f, 8.0f);
        return HeadModel.createDiagonalHat(head, straws, "straws");
    }

    public static MeshDefinition createNightVisionGoggles() {
        CubeListBuilder head = CubeListBuilder.m_171558_();
        head.m_171514_(0, 21);
        head.m_171481_(-4.0f, -6.0f, -4.95f, 8.0f, 4.0f, 1.0f);
        head.m_171514_(0, 16);
        head.m_171481_(1.5f, -5.0f, -7.95f, 2.0f, 2.0f, 3.0f);
        head.m_171514_(10, 16);
        head.m_171481_(-3.5f, -5.0f, -7.95f, 2.0f, 2.0f, 3.0f);
        return HeadModel.createHat(head);
    }

    public static MeshDefinition createSnorkel() {
        CubeListBuilder head = CubeListBuilder.m_171558_();
        CubeListBuilder tube = CubeListBuilder.m_171558_();
        head.m_171514_(32, 0);
        head.m_171481_(-2.0f, -1.5f, -6.0f, 8.0f, 2.0f, 2.0f);
        tube.m_171514_(0, 16);
        tube.m_171481_(4.01f, -5.0f, -3.0f, 2.0f, 2.0f, 12.0f);
        return HeadModel.createDiagonalHat(head, tube, "tube");
    }

    public static MeshDefinition createSuperstitiousHat() {
        CubeListBuilder head = CubeListBuilder.m_171558_();
        head.m_171514_(0, 0);
        head.m_171481_(-4.0f, -16.0f, -4.0f, 8.0f, 8.0f, 8.0f);
        head.m_171514_(0, 16);
        head.m_171481_(-5.0f, -9.0f, -5.0f, 10.0f, 1.0f, 10.0f);
        return HeadModel.createEmptyHat(head);
    }

    public static MeshDefinition createVillagerHat() {
        CubeListBuilder head = CubeListBuilder.m_171558_();
        head.m_171514_(0, 16);
        head.m_171481_(-8.0f, -5.125f, -8.0f, 16.0f, 0.0f, 16.0f);
        return HeadModel.createHat(head);
    }

    public static MeshDefinition createWhoopeeCushion() {
        CubeListBuilder head = CubeListBuilder.m_171558_();
        head.m_171514_(0, 0);
        head.m_171481_(-3.0f, -10.0f, -3.0f, 6.0f, 2.0f, 6.0f);
        head.m_171514_(0, 8);
        head.m_171481_(-2.0f, -9.25f, 3.0f, 4.0f, 0.0f, 4.0f);
        return HeadModel.createEmptyHat(head);
    }
}

