/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item.curio.belt;

import artifacts.common.config.ModConfig;
import artifacts.common.item.curio.CurioItem;
import java.util.UUID;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CrystalHeartItem
extends CurioItem {
    public CrystalHeartItem() {
        this.addListener(LivingDamageEvent.class, this::onLivingDamage);
    }

    private static AttributeModifier getHealthBonus() {
        int healthBonus = (Integer)ModConfig.server.crystalHeart.healthBonus.get();
        return new AttributeModifier(UUID.fromString("99fa0537-90b9-481a-bc76-4650987faba3"), "artifacts:crystal_heart_health_bonus", (double)healthBonus, AttributeModifier.Operation.ADDITION);
    }

    private void onLivingDamage(LivingDamageEvent event, LivingEntity wearer) {
        if (!event.isCanceled() && event.getAmount() >= 1.0f) {
            this.damageEquippedStacks(wearer, (int)event.getAmount());
        }
    }

    public void onEquip(SlotContext slotContext, ItemStack originalStack, ItemStack newStack) {
        if (!ModConfig.server.isCosmetic(this) && !slotContext.entity().f_19853_.m_5776_()) {
            AttributeInstance health = slotContext.entity().m_21051_(Attributes.f_22276_);
            AttributeModifier healthBonus = CrystalHeartItem.getHealthBonus();
            if (health != null && !health.m_22109_(healthBonus)) {
                health.m_22125_(healthBonus);
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack originalStack, ItemStack newStack) {
        if (!slotContext.entity().f_19853_.m_5776_()) {
            AttributeInstance health = slotContext.entity().m_21051_(Attributes.f_22276_);
            AttributeModifier healthBonus = CrystalHeartItem.getHealthBonus();
            if (health != null && health.m_22109_(healthBonus)) {
                health.m_22130_(healthBonus);
                if (slotContext.entity().m_21223_() > slotContext.entity().m_21233_()) {
                    slotContext.entity().m_21153_(slotContext.entity().m_21233_());
                }
            }
        }
    }

    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11673_, 1.0f, 1.0f);
    }
}

