/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api;

import java.util.ServiceLoader;
import net.darkhax.bookshelf.Constants;
import net.darkhax.bookshelf.api.data.ITagHelper;
import net.darkhax.bookshelf.api.event.IEventHelper;
import net.darkhax.bookshelf.api.registry.IGameRegistries;
import net.darkhax.bookshelf.api.util.ICreativeTabHelper;
import net.darkhax.bookshelf.api.util.IInventoryHelper;
import net.darkhax.bookshelf.api.util.IPlatformHelper;

public class Services {
    public static final IPlatformHelper PLATFORM = Services.load(IPlatformHelper.class);
    public static final IEventHelper EVENTS = Services.load(IEventHelper.class);
    public static final IGameRegistries REGISTRIES = Services.load(IGameRegistries.class);
    public static final ITagHelper TAGS = Services.load(ITagHelper.class);
    public static final ICreativeTabHelper CREATIVE_TABS = Services.load(ICreativeTabHelper.class);
    public static final IInventoryHelper INVENTORY_HELPER = Services.load(IInventoryHelper.class);

    public static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        Constants.LOG.debug("Loaded {} for service {}.", loadedService, clazz);
        return loadedService;
    }
}

