/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.client.gui.OptionScreen;
import dan200.computercraft.client.gui.widgets.ComputerSidebar;
import dan200.computercraft.client.gui.widgets.DynamicImageButton;
import dan200.computercraft.client.gui.widgets.WidgetTerminal;
import dan200.computercraft.shared.computer.core.ClientComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.inventory.ContainerComputerBase;
import dan200.computercraft.shared.computer.upload.FileUpload;
import dan200.computercraft.shared.computer.upload.UploadResult;
import dan200.computercraft.shared.network.NetworkHandler;
import dan200.computercraft.shared.network.server.ContinueUploadMessage;
import dan200.computercraft.shared.network.server.UploadFileMessage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Inventory;

public abstract class ComputerScreenBase<T extends ContainerComputerBase>
extends AbstractContainerScreen<T> {
    private static final Component OK = new TranslatableComponent("gui.ok");
    private static final Component CANCEL = new TranslatableComponent("gui.cancel");
    private static final Component OVERWRITE = new TranslatableComponent("gui.computercraft.upload.overwrite_button");
    protected WidgetTerminal terminal;
    protected final ClientComputer computer;
    protected final ComputerFamily family;
    protected final int sidebarYOffset;

    public ComputerScreenBase(T container, Inventory player, Component title, int sidebarYOffset) {
        super(container, player, title);
        this.computer = (ClientComputer)((ContainerComputerBase)container).getComputer();
        this.family = ((ContainerComputerBase)container).getFamily();
        this.sidebarYOffset = sidebarYOffset;
    }

    protected abstract WidgetTerminal createTerminal();

    protected final void m_7856_() {
        super.m_7856_();
        this.f_96541_.f_91068_.m_90926_(true);
        this.terminal = (WidgetTerminal)this.m_142416_((GuiEventListener)this.createTerminal());
        ComputerSidebar.addButtons((Screen)this, this.computer, x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        }, this.f_97735_, this.f_97736_ + this.sidebarYOffset);
        this.m_7522_((GuiEventListener)this.terminal);
    }

    public final void m_7861_() {
        super.m_7861_();
        this.f_96541_.f_91068_.m_90926_(false);
    }

    public final void m_181908_() {
        super.m_181908_();
        this.terminal.update();
    }

    public final boolean m_7933_(int key, int scancode, int modifiers) {
        if (key == 258 && this.m_7222_() != null && this.m_7222_() == this.terminal) {
            return this.m_7222_().m_7933_(key, scancode, modifiers);
        }
        return super.m_7933_(key, scancode, modifiers);
    }

    public final void m_6305_(@Nonnull PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.m_7025_(stack, mouseX, mouseY);
    }

    public boolean m_6375_(double x, double y, int button) {
        boolean changed = super.m_6375_(x, y, button);
        if (this.m_7222_() instanceof DynamicImageButton) {
            this.m_7522_((GuiEventListener)this.terminal);
        }
        return changed;
    }

    public final boolean m_7979_(double x, double y, int button, double deltaX, double deltaY) {
        return this.m_7222_() != null && this.m_7222_().m_7979_(x, y, button, deltaX, deltaY) || super.m_7979_(x, y, button, deltaX, deltaY);
    }

    protected void m_7027_(@Nonnull PoseStack transform, int mouseX, int mouseY) {
    }

    public void m_7400_(@Nonnull List<Path> files) {
        if (files.isEmpty()) {
            return;
        }
        if (this.computer == null || !this.computer.isOn()) {
            this.alert(UploadResult.FAILED_TITLE, UploadResult.COMPUTER_OFF_MSG);
            return;
        }
        long size = 0L;
        ArrayList<FileUpload> toUpload = new ArrayList<FileUpload>();
        for (Path file : files) {
            if (!Files.isRegularFile(file, new LinkOption[0])) continue;
            try {
                SeekableByteChannel sbc = Files.newByteChannel(file, new OpenOption[0]);
                try {
                    long fileSize = sbc.size();
                    if (fileSize > 524288L || (size += fileSize) >= 524288L) {
                        this.alert(UploadResult.FAILED_TITLE, UploadResult.TOO_MUCH_MSG);
                        return;
                    }
                    String name = file.getFileName().toString();
                    if (name.length() > 128) {
                        this.alert(UploadResult.FAILED_TITLE, (Component)new TranslatableComponent("gui.computercraft.upload.failed.name_too_long"));
                        return;
                    }
                    ByteBuffer buffer = ByteBuffer.allocateDirect((int)fileSize);
                    sbc.read(buffer);
                    buffer.flip();
                    byte[] digest = FileUpload.getDigest(buffer);
                    if (digest == null) {
                        this.alert(UploadResult.FAILED_TITLE, (Component)new TranslatableComponent("gui.computercraft.upload.failed.corrupted"));
                        return;
                    }
                    toUpload.add(new FileUpload(name, buffer, digest));
                }
                finally {
                    if (sbc == null) continue;
                    sbc.close();
                }
            }
            catch (IOException e) {
                ComputerCraft.log.error("Failed uploading files", (Throwable)e);
                this.alert(UploadResult.FAILED_TITLE, (Component)new TranslatableComponent("gui.computercraft.upload.failed.generic", new Object[]{"Cannot compute checksum"}));
            }
        }
        if (toUpload.size() > 32) {
            this.alert(UploadResult.FAILED_TITLE, (Component)new TranslatableComponent("gui.computercraft.upload.failed.too_many_files"));
            return;
        }
        if (toUpload.size() > 0) {
            UploadFileMessage.send(this.computer.getInstanceID(), toUpload);
        }
    }

    public void uploadResult(UploadResult result, Component message) {
        switch (result) {
            case SUCCESS: {
                this.alert(UploadResult.SUCCESS_TITLE, message);
                break;
            }
            case ERROR: {
                this.alert(UploadResult.FAILED_TITLE, message);
                break;
            }
            case CONFIRM_OVERWRITE: {
                OptionScreen.show(this.f_96541_, UploadResult.UPLOAD_OVERWRITE, message, Arrays.asList(OptionScreen.newButton(CANCEL, b -> this.cancelUpload()), OptionScreen.newButton(OVERWRITE, b -> this.continueUpload())), this::cancelUpload);
            }
        }
    }

    private void continueUpload() {
        Screen screen = this.f_96541_.f_91080_;
        if (screen instanceof OptionScreen) {
            OptionScreen screen2 = (OptionScreen)screen;
            screen2.disable();
        }
        NetworkHandler.sendToServer(new ContinueUploadMessage(this.computer.getInstanceID(), true));
    }

    private void cancelUpload() {
        this.f_96541_.m_91152_((Screen)this);
        NetworkHandler.sendToServer(new ContinueUploadMessage(this.computer.getInstanceID(), false));
    }

    private void alert(Component title, Component message) {
        OptionScreen.show(this.f_96541_, title, message, Collections.singletonList(OptionScreen.newButton(OK, b -> this.f_96541_.m_91152_((Screen)this))), () -> this.f_96541_.m_91152_((Screen)this));
    }
}

