/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Matrix4f;
import dan200.computercraft.client.render.PrintoutRenderer;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.shared.common.ContainerHeldItem;
import dan200.computercraft.shared.media.items.ItemPrintout;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class GuiPrintout
extends AbstractContainerScreen<ContainerHeldItem> {
    private final boolean book;
    private final int pages;
    private final TextBuffer[] text;
    private final TextBuffer[] colours;
    private int page;

    public GuiPrintout(ContainerHeldItem container, Inventory player, Component title) {
        super((AbstractContainerMenu)container, player, title);
        this.f_97727_ = 209;
        String[] text = ItemPrintout.getText(container.getStack());
        this.text = new TextBuffer[text.length];
        for (int i = 0; i < this.text.length; ++i) {
            this.text[i] = new TextBuffer(text[i]);
        }
        String[] colours = ItemPrintout.getColours(container.getStack());
        this.colours = new TextBuffer[colours.length];
        for (int i = 0; i < this.colours.length; ++i) {
            this.colours[i] = new TextBuffer(colours[i]);
        }
        this.page = 0;
        this.pages = Math.max(this.text.length / 21, 1);
        this.book = ((ItemPrintout)container.getStack().m_41720_()).getType() == ItemPrintout.Type.BOOK;
    }

    public boolean m_7933_(int key, int scancode, int modifiers) {
        if (super.m_7933_(key, scancode, modifiers)) {
            return true;
        }
        if (key == 262) {
            if (this.page < this.pages - 1) {
                ++this.page;
            }
            return true;
        }
        if (key == 263) {
            if (this.page > 0) {
                --this.page;
            }
            return true;
        }
        return false;
    }

    public boolean m_6050_(double x, double y, double delta) {
        if (super.m_6050_(x, y, delta)) {
            return true;
        }
        if (delta < 0.0) {
            if (this.page < this.pages - 1) {
                ++this.page;
            }
            return true;
        }
        if (delta > 0.0) {
            if (this.page > 0) {
                --this.page;
            }
            return true;
        }
        return false;
    }

    protected void m_7286_(@Nonnull PoseStack transform, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69482_();
        MultiBufferSource.BufferSource renderer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        Matrix4f matrix = transform.m_85850_().m_85861_();
        PrintoutRenderer.drawBorder(matrix, (MultiBufferSource)renderer, this.f_97735_, this.f_97736_, this.m_93252_(), this.page, this.pages, this.book, 0xF000F0);
        PrintoutRenderer.drawText(matrix, (MultiBufferSource)renderer, this.f_97735_ + 13, this.f_97736_ + 11, 21 * this.page, 0xF000F0, this.text, this.colours);
        renderer.m_109911_();
    }

    public void m_6305_(@Nonnull PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_93250_(this.m_93252_() - 1);
        this.m_7333_(stack);
        this.m_93250_(this.m_93252_() + 1);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
    }

    protected void m_7027_(@Nonnull PoseStack transform, int mouseX, int mouseY) {
    }
}

