/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import dan200.computercraft.client.render.ItemMapLikeRenderer;
import dan200.computercraft.client.render.PrintoutRenderer;
import dan200.computercraft.shared.media.items.ItemPrintout;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderItemInFrameEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="computercraft", value={Dist.CLIENT})
public final class ItemPrintoutRenderer
extends ItemMapLikeRenderer {
    private static final ItemPrintoutRenderer INSTANCE = new ItemPrintoutRenderer();

    private ItemPrintoutRenderer() {
    }

    @SubscribeEvent
    public static void onRenderInHand(RenderHandEvent event) {
        ItemStack stack = event.getItemStack();
        if (!(stack.m_41720_() instanceof ItemPrintout)) {
            return;
        }
        event.setCanceled(true);
        INSTANCE.renderItemFirstPerson(event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), event.getHand(), event.getInterpolatedPitch(), event.getEquipProgress(), event.getSwingProgress(), event.getItemStack());
    }

    @Override
    protected void renderItem(PoseStack transform, MultiBufferSource render, ItemStack stack, int light) {
        transform.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        transform.m_85841_(0.42f, 0.42f, -0.42f);
        transform.m_85837_(-0.5, (double)-0.48f, 0.0);
        ItemPrintoutRenderer.drawPrintout(transform, render, stack, light);
    }

    @SubscribeEvent
    public static void onRenderInFrame(RenderItemInFrameEvent event) {
        ItemStack stack = event.getItemStack();
        if (!(stack.m_41720_() instanceof ItemPrintout)) {
            return;
        }
        event.setCanceled(true);
        PoseStack transform = event.getPoseStack();
        transform.m_85837_(0.0, 0.0, (double)-0.001f);
        transform.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        transform.m_85841_(0.95f, 0.95f, -0.95f);
        transform.m_85837_(-0.5, -0.5, 0.0);
        int light = event.getItemFrameEntity().m_6095_() == EntityType.f_147033_ ? 15728850 : event.getPackedLight();
        ItemPrintoutRenderer.drawPrintout(transform, event.getMultiBufferSource(), stack, light);
    }

    private static void drawPrintout(PoseStack transform, MultiBufferSource render, ItemStack stack, int light) {
        int pages = ItemPrintout.getPageCount(stack);
        boolean book = ((ItemPrintout)stack.m_41720_()).getType() == ItemPrintout.Type.BOOK;
        double width = 176.0;
        double height = 211.0;
        if (!book) {
            width += (double)PrintoutRenderer.offsetAt(pages);
        }
        double visualWidth = width;
        double visualHeight = height;
        if (book) {
            visualWidth += (double)(24.0f + 2.0f * PrintoutRenderer.offsetAt(pages));
            visualHeight += 24.0;
        }
        double max = Math.max(visualHeight, visualWidth);
        float scale = (float)(1.0 / max);
        transform.m_85841_(scale, scale, scale);
        transform.m_85837_((max - width) / 2.0, (max - height) / 2.0, 0.0);
        Matrix4f matrix = transform.m_85850_().m_85861_();
        PrintoutRenderer.drawBorder(matrix, render, 0.0f, 0.0f, -0.01f, 0, pages, book, light);
        PrintoutRenderer.drawText(matrix, render, 13, 11, 0, light, ItemPrintout.getText(stack), ItemPrintout.getColours(stack));
    }
}

