/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Transformation;
import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.client.render.TileEntityTurtleRenderer;
import dan200.computercraft.client.render.TurtleMultiModel;
import dan200.computercraft.shared.turtle.items.ItemTurtle;
import dan200.computercraft.shared.util.Holiday;
import dan200.computercraft.shared.util.HolidayUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;

public class TurtleSmartItemModel
implements BakedModel {
    private static final Transformation identity;
    private static final Transformation flip;
    private final BakedModel familyModel;
    private final BakedModel colourModel;
    private final HashMap<TurtleModelCombination, BakedModel> cachedModels = new HashMap();
    private final ItemOverrides overrides;

    public TurtleSmartItemModel(BakedModel familyModel, BakedModel colourModel) {
        this.familyModel = familyModel;
        this.colourModel = colourModel;
        this.overrides = new ItemOverrides(){

            @Nonnull
            public BakedModel m_173464_(@Nonnull BakedModel originalModel, @Nonnull ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int random) {
                String label;
                boolean flip;
                boolean christmas;
                ResourceLocation overlay;
                ITurtleUpgrade rightUpgrade;
                ITurtleUpgrade leftUpgrade;
                ItemTurtle turtle = (ItemTurtle)stack.m_41720_();
                int colour = turtle.getColour(stack);
                TurtleModelCombination combo = new TurtleModelCombination(colour != -1, leftUpgrade = turtle.getUpgrade(stack, TurtleSide.LEFT), rightUpgrade = turtle.getUpgrade(stack, TurtleSide.RIGHT), overlay = turtle.getOverlay(stack), christmas = HolidayUtil.getCurrentHoliday() == Holiday.CHRISTMAS, flip = (label = turtle.getLabel(stack)) != null && (label.equals("Dinnerbone") || label.equals("Grumm")));
                BakedModel model = TurtleSmartItemModel.this.cachedModels.get(combo);
                if (model == null) {
                    model = TurtleSmartItemModel.this.buildModel(combo);
                    TurtleSmartItemModel.this.cachedModels.put(combo, model);
                }
                return model;
            }
        };
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return this.overrides;
    }

    private BakedModel buildModel(TurtleModelCombination combo) {
        Minecraft mc = Minecraft.m_91087_();
        ModelManager modelManager = mc.m_91291_().m_115103_().m_109393_();
        ModelResourceLocation overlayModelLocation = TileEntityTurtleRenderer.getTurtleOverlayModel(combo.overlay, combo.christmas);
        BakedModel baseModel = combo.colour ? this.colourModel : this.familyModel;
        BakedModel overlayModel = overlayModelLocation != null ? modelManager.m_119422_(overlayModelLocation) : null;
        Transformation transform = combo.flip ? flip : identity;
        TransformedModel leftModel = combo.leftUpgrade != null ? combo.leftUpgrade.getModel(null, TurtleSide.LEFT) : null;
        TransformedModel rightModel = combo.rightUpgrade != null ? combo.rightUpgrade.getModel(null, TurtleSide.RIGHT) : null;
        return new TurtleMultiModel(baseModel, overlayModel, transform, leftModel, rightModel);
    }

    @Nonnull
    @Deprecated
    public List<BakedQuad> m_6840_(BlockState state, Direction facing, @Nonnull Random rand) {
        return this.familyModel.m_6840_(state, facing, rand);
    }

    @Nonnull
    @Deprecated
    public List<BakedQuad> getQuads(BlockState state, Direction facing, @Nonnull Random rand, @Nonnull IModelData data) {
        return this.familyModel.getQuads(state, facing, rand, data);
    }

    public boolean m_7541_() {
        return this.familyModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.familyModel.m_7539_();
    }

    public boolean m_7521_() {
        return this.familyModel.m_7521_();
    }

    public boolean m_7547_() {
        return this.familyModel.m_7547_();
    }

    @Nonnull
    @Deprecated
    public TextureAtlasSprite m_6160_() {
        return this.familyModel.m_6160_();
    }

    @Nonnull
    @Deprecated
    public ItemTransforms m_7442_() {
        return this.familyModel.m_7442_();
    }

    static {
        PoseStack stack = new PoseStack();
        stack.m_85841_(0.0f, -1.0f, 0.0f);
        stack.m_85837_(0.0, 0.0, 1.0);
        identity = Transformation.m_121093_();
        flip = new Transformation(stack.m_85850_().m_85861_());
    }

    private record TurtleModelCombination(boolean colour, ITurtleUpgrade leftUpgrade, ITurtleUpgrade rightUpgrade, ResourceLocation overlay, boolean christmas, boolean flip) {
    }
}

