/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import dan200.computercraft.data.BasicCustomLoader;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.computer.blocks.BlockComputer;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.peripheral.modem.wired.BlockWiredModemFull;
import dan200.computercraft.shared.peripheral.modem.wireless.BlockWirelessModem;
import dan200.computercraft.shared.peripheral.monitor.BlockMonitor;
import dan200.computercraft.shared.peripheral.monitor.MonitorEdgeState;
import dan200.computercraft.shared.turtle.blocks.BlockTurtle;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;

class BlockModelProvider
extends BlockStateProvider {
    private ModelFile monitorBase;
    private ModelFile turtleBase;
    private ModelFile modemBase;

    BlockModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "computercraft", existingFileHelper);
    }

    @Nonnull
    public String m_6055_() {
        return "Block states and models";
    }

    protected void registerStatesAndModels() {
        this.monitorBase = this.models().getExistingFile(new ResourceLocation("computercraft", "block/monitor_base"));
        this.turtleBase = this.models().getExistingFile(new ResourceLocation("computercraft", "block/turtle_base"));
        this.modemBase = this.models().getExistingFile(new ResourceLocation("computercraft", "block/modem"));
        this.registerComputer((BlockComputer)Registry.ModBlocks.COMPUTER_NORMAL.get());
        this.registerComputer((BlockComputer)Registry.ModBlocks.COMPUTER_ADVANCED.get());
        this.registerComputer((BlockComputer)Registry.ModBlocks.COMPUTER_COMMAND.get());
        this.registerTurtle((BlockTurtle)Registry.ModBlocks.TURTLE_NORMAL.get());
        this.registerTurtle((BlockTurtle)Registry.ModBlocks.TURTLE_ADVANCED.get());
        this.registerWirelessModem((BlockWirelessModem)((Object)Registry.ModBlocks.WIRELESS_MODEM_NORMAL.get()));
        this.registerWirelessModem((BlockWirelessModem)((Object)Registry.ModBlocks.WIRELESS_MODEM_ADVANCED.get()));
        this.registerWiredModems();
        this.registerMonitors((BlockMonitor)((Object)Registry.ModBlocks.MONITOR_NORMAL.get()));
        this.registerMonitors((BlockMonitor)((Object)Registry.ModBlocks.MONITOR_ADVANCED.get()));
        ModelBuilder speaker = this.models().orientable(this.name((IForgeRegistryEntry)Registry.ModBlocks.SPEAKER.get()), BlockModelProvider.blockTexture((Block)Registry.ModBlocks.SPEAKER.get(), "_side"), BlockModelProvider.blockTexture((Block)Registry.ModBlocks.SPEAKER.get(), "_front"), BlockModelProvider.blockTexture((Block)Registry.ModBlocks.SPEAKER.get(), "_top"));
        this.horizontalBlock((Block)Registry.ModBlocks.SPEAKER.get(), (ModelFile)speaker);
        this.simpleBlockItem((Block)Registry.ModBlocks.SPEAKER.get(), (ModelFile)speaker);
    }

    private void registerComputer(BlockComputer<?> block) {
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
        for (ComputerState state : BlockComputer.STATE.m_6908_()) {
            BlockModelBuilder model = (BlockModelBuilder)this.models().orientable(this.extendedName((IForgeRegistryEntry<?>)block, "_" + state), BlockModelProvider.blockTexture(block, "_side"), BlockModelProvider.blockTexture(block, "_front" + state.getTexture()), BlockModelProvider.blockTexture(block, "_top"));
            for (Direction facing : BlockComputer.FACING.m_6908_()) {
                builder.partialState().with(BlockComputer.STATE, (Comparable)((Object)state)).with((Property)BlockComputer.FACING, (Comparable)facing).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, 0, BlockModelProvider.toYAngle(facing), false)});
            }
        }
        this.simpleBlockItem((Block)block, (ModelFile)this.models().getBuilder(this.extendedName((IForgeRegistryEntry<?>)block, "_blinking")));
    }

    private void registerTurtle(BlockTurtle block) {
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
        BlockModelBuilder base = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.extendedName((IForgeRegistryEntry<?>)block, "_base"))).parent(this.turtleBase)).texture("texture", this.blockTexture((Block)block));
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name((IForgeRegistryEntry<?>)block))).customLoader(BasicCustomLoader.makeFactory(new ResourceLocation("computercraft", "turtle"), x -> x.addProperty("model", base.getLocation().toString()))).end();
        for (Direction facing : BlockTurtle.FACING.m_6908_()) {
            builder.partialState().with((Property)BlockTurtle.FACING, (Comparable)facing).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, 0, BlockModelProvider.toYAngle(facing), false)});
        }
        this.simpleBlockItem((Block)block, (ModelFile)this.models().getBuilder(this.name((IForgeRegistryEntry<?>)block)));
    }

    private void registerWirelessModem(BlockWirelessModem block) {
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
        Iterator iterator = BlockWirelessModem.ON.m_6908_().iterator();
        while (iterator.hasNext()) {
            boolean on = (Boolean)iterator.next();
            ModelFile model = this.modemModel(this.extendedName((IForgeRegistryEntry<?>)block, on ? "_on" : "_off"), BlockModelProvider.blockTexture((Block)block, "_face" + (on ? "_on" : "")));
            for (Direction facing : BlockWirelessModem.FACING.m_6908_()) {
                builder.partialState().with((Property)BlockWirelessModem.FACING, (Comparable)facing).with((Property)BlockWirelessModem.ON, (Comparable)Boolean.valueOf(on)).addModels(new ConfiguredModel[]{new ConfiguredModel(model, BlockModelProvider.toXAngle(facing), BlockModelProvider.toYAngle(facing), false)});
            }
        }
        this.simpleBlockItem((Block)block, (ModelFile)this.models().getBuilder(this.extendedName((IForgeRegistryEntry<?>)block, "_off")));
    }

    private void registerWiredModems() {
        Block fullBlock = (Block)Registry.ModBlocks.WIRED_MODEM_FULL.get();
        VariantBlockStateBuilder fullBlockState = this.getVariantBuilder(fullBlock);
        Iterator iterator = BlockWiredModemFull.MODEM_ON.m_6908_().iterator();
        while (iterator.hasNext()) {
            boolean on = (Boolean)iterator.next();
            Iterator iterator2 = BlockWiredModemFull.PERIPHERAL_ON.m_6908_().iterator();
            while (iterator2.hasNext()) {
                boolean peripheral = (Boolean)iterator2.next();
                String suffix = (on ? "_on" : "_off") + (peripheral ? "_peripheral" : "");
                ResourceLocation faceTexture = new ResourceLocation("computercraft", "block/wired_modem_face" + (peripheral ? "_peripheral" : "") + (on ? "_on" : ""));
                ModelBuilder fullBlockModel = this.models().cubeAll(BlockModelProvider.blockTexture(fullBlock, suffix).toString(), faceTexture);
                fullBlockState.partialState().with((Property)BlockWiredModemFull.MODEM_ON, (Comparable)Boolean.valueOf(on)).with((Property)BlockWiredModemFull.PERIPHERAL_ON, (Comparable)Boolean.valueOf(peripheral)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)fullBlockModel)});
                this.modemModel("wired_modem" + suffix, faceTexture);
            }
        }
        this.simpleBlockItem(fullBlock, (ModelFile)this.models().getBuilder(this.extendedName((IForgeRegistryEntry<?>)fullBlock, "_off")));
        ((ItemModelBuilder)this.itemModels().getBuilder(this.name((IForgeRegistryEntry)Registry.ModItems.WIRED_MODEM.get()))).parent((ModelFile)this.models().getBuilder("wired_modem_off"));
    }

    private ModelFile modemModel(String name, ResourceLocation texture) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name)).parent(this.modemBase)).texture("front", texture)).texture("back", new ResourceLocation("computercraft", "block/modem_back"));
    }

    private void registerMonitors(BlockMonitor block) {
        String name = this.blockTexture((Block)block).toString();
        this.monitorModel(name, "", 16, 4, 0, 32);
        this.monitorModel(name, "_d", 20, 7, 0, 36);
        this.monitorModel(name, "_l", 19, 4, 1, 33);
        this.monitorModel(name, "_ld", 31, 7, 1, 45);
        this.monitorModel(name, "_lr", 18, 4, 2, 34);
        this.monitorModel(name, "_lrd", 30, 7, 2, 46);
        this.monitorModel(name, "_lru", 24, 5, 2, 40);
        this.monitorModel(name, "_lrud", 27, 6, 2, 43);
        this.monitorModel(name, "_lu", 25, 5, 1, 39);
        this.monitorModel(name, "_lud", 28, 6, 1, 42);
        this.monitorModel(name, "_r", 17, 4, 3, 35);
        this.monitorModel(name, "_rd", 29, 7, 3, 47);
        this.monitorModel(name, "_ru", 23, 5, 3, 41);
        this.monitorModel(name, "_rud", 26, 6, 3, 44);
        this.monitorModel(name, "_u", 22, 5, 0, 38);
        this.monitorModel(name, "_ud", 21, 6, 0, 37);
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
        for (MonitorEdgeState edge : BlockMonitor.STATE.m_6908_()) {
            String suffix = edge == MonitorEdgeState.NONE ? "" : "_" + edge.m_7912_();
            ModelBuilder model = this.models().getBuilder(this.extend(block.getRegistryName(), suffix));
            for (Direction facing : BlockMonitor.FACING.m_6908_()) {
                for (Direction orientation : BlockMonitor.ORIENTATION.m_6908_()) {
                    builder.partialState().with(BlockMonitor.STATE, (Comparable)((Object)edge)).with((Property)BlockMonitor.FACING, (Comparable)facing).with((Property)BlockMonitor.ORIENTATION, (Comparable)orientation).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, BlockModelProvider.toXAngle(orientation), BlockModelProvider.toYAngle(facing), false)});
                }
            }
        }
        this.simpleBlockItem((Block)block, (ModelFile)this.models().orientable(this.extendedName((IForgeRegistryEntry<?>)block, "_item"), BlockModelProvider.blockTexture((Block)block, "_4"), BlockModelProvider.blockTexture((Block)block, "_15"), BlockModelProvider.blockTexture((Block)block, "_0")));
    }

    private void monitorModel(String prefix, String corners, int front, int side, int top, int back) {
        String texturePrefix = prefix + "_";
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(prefix + corners)).parent(this.monitorBase)).texture("front", texturePrefix + front)).texture("side", texturePrefix + side)).texture("top", texturePrefix + top)).texture("back", texturePrefix + back);
    }

    private static int toXAngle(Direction direction) {
        switch (direction) {
            default: {
                return 0;
            }
            case UP: {
                return 270;
            }
            case DOWN: 
        }
        return 90;
    }

    private static int toYAngle(Direction direction) {
        return ((int)direction.m_122435_() + 180) % 360;
    }

    private static ResourceLocation blockTexture(Block block, String suffix) {
        ResourceLocation id = block.getRegistryName();
        return new ResourceLocation(id.m_135827_(), "block/" + id.m_135815_() + suffix);
    }

    @Nonnull
    private String name(@Nonnull IForgeRegistryEntry<?> term) {
        return Objects.requireNonNull(term.getRegistryName()).toString();
    }

    @Nonnull
    private String extendedName(@Nonnull IForgeRegistryEntry<?> term, @Nonnull String suffix) {
        return this.extend(Objects.requireNonNull(term.getRegistryName()), suffix);
    }

    @Nonnull
    private String extend(@Nonnull ResourceLocation location, @Nonnull String suffix) {
        return new ResourceLocation(location.m_135827_(), location.m_135815_() + suffix).toString();
    }
}

