/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.core;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.network.NetworkHandler;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PocketServerComputer
extends ServerComputer
implements IPocketAccess {
    private IPocketUpgrade upgrade;
    private Entity entity;
    private ItemStack stack;

    public PocketServerComputer(Level world, int computerID, String label, int instanceID, ComputerFamily family) {
        super(world, computerID, label, instanceID, family, ComputerCraft.pocketTermWidth, ComputerCraft.pocketTermHeight);
    }

    @Override
    @Nullable
    public Entity getEntity() {
        Entity entity = this.entity;
        if (entity == null || this.stack == null || !entity.m_6084_()) {
            return null;
        }
        if (entity instanceof Player) {
            Inventory inventory = ((Player)entity).m_150109_();
            return inventory.f_35974_.contains((Object)this.stack) || inventory.f_35976_.contains((Object)this.stack) ? entity : null;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return living.m_21205_() == this.stack || living.m_21206_() == this.stack ? entity : null;
        }
        return null;
    }

    @Override
    public int getColour() {
        return IColouredItem.getColourBasic(this.stack);
    }

    @Override
    public void setColour(int colour) {
        IColouredItem.setColourBasic(this.stack, colour);
        this.updateUpgradeNBTData();
    }

    @Override
    public int getLight() {
        CompoundTag tag = this.getUserData();
        return tag.m_128425_("Light", 99) ? tag.m_128451_("Light") : -1;
    }

    @Override
    public void setLight(int colour) {
        CompoundTag tag = this.getUserData();
        if (colour >= 0 && colour <= 0xFFFFFF) {
            if (!tag.m_128425_("Light", 99) || tag.m_128451_("Light") != colour) {
                tag.m_128405_("Light", colour);
                this.updateUserData();
            }
        } else if (tag.m_128425_("Light", 99)) {
            tag.m_128473_("Light");
            this.updateUserData();
        }
    }

    @Override
    @Nonnull
    public CompoundTag getUpgradeNBTData() {
        return ItemPocketComputer.getUpgradeInfo(this.stack);
    }

    @Override
    public void updateUpgradeNBTData() {
        Entity entity = this.entity;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_150109_().m_6596_();
        }
    }

    @Override
    public void invalidatePeripheral() {
        IPeripheral peripheral = this.upgrade == null ? null : this.upgrade.createPeripheral(this);
        this.setPeripheral(ComputerSide.BACK, peripheral);
    }

    @Override
    @Nonnull
    public Map<ResourceLocation, IPeripheral> getUpgrades() {
        return this.upgrade == null ? Collections.emptyMap() : Collections.singletonMap(this.upgrade.getUpgradeID(), this.getPeripheral(ComputerSide.BACK));
    }

    public IPocketUpgrade getUpgrade() {
        return this.upgrade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpgrade(IPocketUpgrade upgrade) {
        if (this.upgrade == upgrade) {
            return;
        }
        PocketServerComputer pocketServerComputer = this;
        synchronized (pocketServerComputer) {
            ItemPocketComputer.setUpgrade(this.stack, upgrade);
            this.updateUpgradeNBTData();
            this.upgrade = upgrade;
            this.invalidatePeripheral();
        }
    }

    public synchronized void updateValues(Entity entity, @Nonnull ItemStack stack, IPocketUpgrade upgrade) {
        if (entity != null) {
            this.setLevel(entity.m_20193_());
            this.setPosition(entity.m_142538_());
        }
        if (entity != this.entity && entity instanceof ServerPlayer) {
            this.markTerminalChanged();
        }
        this.entity = entity;
        this.stack = stack;
        if (this.upgrade != upgrade) {
            this.upgrade = upgrade;
            this.invalidatePeripheral();
        }
    }

    @Override
    public void broadcastState(boolean force) {
        Entity entity;
        super.broadcastState(force);
        if ((this.hasTerminalChanged() || force) && (entity = this.entity) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (player.f_8906_ != null && !this.isInteracting((Player)player)) {
                NetworkHandler.sendToPlayer((Player)player, this.createTerminalPacket());
            }
        }
    }
}

