/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import dan200.computercraft.ComputerCraft;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.server.ServerLifecycleHooks;

public final class IDAssigner {
    private static final LevelResource FOLDER = new LevelResource("computercraft");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type ID_TOKEN = new TypeToken<Map<String, Integer>>(){}.getType();
    private static Map<String, Integer> ids;
    private static WeakReference<MinecraftServer> server;
    private static Path idFile;

    private IDAssigner() {
    }

    public static File getDir() {
        return ServerLifecycleHooks.getCurrentServer().m_129843_(FOLDER).toFile();
    }

    private static boolean hasServerChanged() {
        if (server == null) {
            return true;
        }
        MinecraftServer currentServer = (MinecraftServer)server.get();
        return currentServer == null || currentServer != ServerLifecycleHooks.getCurrentServer();
    }

    public static synchronized int getNextId(String kind) {
        Integer existing;
        if (IDAssigner.hasServerChanged()) {
            server = new WeakReference<MinecraftServer>(ServerLifecycleHooks.getCurrentServer());
            File dir = IDAssigner.getDir();
            dir.mkdirs();
            Map newIds = null;
            idFile = new File(dir, "ids.json").toPath();
            if (Files.isRegularFile(idFile, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(idFile, StandardCharsets.UTF_8);){
                    newIds = (Map)GSON.fromJson((Reader)reader, ID_TOKEN);
                }
                catch (Exception e) {
                    ComputerCraft.log.error("Cannot load id file '" + idFile + "'", (Throwable)e);
                }
            }
            if (newIds == null) {
                newIds = new HashMap();
            }
            ids = newIds;
        }
        int next = (existing = ids.get(kind)) == null ? 0 : existing + 1;
        ids.put(kind, next);
        try (BufferedWriter writer = Files.newBufferedWriter(idFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson(ids, (Appendable)writer);
        }
        catch (Exception e) {
            ComputerCraft.log.error("Cannot update ID file '" + idFile + "'", (Throwable)e);
        }
        return next;
    }
}

