/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.wired;

import com.google.common.collect.ImmutableMap;
import dan200.computercraft.api.network.Packet;
import dan200.computercraft.api.network.wired.IWiredNetwork;
import dan200.computercraft.api.network.wired.IWiredNode;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.wired.InvariantChecker;
import dan200.computercraft.shared.wired.WiredNetworkChange;
import dan200.computercraft.shared.wired.WiredNode;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public final class WiredNetwork
implements IWiredNetwork {
    final ReadWriteLock lock = new ReentrantReadWriteLock();
    HashSet<WiredNode> nodes;
    private HashMap<String, IPeripheral> peripherals = new HashMap();

    WiredNetwork(WiredNode node) {
        this.nodes = new HashSet(1);
        this.nodes.add(node);
    }

    private WiredNetwork(HashSet<WiredNode> nodes) {
        this.nodes = nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connect(@Nonnull IWiredNode nodeU, @Nonnull IWiredNode nodeV) {
        WiredNode wiredU = WiredNetwork.checkNode(nodeU);
        WiredNode wiredV = WiredNetwork.checkNode(nodeV);
        if (nodeU == nodeV) {
            throw new IllegalArgumentException("Cannot add a connection to oneself.");
        }
        this.lock.writeLock().lock();
        try {
            boolean added;
            boolean hasV;
            if (this.nodes == null) {
                throw new IllegalStateException("Cannot add a connection to an empty network.");
            }
            boolean hasU = wiredU.network == this;
            boolean bl = hasV = wiredV.network == this;
            if (!hasU && !hasV) {
                throw new IllegalArgumentException("Neither node is in the network.");
            }
            if (!hasU || !hasV) {
                WiredNetwork other = hasU ? wiredV.network : wiredU.network;
                other.lock.writeLock().lock();
                try {
                    HashMap<String, IPeripheral> otherPeripherals = other.peripherals;
                    HashMap<String, IPeripheral> thisPeripherals = otherPeripherals.isEmpty() ? this.peripherals : new HashMap<String, IPeripheral>(this.peripherals);
                    AbstractCollection thisNodes = otherPeripherals.isEmpty() ? this.nodes : new ArrayList<WiredNode>(this.nodes);
                    HashSet<WiredNode> otherNodes = other.nodes;
                    this.nodes.addAll(otherNodes);
                    for (WiredNode node : otherNodes) {
                        node.network = this;
                    }
                    other.nodes = null;
                    other.peripherals = null;
                    this.peripherals.putAll(otherPeripherals);
                    if (!thisPeripherals.isEmpty()) {
                        WiredNetworkChange.added(thisPeripherals).broadcast(otherNodes);
                    }
                    if (!otherPeripherals.isEmpty()) {
                        WiredNetworkChange.added(otherPeripherals).broadcast(thisNodes);
                    }
                }
                finally {
                    other.lock.writeLock().unlock();
                }
            }
            if (added = wiredU.neighbours.add(wiredV)) {
                wiredV.neighbours.add(wiredU);
            }
            InvariantChecker.checkNetwork(this);
            InvariantChecker.checkNode(wiredU);
            InvariantChecker.checkNode(wiredV);
            boolean bl2 = added;
            return bl2;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean disconnect(@Nonnull IWiredNode nodeU, @Nonnull IWiredNode nodeV) {
        WiredNode wiredU = WiredNetwork.checkNode(nodeU);
        WiredNode wiredV = WiredNetwork.checkNode(nodeV);
        if (nodeU == nodeV) {
            throw new IllegalArgumentException("Cannot remove a connection to oneself.");
        }
        this.lock.writeLock().lock();
        try {
            boolean hasV;
            boolean hasU = wiredU.network == this;
            boolean bl = hasV = wiredV.network == this;
            if (!hasU || !hasV) {
                throw new IllegalArgumentException("One node is not in the network.");
            }
            if (!wiredU.neighbours.remove(wiredV)) {
                boolean bl2 = false;
                return bl2;
            }
            wiredV.neighbours.remove(wiredU);
            ArrayDeque<WiredNode> enqueued = new ArrayDeque<WiredNode>();
            HashSet<WiredNode> reachableU = new HashSet<WiredNode>();
            reachableU.add(wiredU);
            enqueued.add(wiredU);
            while (!enqueued.isEmpty()) {
                WiredNode node = (WiredNode)enqueued.remove();
                for (WiredNode neighbour : node.neighbours) {
                    if (neighbour == wiredV) {
                        boolean bl3 = true;
                        return bl3;
                    }
                    if (!reachableU.add(neighbour)) continue;
                    enqueued.add(neighbour);
                }
            }
            WiredNetwork networkU = new WiredNetwork(reachableU);
            networkU.lock.writeLock().lock();
            try {
                this.nodes.removeAll(reachableU);
                for (WiredNode node : reachableU) {
                    node.network = networkU;
                    networkU.peripherals.putAll(node.peripherals);
                    this.peripherals.keySet().removeAll(node.peripherals.keySet());
                }
                if (!this.peripherals.isEmpty()) {
                    WiredNetworkChange.removed(this.peripherals).broadcast(networkU.nodes);
                }
                if (!networkU.peripherals.isEmpty()) {
                    WiredNetworkChange.removed(networkU.peripherals).broadcast(this.nodes);
                }
                InvariantChecker.checkNetwork(this);
                InvariantChecker.checkNetwork(networkU);
                InvariantChecker.checkNode(wiredU);
                InvariantChecker.checkNode(wiredV);
                boolean bl4 = true;
                networkU.lock.writeLock().unlock();
                return bl4;
            }
            catch (Throwable throwable) {
                networkU.lock.writeLock().unlock();
                throw throwable;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(@Nonnull IWiredNode node) {
        WiredNode wired = WiredNetwork.checkNode(node);
        this.lock.writeLock().lock();
        try {
            if (this.nodes == null) {
                boolean bl = false;
                return bl;
            }
            if (this.nodes.size() <= 1) {
                boolean bl = false;
                return bl;
            }
            if (wired.network != this) {
                boolean bl = false;
                return bl;
            }
            HashSet<WiredNode> neighbours = wired.neighbours;
            this.nodes.remove(wired);
            for (WiredNode neighbour : neighbours) {
                neighbour.neighbours.remove(wired);
            }
            WiredNetwork wiredNetwork = new WiredNetwork(wired);
            if (neighbours.size() == 1) {
                this.removeSingleNode(wired, wiredNetwork);
                InvariantChecker.checkNode(wired);
                InvariantChecker.checkNetwork(wiredNetwork);
                boolean neighbour = true;
                return neighbour;
            }
            HashSet<WiredNode> reachable = WiredNetwork.reachableNodes(neighbours.iterator().next());
            if (reachable.size() == this.nodes.size()) {
                this.removeSingleNode(wired, wiredNetwork);
                InvariantChecker.checkNode(wired);
                InvariantChecker.checkNetwork(wiredNetwork);
                boolean bl = true;
                return bl;
            }
            neighbours.removeAll(reachable);
            ArrayList<WiredNetwork> maximals = new ArrayList<WiredNetwork>(neighbours.size() + 1);
            maximals.add(wiredNetwork);
            maximals.add(new WiredNetwork(reachable));
            while (!neighbours.isEmpty()) {
                reachable = WiredNetwork.reachableNodes(neighbours.iterator().next());
                neighbours.removeAll(reachable);
                maximals.add(new WiredNetwork(reachable));
            }
            for (WiredNetwork network : maximals) {
                network.lock.writeLock().lock();
            }
            try {
                wired.network = wiredNetwork;
                wired.peripherals = Collections.emptyMap();
                for (WiredNetwork network : maximals) {
                    for (WiredNode child : network.nodes) {
                        child.network = network;
                        network.peripherals.putAll(child.peripherals);
                    }
                }
                for (WiredNetwork network : maximals) {
                    InvariantChecker.checkNetwork(network);
                }
                InvariantChecker.checkNode(wired);
                for (WiredNetwork network : maximals) {
                    WiredNetworkChange.changeOf(this.peripherals, network.peripherals).broadcast(network.nodes);
                }
            }
            catch (Throwable throwable) {
                for (WiredNetwork network : maximals) {
                    network.lock.writeLock().unlock();
                }
                throw throwable;
            }
            for (WiredNetwork network : maximals) {
                network.lock.writeLock().unlock();
            }
            this.nodes.clear();
            this.peripherals.clear();
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePeripherals(@Nonnull IWiredNode node, @Nonnull Map<String, IPeripheral> newPeripherals) {
        WiredNode wired = WiredNetwork.checkNode(node);
        Objects.requireNonNull(this.peripherals, "peripherals cannot be null");
        this.lock.writeLock().lock();
        try {
            if (wired.network != this) {
                throw new IllegalStateException("Node is not on this network");
            }
            Map<String, IPeripheral> oldPeripherals = wired.peripherals;
            WiredNetworkChange change = WiredNetworkChange.changeOf(oldPeripherals, newPeripherals);
            if (change.isEmpty()) {
                return;
            }
            wired.peripherals = ImmutableMap.copyOf(newPeripherals);
            this.peripherals.keySet().removeAll(change.peripheralsRemoved().keySet());
            this.peripherals.putAll(change.peripheralsAdded());
            change.broadcast(this.nodes);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    static void transmitPacket(WiredNode start, Packet packet, double range, boolean interdimensional) {
        TransmitPoint point;
        HashMap<WiredNode, TransmitPoint> points = new HashMap<WiredNode, TransmitPoint>();
        TreeSet<TransmitPoint> transmitTo = new TreeSet<TransmitPoint>();
        TransmitPoint startEntry = start.element.getLevel() != packet.sender().getLevel() ? new TransmitPoint(start, Double.POSITIVE_INFINITY, true) : new TransmitPoint(start, start.element.getPosition().m_82554_(packet.sender().getPosition()), false);
        points.put(start, startEntry);
        transmitTo.add(startEntry);
        while ((point = (TransmitPoint)transmitTo.pollFirst()) != null) {
            Level world = point.node.element.getLevel();
            Vec3 position = point.node.element.getPosition();
            for (WiredNode neighbour : point.node.neighbours) {
                double newDistance;
                boolean newInterdimensional;
                TransmitPoint neighbourPoint = (TransmitPoint)points.get(neighbour);
                if (world != neighbour.element.getLevel()) {
                    newInterdimensional = true;
                    newDistance = Double.POSITIVE_INFINITY;
                } else {
                    newInterdimensional = false;
                    newDistance = point.distance + position.m_82554_(neighbour.element.getPosition());
                }
                if (neighbourPoint == null) {
                    TransmitPoint nextPoint = new TransmitPoint(neighbour, newDistance, newInterdimensional);
                    points.put(neighbour, nextPoint);
                    transmitTo.add(nextPoint);
                    continue;
                }
                if (!(newDistance < neighbourPoint.distance)) continue;
                transmitTo.remove(neighbourPoint);
                neighbourPoint.distance = newDistance;
                neighbourPoint.interdimensional = newInterdimensional;
                transmitTo.add(neighbourPoint);
            }
        }
        for (TransmitPoint point2 : points.values()) {
            point2.node.tryTransmit(packet, point2.distance, point2.interdimensional, range, interdimensional);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSingleNode(WiredNode wired, WiredNetwork wiredNetwork) {
        wiredNetwork.lock.writeLock().lock();
        try {
            HashMap<String, IPeripheral> wiredPeripherals = new HashMap<String, IPeripheral>(wired.peripherals);
            wired.network = wiredNetwork;
            wired.neighbours.clear();
            wired.peripherals = Collections.emptyMap();
            if (!this.peripherals.isEmpty()) {
                WiredNetworkChange.removed(this.peripherals).broadcast(wired);
            }
            this.peripherals.keySet().removeAll(wiredPeripherals.keySet());
            if (!wiredPeripherals.isEmpty()) {
                WiredNetworkChange.removed(wiredPeripherals).broadcast(this.nodes);
            }
        }
        finally {
            wiredNetwork.lock.writeLock().unlock();
        }
    }

    private static WiredNode checkNode(IWiredNode node) {
        if (node instanceof WiredNode) {
            return (WiredNode)node;
        }
        throw new IllegalArgumentException("Unknown implementation of IWiredNode: " + node);
    }

    private static HashSet<WiredNode> reachableNodes(WiredNode start) {
        WiredNode node;
        ArrayDeque<WiredNode> enqueued = new ArrayDeque<WiredNode>();
        HashSet<WiredNode> reachable = new HashSet<WiredNode>();
        reachable.add(start);
        enqueued.add(start);
        while ((node = (WiredNode)enqueued.poll()) != null) {
            for (WiredNode neighbour : node.neighbours) {
                if (!reachable.add(neighbour)) continue;
                enqueued.add(neighbour);
            }
        }
        return reachable;
    }

    private static class TransmitPoint
    implements Comparable<TransmitPoint> {
        final WiredNode node;
        double distance;
        boolean interdimensional;

        TransmitPoint(WiredNode node, double distance, boolean interdimensional) {
            this.node = node;
            this.distance = distance;
            this.interdimensional = interdimensional;
        }

        @Override
        public int compareTo(@Nonnull TransmitPoint o) {
            return this.distance == o.distance ? Integer.compare(this.node.hashCode(), o.node.hashCode()) : Double.compare(this.distance, o.distance);
        }
    }
}

