/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon;

import com.yungnickyoung.minecraft.betterdungeons.BetterDungeonsCommon;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece.SpiderDungeonBigTunnelPiece;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class SpiderDungeonStructure
extends StructureFeature<NoneFeatureConfiguration> {
    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
    }

    public SpiderDungeonStructure() {
        super(NoneFeatureConfiguration.f_67815_, context -> {
            int minY = BetterDungeonsCommon.CONFIG.spiderDungeons.spiderDungeonStartMinY;
            int maxY = BetterDungeonsCommon.CONFIG.spiderDungeons.spiderDungeonStartMaxY;
            WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
            worldgenRandom.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
            int y = worldgenRandom.nextInt(maxY - minY) + minY;
            BlockPos startPos = new BlockPos(context.f_197355_().m_151390_(), y, context.f_197355_().m_151393_());
            if (!SpiderDungeonStructure.checkLocation((PieceGeneratorSupplier.Context<NoneFeatureConfiguration>)context, startPos)) {
                return Optional.empty();
            }
            return Optional.of(SpiderDungeonStructure::generatePieces);
        });
    }

    private static boolean checkLocation(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, BlockPos startPos) {
        return context.f_197358_().test(context.f_197352_().m_203495_(QuartPos.m_175400_((int)startPos.m_123341_()), QuartPos.m_175400_((int)startPos.m_123342_()), QuartPos.m_175400_((int)startPos.m_123343_())));
    }

    private static void generatePieces(StructurePiecesBuilder structurePiecesBuilder, PieceGenerator.Context<NoneFeatureConfiguration> context) {
        int x = context.f_192705_().m_151390_();
        int z = context.f_192705_().m_151393_();
        int y = context.f_192708_().nextInt(BetterDungeonsCommon.CONFIG.spiderDungeons.spiderDungeonStartMaxY - BetterDungeonsCommon.CONFIG.spiderDungeons.spiderDungeonStartMinY) + BetterDungeonsCommon.CONFIG.spiderDungeons.spiderDungeonStartMinY;
        SpiderDungeonBigTunnelPiece startPiece = new SpiderDungeonBigTunnelPiece(x, y, z);
        structurePiecesBuilder.m_142679_((StructurePiece)startPiece);
        startPiece.m_142537_(startPiece, (StructurePieceAccessor)structurePiecesBuilder, (Random)context.f_192708_());
    }
}

