/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.misc.AMPointOfInterestRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.google.common.base.Predicates;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntitySunbird
extends Animal
implements FlyingAnimal {
    public static final Predicate<? super Entity> SCORCH_PRED = new com.google.common.base.Predicate<Entity>(){

        public boolean apply(@Nullable Entity e) {
            return e.m_6084_() && e.m_6095_().m_204039_(AMTagRegistry.SUNBIRD_SCORCH_TARGETS);
        }
    };
    public float birdPitch = 0.0f;
    public float prevBirdPitch = 0.0f;
    private int beaconSearchCooldown = 50;
    private BlockPos beaconPos = null;
    private boolean orbitClockwise = false;

    protected EntitySunbird(EntityType type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new MoveHelperController(this);
        this.orbitClockwise = new Random().nextBoolean();
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22279_, 1.0);
    }

    public static boolean canSunbirdSpawn(EntityType<? extends Mob> typeIn, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random randomIn) {
        return true;
    }

    public boolean m_5545_(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.sunbirdSpawnRolls, this.m_21187_(), spawnReasonIn);
    }

    protected SoundEvent m_7515_() {
        return AMSoundRegistry.SUNBIRD_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return AMSoundRegistry.SUNBIRD_HURT;
    }

    protected SoundEvent m_5592_() {
        return AMSoundRegistry.SUNBIRD_HURT;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(3, (Goal)new RandomFlyGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 32.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public float m_6073_() {
        return 1.0f;
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean prev = super.m_6469_(source, amount);
        if (prev) {
            if (source.m_7639_() != null && source.m_7639_() instanceof LivingEntity) {
                LivingEntity hurter = (LivingEntity)source.m_7639_();
                if (hurter.m_21023_(AMEffectRegistry.SUNBIRD_BLESSING)) {
                    hurter.m_21195_(AMEffectRegistry.SUNBIRD_BLESSING);
                }
                hurter.m_7292_(new MobEffectInstance(AMEffectRegistry.SUNBIRD_CURSE, 600, 0));
            }
            return prev;
        }
        return prev;
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_20069_()) {
            this.m_19920_(0.02f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
        } else if (this.m_20077_()) {
            this.m_19920_(0.02f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.5));
        } else {
            BlockPos ground = new BlockPos(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_());
            float f = 0.91f;
            if (this.f_19861_) {
                f = this.f_19853_.m_8055_(ground).getFriction((LevelReader)this.f_19853_, ground, (Entity)this) * 0.91f;
            }
            float f1 = 0.16277137f / (f * f * f);
            f = 0.91f;
            if (this.f_19861_) {
                f = this.f_19853_.m_8055_(ground).getFriction((LevelReader)this.f_19853_, ground, (Entity)this) * 0.91f;
            }
            this.m_21043_((LivingEntity)this, true);
            this.m_19920_(0.2f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)f));
        }
        this.m_21043_((LivingEntity)this, false);
    }

    public void m_8119_() {
        float f2;
        super.m_8119_();
        this.prevBirdPitch = this.birdPitch;
        this.birdPitch = f2 = (float)(-((double)((float)this.m_20184_().f_82480_) * 57.2957763671875));
        if (this.f_19853_.f_46443_) {
            float radius = 0.35f + this.f_19796_.nextFloat() * 1.85f;
            float angle = (float)Math.PI / 180 * ((this.f_19796_.nextBoolean() ? -85.0f : 85.0f) + this.f_20883_);
            float angleMotion = (float)Math.PI / 180 * this.f_20883_;
            double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * Mth.m_14089_((float)angle);
            double extraXMotion = -0.2f * Mth.m_14031_((float)((float)(Math.PI + (double)angleMotion)));
            double extraZMotion = -0.2f * Mth.m_14089_((float)angleMotion);
            double yRandom = 0.2f + this.f_19796_.nextFloat() * 0.3f;
            SimpleParticleType type = ParticleTypes.f_123815_;
            this.f_19853_.m_7106_((ParticleOptions)type, this.m_20185_() + extraX, this.m_20186_() + yRandom, this.m_20189_() + extraZ, extraXMotion, 0.0, extraZMotion);
        } else {
            if (this.f_19797_ % 100 == 0) {
                List list = this.f_19853_.m_6443_(LivingEntity.class, this.getScorchArea(), SCORCH_PRED);
                for (Entity e : list) {
                    e.m_20254_(4);
                    if (!(e instanceof Phantom)) continue;
                    ((Phantom)e).m_7292_(new MobEffectInstance(AMEffectRegistry.SUNBIRD_CURSE, 200, 0));
                }
                List playerList = this.f_19853_.m_6443_(Player.class, this.getScorchArea(), (Predicate)Predicates.alwaysTrue());
                for (Player e : playerList) {
                    if (e.m_21023_(AMEffectRegistry.SUNBIRD_BLESSING) || e.m_21023_(AMEffectRegistry.SUNBIRD_CURSE)) continue;
                    e.m_7292_(new MobEffectInstance(AMEffectRegistry.SUNBIRD_BLESSING, 600, 0));
                }
            }
            if (this.beaconSearchCooldown > 0) {
                --this.beaconSearchCooldown;
            }
            if (this.beaconSearchCooldown <= 0) {
                this.beaconSearchCooldown = 100 + this.f_19796_.nextInt(200);
                if (this.f_19853_ instanceof ServerLevel) {
                    List<BlockPos> beacons = this.getNearbyBeacons(this.m_142538_(), (ServerLevel)this.f_19853_, 64);
                    BlockPos closest = null;
                    for (BlockPos pos : beacons) {
                        if (closest != null && !(this.m_20275_(closest.m_123341_(), closest.m_123342_(), closest.m_123343_()) > this.m_20275_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())) || !this.isValidBeacon(pos)) continue;
                        closest = pos;
                    }
                    if (closest != null && this.isValidBeacon(closest)) {
                        this.beaconPos = closest;
                    }
                }
                if (this.beaconPos != null && !this.isValidBeacon(this.beaconPos) && this.f_19797_ > 40) {
                    this.beaconPos = null;
                }
            }
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("BeaconPosX")) {
            int i = compound.m_128451_("BeaconPosX");
            int j = compound.m_128451_("BeaconPosY");
            int k = compound.m_128451_("BeaconPosZ");
            this.beaconPos = new BlockPos(i, j, k);
        } else {
            this.beaconPos = null;
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        BlockPos blockpos = this.beaconPos;
        if (blockpos != null) {
            compound.m_128405_("BeaconPosX", blockpos.m_123341_());
            compound.m_128405_("BeaconPosY", blockpos.m_123342_());
            compound.m_128405_("BeaconPosZ", blockpos.m_123343_());
        }
    }

    private AABB getScorchArea() {
        return this.m_142469_().m_82377_(15.0, 32.0, 15.0);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        return null;
    }

    public boolean isTargetBlocked(Vec3 target) {
        Vec3 Vector3d = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        return this.f_19853_.m_45547_(new ClipContext(Vector3d, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() != HitResult.Type.MISS;
    }

    private List<BlockPos> getNearbyBeacons(BlockPos blockpos, ServerLevel world, int range) {
        PoiManager pointofinterestmanager = world.m_8904_();
        Stream stream = pointofinterestmanager.m_27138_(((PoiType)AMPointOfInterestRegistry.BEACON.get()).m_27392_(), (Predicate)Predicates.alwaysTrue(), blockpos, range, PoiManager.Occupancy.ANY);
        return stream.collect(Collectors.toList());
    }

    private boolean isValidBeacon(BlockPos pos) {
        BlockEntity te = this.f_19853_.m_7702_(pos);
        return te instanceof BeaconBlockEntity && !((BeaconBlockEntity)te).m_58702_().isEmpty();
    }

    public boolean m_142592_() {
        return true;
    }

    static class MoveHelperController
    extends MoveControl {
        private final EntitySunbird parentEntity;

        public MoveHelperController(EntitySunbird sunbird) {
            super((Mob)sunbird);
            this.parentEntity = sunbird;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vector3d = new Vec3(this.f_24975_ - this.parentEntity.m_20185_(), this.f_24976_ - this.parentEntity.m_20186_(), this.f_24977_ - this.parentEntity.m_20189_());
                double d0 = vector3d.m_82553_();
                if (d0 < this.parentEntity.m_142469_().m_82309_()) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    this.parentEntity.m_20256_(this.parentEntity.m_20184_().m_82490_(0.5));
                } else {
                    this.parentEntity.m_20256_(this.parentEntity.m_20184_().m_82549_(vector3d.m_82490_(this.f_24978_ * 0.05 / d0)));
                    if (this.parentEntity.m_5448_() == null) {
                        Vec3 vector3d1 = this.parentEntity.m_20184_();
                        this.parentEntity.m_146922_(-((float)Mth.m_14136_((double)vector3d1.f_82479_, (double)vector3d1.f_82481_)) * 57.295776f);
                        this.parentEntity.f_20883_ = this.parentEntity.m_146908_();
                    } else {
                        double d2 = this.parentEntity.m_5448_().m_20185_() - this.parentEntity.m_20185_();
                        double d1 = this.parentEntity.m_5448_().m_20189_() - this.parentEntity.m_20189_();
                        this.parentEntity.m_146922_(-((float)Mth.m_14136_((double)d2, (double)d1)) * 57.295776f);
                        this.parentEntity.f_20883_ = this.parentEntity.m_146908_();
                    }
                }
            }
        }

        private boolean canReach(Vec3 p_220673_1_, int p_220673_2_) {
            AABB axisalignedbb = this.parentEntity.m_142469_();
            for (int i = 1; i < p_220673_2_; ++i) {
                if (this.parentEntity.f_19853_.m_45756_((Entity)this.parentEntity, axisalignedbb = axisalignedbb.m_82383_(p_220673_1_))) continue;
                return false;
            }
            return true;
        }
    }

    static class RandomFlyGoal
    extends Goal {
        private final EntitySunbird parentEntity;
        private BlockPos target = null;

        public RandomFlyGoal(EntitySunbird sunbird) {
            this.parentEntity = sunbird;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            MoveControl movementcontroller = this.parentEntity.m_21566_();
            if (!movementcontroller.m_24995_() || this.target == null) {
                this.target = this.parentEntity.beaconPos != null ? this.getBlockInViewBeacon(this.parentEntity.beaconPos, 5 + this.parentEntity.f_19796_.nextInt(1)) : this.getBlockInViewSunbird();
                if (this.target != null) {
                    this.parentEntity.m_21566_().m_6849_((double)this.target.m_123341_() + 0.5, (double)this.target.m_123342_() + 0.5, (double)this.target.m_123343_() + 0.5, this.parentEntity.beaconPos != null ? 0.8 : 1.0);
                }
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.target != null && this.parentEntity.m_20238_(Vec3.m_82512_((Vec3i)this.target)) > 2.4 && this.parentEntity.m_21566_().m_24995_() && !this.parentEntity.f_19862_;
        }

        public void m_8041_() {
            this.target = null;
        }

        public void m_8037_() {
            if (this.target == null) {
                this.target = this.parentEntity.beaconPos != null ? this.getBlockInViewBeacon(this.parentEntity.beaconPos, 5 + this.parentEntity.f_19796_.nextInt(1)) : this.getBlockInViewSunbird();
            }
            if (this.parentEntity.beaconPos != null && this.parentEntity.f_19796_.nextInt(100) == 0) {
                this.parentEntity.orbitClockwise = this.parentEntity.f_19796_.nextBoolean();
            }
            if (this.target != null) {
                this.parentEntity.m_21566_().m_6849_((double)this.target.m_123341_() + 0.5, (double)this.target.m_123342_() + 0.5, (double)this.target.m_123343_() + 0.5, this.parentEntity.beaconPos != null ? 0.8 : 1.0);
                if (this.parentEntity.m_20238_(Vec3.m_82512_((Vec3i)this.target)) < 2.5) {
                    this.target = null;
                }
            }
        }

        private BlockPos getBlockInViewBeacon(BlockPos orbitPos, float gatheringCircleDist) {
            BlockPos pos;
            float angle = 0.15707964f * (float)(this.parentEntity.orbitClockwise ? -this.parentEntity.f_19797_ : this.parentEntity.f_19797_);
            double extraX = gatheringCircleDist * Mth.m_14031_((float)angle);
            double extraZ = gatheringCircleDist * Mth.m_14089_((float)angle);
            if (orbitPos != null && this.parentEntity.f_19853_.m_46859_(new BlockPos((Vec3i)(pos = new BlockPos((double)orbitPos.m_123341_() + extraX, (double)(orbitPos.m_123342_() + this.parentEntity.f_19796_.nextInt(2) + 2), (double)orbitPos.m_123343_() + extraZ))))) {
                return pos;
            }
            return null;
        }

        public BlockPos getBlockInViewSunbird() {
            float radius = -9.45f - (float)this.parentEntity.m_21187_().nextInt(24);
            float neg = this.parentEntity.m_21187_().nextBoolean() ? 1.0f : -1.0f;
            float renderYawOffset = this.parentEntity.f_20883_;
            float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.parentEntity.m_21187_().nextFloat() * neg;
            double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * Mth.m_14089_((float)angle);
            BlockPos radialPos = new BlockPos(this.parentEntity.m_20185_() + extraX, 0.0, this.parentEntity.m_20189_() + extraZ);
            BlockPos ground = this.parentEntity.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, radialPos);
            int distFromGround = (int)this.parentEntity.m_20186_() - ground.m_123342_();
            int flightHeight = Math.max(ground.m_123342_(), 230 + this.parentEntity.m_21187_().nextInt(40)) - ground.m_123342_();
            BlockPos newPos = radialPos.m_6630_(distFromGround > 16 ? flightHeight : (int)this.parentEntity.m_20186_() + this.parentEntity.m_21187_().nextInt(16) + 1);
            if (!this.parentEntity.isTargetBlocked(Vec3.m_82512_((Vec3i)newPos)) && this.parentEntity.m_20238_(Vec3.m_82512_((Vec3i)newPos)) > 6.0) {
                return newPos;
            }
            return null;
        }
    }
}

