/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.event;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.block.AMBlockRegistry;
import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import com.github.alexthe666.alexsmobs.effect.EffectClinging;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityBunfungus;
import com.github.alexthe666.alexsmobs.entity.EntityElephant;
import com.github.alexthe666.alexsmobs.entity.EntityEmu;
import com.github.alexthe666.alexsmobs.entity.EntityEndergrade;
import com.github.alexthe666.alexsmobs.entity.EntityFly;
import com.github.alexthe666.alexsmobs.entity.EntityGiantSquid;
import com.github.alexthe666.alexsmobs.entity.EntityJerboa;
import com.github.alexthe666.alexsmobs.entity.EntityMimicOctopus;
import com.github.alexthe666.alexsmobs.entity.EntityMoose;
import com.github.alexthe666.alexsmobs.entity.EntitySeaBear;
import com.github.alexthe666.alexsmobs.entity.EntitySeal;
import com.github.alexthe666.alexsmobs.entity.EntitySnowLeopard;
import com.github.alexthe666.alexsmobs.entity.EntityTiger;
import com.github.alexthe666.alexsmobs.entity.util.RainbowUtil;
import com.github.alexthe666.alexsmobs.entity.util.RockyChestplateUtil;
import com.github.alexthe666.alexsmobs.entity.util.VineLassoUtil;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.item.ItemFalconryGlove;
import com.github.alexthe666.alexsmobs.message.MessageSwingArm;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTriggerRegistry;
import com.github.alexthe666.alexsmobs.misc.EmeraldsForItemsTrade;
import com.github.alexthe666.alexsmobs.misc.ItemsForEmeraldsTrade;
import com.github.alexthe666.alexsmobs.world.BeachedCachalotWhaleSpawner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.FOVModifierEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.event.world.StructureSpawnListGatherEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;
import org.antlr.v4.runtime.misc.Triple;

@Mod.EventBusSubscriber(modid="alexsmobs", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerEvents {
    public static final UUID ALEX_UUID = UUID.fromString("71363abe-fd03-49c9-940d-aae8b8209b7c");
    public static final UUID CARRO_UUID = UUID.fromString("98905d4a-1cbc-41a4-9ded-2300404e2290");
    private static final UUID SAND_SPEED_MODIFIER = UUID.fromString("7E0292F2-9434-48D5-A29F-9583AF7DF28E");
    private static final UUID SNEAK_SPEED_MODIFIER = UUID.fromString("7E0292F2-9434-48D5-A29F-9583AF7DF28F");
    private static final AttributeModifier SAND_SPEED_BONUS = new AttributeModifier(SAND_SPEED_MODIFIER, "roadrunner speed bonus", (double)0.1f, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier SNEAK_SPEED_BONUS = new AttributeModifier(SNEAK_SPEED_MODIFIER, "frontier cap speed bonus", (double)0.1f, AttributeModifier.Operation.ADDITION);
    private static final Map<ServerLevel, BeachedCachalotWhaleSpawner> BEACHED_CACHALOT_WHALE_SPAWNER_MAP = new HashMap<ServerLevel, BeachedCachalotWhaleSpawner>();
    public static List<Triple<ServerPlayer, ServerLevel, BlockPos>> teleportPlayers = new ArrayList<Triple<ServerPlayer, ServerLevel, BlockPos>>();

    @SubscribeEvent
    public static void onServerTick(TickEvent.WorldTickEvent tick) {
        BeachedCachalotWhaleSpawner spawner;
        ServerLevel serverWorld;
        if (!tick.world.f_46443_ && tick.world instanceof ServerLevel) {
            serverWorld = (ServerLevel)tick.world;
            if (BEACHED_CACHALOT_WHALE_SPAWNER_MAP.get(serverWorld) == null) {
                BEACHED_CACHALOT_WHALE_SPAWNER_MAP.put(serverWorld, new BeachedCachalotWhaleSpawner(serverWorld));
            }
            spawner = BEACHED_CACHALOT_WHALE_SPAWNER_MAP.get(serverWorld);
            spawner.tick();
        }
        if (!tick.world.f_46443_ && tick.world instanceof ServerLevel) {
            serverWorld = (ServerLevel)tick.world;
            if (BEACHED_CACHALOT_WHALE_SPAWNER_MAP.get(serverWorld) == null) {
                BEACHED_CACHALOT_WHALE_SPAWNER_MAP.put(serverWorld, new BeachedCachalotWhaleSpawner(serverWorld));
            }
            spawner = BEACHED_CACHALOT_WHALE_SPAWNER_MAP.get(serverWorld);
            spawner.tick();
        }
        if (!tick.world.f_46443_ && tick.world instanceof ServerLevel) {
            for (Triple<ServerPlayer, ServerLevel, BlockPos> trip : teleportPlayers) {
                ServerPlayer player = (ServerPlayer)trip.a;
                ServerLevel endpointWorld = (ServerLevel)trip.b;
                BlockPos endpoint = (BlockPos)trip.c;
                player.m_8999_(endpointWorld, (double)endpoint.m_123341_() + 0.5, (double)endpoint.m_123342_() + 0.5, (double)endpoint.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
                ChunkPos chunkpos = new ChunkPos(endpoint);
                endpointWorld.m_7726_().m_8387_(TicketType.f_9448_, chunkpos, 1, (Object)player.m_142049_());
                player.f_8906_.m_141995_((Packet)new ClientboundSetExperiencePacket(player.f_36080_, player.f_36079_, player.f_36078_));
            }
            teleportPlayers.clear();
        }
    }

    protected static BlockHitResult rayTrace(Level worldIn, Player player, ClipContext.Fluid fluidMode) {
        float f = player.m_146909_();
        float f1 = player.m_146908_();
        Vec3 vector3d = player.m_20299_(1.0f);
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_();
        Vec3 vector3d1 = vector3d.m_82520_((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.m_45547_(new ClipContext(vector3d, vector3d1, ClipContext.Block.OUTLINE, fluidMode, (Entity)player));
    }

    @SubscribeEvent
    public static void onItemUseLast(LivingEntityUseItemEvent.Finish event) {
        if (event.getItem().m_41720_() == Items.f_42730_ && new Random().nextInt(3) == 0 && event.getEntityLiving().m_21023_(AMEffectRegistry.ENDER_FLU)) {
            event.getEntityLiving().m_21195_(AMEffectRegistry.ENDER_FLU);
        }
    }

    @SubscribeEvent
    public static void onEntityResize(EntityEvent.Size event) {
        if (event.getEntity() instanceof Player) {
            Player entity = (Player)event.getEntity();
            try {
                Map potions = entity.m_21221_();
                if (event.getEntity().f_19853_ != null && potions != null && !potions.isEmpty() && potions.containsKey(AMEffectRegistry.CLINGING) && EffectClinging.isUpsideDown((LivingEntity)entity)) {
                    float minus = event.getOldSize().f_20378_ - event.getOldEyeHeight();
                    event.setNewEyeHeight(minus);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        CompoundTag playerData;
        CompoundTag data;
        if (AMConfig.giveBookOnStartup && (data = (playerData = event.getPlayer().getPersistentData()).m_128469_("PlayerPersisted")) != null && !data.m_128471_("alexsmobs_has_book")) {
            ItemHandlerHelper.giveItemToPlayer((Player)event.getPlayer(), (ItemStack)new ItemStack((ItemLike)AMItemRegistry.ANIMAL_DICTIONARY.get()));
            if (event.getPlayer().m_142081_() != null && (event.getPlayer().m_142081_().equals(ALEX_UUID) || event.getPlayer().m_142081_().equals(CARRO_UUID))) {
                ItemHandlerHelper.giveItemToPlayer((Player)event.getPlayer(), (ItemStack)new ItemStack((ItemLike)AMItemRegistry.BEAR_DUST.get()));
            }
            data.m_128379_("alexsmobs_has_book", true);
            playerData.m_128365_("PlayerPersisted", (Tag)data);
        }
    }

    @SubscribeEvent
    public static void onPlayerLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        ItemFalconryGlove.onLeftClick(event.getPlayer(), event.getPlayer().m_21206_());
        ItemFalconryGlove.onLeftClick(event.getPlayer(), event.getPlayer().m_21205_());
        if (event.getWorld().f_46443_) {
            AlexsMobs.sendMSGToServer(new MessageSwingArm());
        }
    }

    @SubscribeEvent
    public static void onStruckByLightning(EntityStruckByLightningEvent event) {
        if (event.getEntity().m_6095_() == EntityType.f_20480_ && !event.getEntity().m_183503_().f_46443_) {
            ServerLevel level = (ServerLevel)event.getEntity().m_183503_();
            event.setCanceled(true);
            EntityGiantSquid squid = (EntityGiantSquid)((EntityType)AMEntityRegistry.GIANT_SQUID.get()).m_20615_((Level)level);
            squid.m_7678_(event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), event.getEntity().m_146908_(), event.getEntity().m_146909_());
            squid.m_6518_((ServerLevelAccessor)level, level.m_6436_(squid.m_142538_()), MobSpawnType.CONVERSION, null, null);
            if (event.getEntity().m_8077_()) {
                squid.m_6593_(event.getEntity().m_7770_());
                squid.m_20340_(event.getEntity().m_20151_());
            }
            squid.setBlue(true);
            squid.m_21530_();
            level.m_47205_((Entity)squid);
            event.getEntity().m_146870_();
        }
    }

    @SubscribeEvent
    public void onProjectileHit(ProjectileImpactEvent event) {
        if (event.getRayTraceResult() instanceof EntityHitResult && ((EntityHitResult)event.getRayTraceResult()).m_82443_() instanceof EntityEmu && !event.getEntity().f_19853_.f_46443_) {
            EntityEmu emu = (EntityEmu)((EntityHitResult)event.getRayTraceResult()).m_82443_();
            if (event.getEntity() instanceof AbstractArrow) {
                ((AbstractArrow)event.getEntity()).m_36767_((byte)0);
            }
            if ((emu.getAnimation() == EntityEmu.ANIMATION_DODGE_RIGHT || emu.getAnimation() == EntityEmu.ANIMATION_DODGE_LEFT) && emu.getAnimationTick() < 7) {
                event.setCanceled(true);
            }
            if (emu.getAnimation() != EntityEmu.ANIMATION_DODGE_RIGHT && emu.getAnimation() != EntityEmu.ANIMATION_DODGE_LEFT) {
                boolean left = true;
                Vec3 arrowPos = event.getEntity().m_20182_();
                Vec3 rightVector = emu.m_20154_().m_82524_(1.5707964f).m_82549_(emu.m_20182_());
                Vec3 leftVector = emu.m_20154_().m_82524_(-1.5707964f).m_82549_(emu.m_20182_());
                left = arrowPos.m_82554_(rightVector) < arrowPos.m_82554_(leftVector) ? false : (arrowPos.m_82554_(rightVector) > arrowPos.m_82554_(leftVector) ? true : emu.m_21187_().nextBoolean());
                Vec3 vector3d2 = event.getEntity().m_20184_().m_82524_((float)((double)(left ? -0.5f : 0.5f) * Math.PI)).m_82541_();
                emu.setAnimation(left ? EntityEmu.ANIMATION_DODGE_LEFT : EntityEmu.ANIMATION_DODGE_RIGHT);
                emu.f_19812_ = true;
                if (!emu.f_19862_) {
                    emu.m_6478_(MoverType.SELF, new Vec3(vector3d2.m_7096_() * 0.25, (double)0.1f, vector3d2.m_7094_() * 0.25));
                }
                if (!event.getEntity().f_19853_.f_46443_) {
                    Entity thrower;
                    ServerPlayer serverPlayerEntity = null;
                    if (event.getEntity() instanceof Arrow && (thrower = ((Arrow)event.getEntity()).m_37282_()) instanceof ServerPlayer) {
                        serverPlayerEntity = (ServerPlayer)thrower;
                    }
                    if (event.getEntity() instanceof ThrowableProjectile && (thrower = ((ThrowableProjectile)event.getEntity()).m_37282_()) instanceof ServerPlayer) {
                        serverPlayerEntity = (ServerPlayer)thrower;
                    }
                    if (serverPlayerEntity != null) {
                        AMAdvancementTriggerRegistry.EMU_DODGE.trigger(serverPlayerEntity);
                    }
                }
                emu.m_20256_(emu.m_20184_().m_82520_(vector3d2.m_7096_() * 0.5, (double)0.32f, vector3d2.m_7094_() * 0.5));
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onEntityDespawnAttempt(LivingSpawnEvent.AllowDespawn event) {
        if (event.getEntityLiving().m_21023_(AMEffectRegistry.DEBILITATING_STING) && event.getEntityLiving().m_21124_(AMEffectRegistry.DEBILITATING_STING) != null && event.getEntityLiving().m_21124_(AMEffectRegistry.DEBILITATING_STING).m_19564_() > 0) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onTradeSetup(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.f_35591_) {
            EmeraldsForItemsTrade ambergrisTrade = new EmeraldsForItemsTrade((ItemLike)AMItemRegistry.AMBERGRIS.get(), 20, 3, 4);
            List l = (List)event.getTrades().get(2);
            l.add(ambergrisTrade);
            event.getTrades().put(2, (Object)l);
        }
    }

    @SubscribeEvent
    public void onWanderingTradeSetup(WandererTradesEvent event) {
        if (AMConfig.wanderingTraderOffers) {
            List genericTrades = event.getGenericTrades();
            List rareTrades = event.getRareTrades();
            genericTrades.add(new ItemsForEmeraldsTrade((Item)AMItemRegistry.ANIMAL_DICTIONARY.get(), 4, 1, 2, 1));
            genericTrades.add(new ItemsForEmeraldsTrade((Item)AMItemRegistry.ACACIA_BLOSSOM.get(), 3, 2, 2, 1));
            if (AMConfig.cockroachSpawnWeight > 0) {
                genericTrades.add(new ItemsForEmeraldsTrade((Item)AMItemRegistry.COCKROACH_OOTHECA.get(), 2, 1, 2, 1));
            }
            if (AMConfig.blobfishSpawnWeight > 0) {
                genericTrades.add(new ItemsForEmeraldsTrade((Item)AMItemRegistry.BLOBFISH_BUCKET.get(), 4, 1, 3, 1));
            }
            if (AMConfig.crocodileSpawnWeight > 0) {
                genericTrades.add(new ItemsForEmeraldsTrade(((Block)AMBlockRegistry.CROCODILE_EGG.get()).m_5456_(), 6, 1, 2, 1));
            }
            genericTrades.add(new ItemsForEmeraldsTrade((Item)AMItemRegistry.BEAR_FUR.get(), 1, 1, 2, 1));
            genericTrades.add(new ItemsForEmeraldsTrade((Item)AMItemRegistry.CROCODILE_SCUTE.get(), 5, 1, 2, 1));
            genericTrades.add(new ItemsForEmeraldsTrade((Item)AMItemRegistry.ROADRUNNER_FEATHER.get(), 1, 2, 2, 2));
            genericTrades.add(new ItemsForEmeraldsTrade((Item)AMItemRegistry.MOSQUITO_LARVA.get(), 1, 3, 5, 1));
            rareTrades.add(new ItemsForEmeraldsTrade((Item)AMItemRegistry.SOMBRERO.get(), 20, 1, 1, 1));
            rareTrades.add(new ItemsForEmeraldsTrade((Block)AMBlockRegistry.BANANA_PEEL.get(), 1, 2, 1, 1));
            rareTrades.add(new ItemsForEmeraldsTrade((Item)AMItemRegistry.BLOOD_SAC.get(), 5, 2, 3, 1));
        }
    }

    @SubscribeEvent
    public void onLootLevelEvent(LootingLevelEvent event) {
        Entity dmgSrc;
        DamageSource src = event.getDamageSource();
        if (src != null && (dmgSrc = src.m_7639_()) != null && dmgSrc instanceof EntitySnowLeopard) {
            event.setLootingLevel(event.getLootingLevel() + 2);
        }
    }

    @SubscribeEvent
    public void onUseItem(PlayerInteractEvent.RightClickItem event) {
        BlockHitResult raytraceresult;
        if (event.getItemStack().m_41720_() == Items.f_42405_ && event.getPlayer().m_20202_() instanceof EntityElephant && ((EntityElephant)event.getPlayer().m_20202_()).triggerCharge(event.getItemStack())) {
            event.getPlayer().m_6674_(event.getHand());
            if (!event.getPlayer().m_7500_()) {
                event.getItemStack().m_41774_(1);
            }
        }
        if (event.getItemStack().m_41720_() == Items.f_42590_ && AMConfig.lavaBottleEnabled && (raytraceresult = ServerEvents.rayTrace(event.getWorld(), event.getPlayer(), ClipContext.Fluid.SOURCE_ONLY)).m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.m_82425_();
            if (event.getWorld().m_7966_(event.getPlayer(), blockpos) && event.getWorld().m_6425_(blockpos).m_205070_(FluidTags.f_13132_)) {
                event.getWorld().m_6263_(event.getPlayer(), event.getPlayer().m_20185_(), event.getPlayer().m_20186_(), event.getPlayer().m_20189_(), SoundEvents.f_11770_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                event.getPlayer().m_36246_(Stats.f_12982_.m_12902_((Object)Items.f_42590_));
                event.getPlayer().m_20254_(6);
                if (!event.getPlayer().m_36356_(new ItemStack((ItemLike)AMItemRegistry.LAVA_BOTTLE.get()))) {
                    event.getPlayer().m_19983_(new ItemStack((ItemLike)AMItemRegistry.LAVA_BOTTLE.get()));
                }
                event.getPlayer().m_6674_(event.getHand());
                if (!event.getPlayer().m_7500_()) {
                    event.getItemStack().m_41774_(1);
                }
            }
        }
    }

    @SubscribeEvent
    public void onInteractWithEntity(PlayerInteractEvent.EntityInteract event) {
        if (event.getTarget() instanceof LivingEntity && !event.getPlayer().m_6144_() && VineLassoUtil.hasLassoData((LivingEntity)event.getTarget())) {
            if (!event.getEntity().f_19853_.f_46443_) {
                event.getTarget().m_19983_(new ItemStack((ItemLike)AMItemRegistry.VINE_LASSO.get()));
            }
            VineLassoUtil.lassoTo(null, (LivingEntity)event.getTarget());
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
        if (event.getTarget() instanceof LivingEntity && !(event.getTarget() instanceof Player) && !(event.getTarget() instanceof EntityEndergrade) && ((LivingEntity)event.getTarget()).m_21023_(AMEffectRegistry.ENDER_FLU) && event.getItemStack().m_41720_() == Items.f_42730_) {
            if (!event.getPlayer().m_7500_()) {
                event.getItemStack().m_41774_(1);
            }
            event.getTarget().m_5496_(SoundEvents.f_11912_, 1.0f, 0.5f + event.getPlayer().m_21187_().nextFloat());
            if (event.getPlayer().m_21187_().nextFloat() < 0.4f) {
                ((LivingEntity)event.getTarget()).m_21195_(AMEffectRegistry.ENDER_FLU);
                Items.f_42730_.m_5922_(event.getItemStack().m_41777_(), event.getWorld(), (LivingEntity)event.getTarget());
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
        if (event.getTarget() instanceof LivingEntity && RainbowUtil.getRainbowType((LivingEntity)event.getTarget()) > 0 && event.getItemStack().m_41720_() == Items.f_41902_) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            RainbowUtil.setRainbowType((LivingEntity)event.getTarget(), 0);
            if (!event.getPlayer().m_7500_()) {
                event.getItemStack().m_41774_(1);
            }
            ItemStack wetSponge = new ItemStack((ItemLike)Items.f_41903_);
            if (!event.getPlayer().m_36356_(wetSponge)) {
                event.getPlayer().m_36176_(wetSponge, true);
            }
        }
        if (event.getTarget() instanceof Rabbit && event.getItemStack().m_41720_() == AMItemRegistry.MUNGAL_SPORES.get() && AMConfig.bunfungusTransformation) {
            Random random = new Random();
            if (!event.getEntityLiving().f_19853_.f_46443_ && random.nextFloat() < 0.15f) {
                EntityBunfungus bunfungus = (EntityBunfungus)((Rabbit)event.getTarget()).m_21406_((EntityType)AMEntityRegistry.BUNFUNGUS.get(), true);
                if (bunfungus != null) {
                    event.getPlayer().f_19853_.m_7967_((Entity)bunfungus);
                    bunfungus.setTransformsIn(50);
                }
            } else {
                for (int i = 0; i < 2 + random.nextInt(2); ++i) {
                    double d0 = random.nextGaussian() * 0.02;
                    double d1 = (double)0.05f + random.nextGaussian() * 0.02;
                    double d2 = random.nextGaussian() * 0.02;
                    event.getTarget().f_19853_.m_7106_((ParticleOptions)AMParticleRegistry.BUNFUNGUS_TRANSFORMATION, event.getTarget().m_20208_((double)0.7f), event.getTarget().m_20227_((double)0.6f), event.getTarget().m_20262_((double)0.7f), d0, d1, d2);
                }
            }
            if (!event.getPlayer().m_7500_()) {
                event.getItemStack().m_41774_(1);
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public void onUseItemAir(PlayerInteractEvent.RightClickEmpty event) {
        ItemStack stack = event.getPlayer().m_21120_(event.getHand());
        if (stack.m_41619_()) {
            stack = event.getPlayer().m_6844_(EquipmentSlot.MAINHAND);
        }
        if (RainbowUtil.getRainbowType((LivingEntity)event.getPlayer()) > 0 && stack.m_150930_(Items.f_41902_)) {
            event.getPlayer().m_6674_(InteractionHand.MAIN_HAND);
            RainbowUtil.setRainbowType((LivingEntity)event.getPlayer(), 0);
            if (!event.getPlayer().m_7500_()) {
                stack.m_41774_(1);
            }
            ItemStack wetSponge = new ItemStack((ItemLike)Items.f_41903_);
            if (!event.getPlayer().m_36356_(wetSponge)) {
                event.getPlayer().m_36176_(wetSponge, true);
            }
        }
    }

    @SubscribeEvent
    public void onUseItemOnBlock(PlayerInteractEvent.RightClickBlock event) {
        if (AlexsMobs.isAprilFools() && event.getItemStack().m_150930_(Items.f_42398_) && !event.getPlayer().m_36335_().m_41519_(Items.f_42398_)) {
            BlockState state = event.getPlayer().f_19853_.m_8055_(event.getPos());
            boolean flag = false;
            if (state.m_60713_(Blocks.f_49992_)) {
                flag = true;
                event.getPlayer().m_183503_().m_46597_(event.getPos(), ((Block)AMBlockRegistry.SAND_CIRCLE.get()).m_49966_());
            }
            if (state.m_60713_(Blocks.f_49993_)) {
                flag = true;
                event.getPlayer().m_183503_().m_46597_(event.getPos(), ((Block)AMBlockRegistry.RED_SAND_CIRCLE.get()).m_49966_());
            }
            if (flag) {
                event.setCanceled(true);
                event.getPlayer().m_5496_(SoundEvents.f_12331_, 1.0f, 1.0f);
                event.getPlayer().m_36335_().m_41524_(Items.f_42398_, 30);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    @SubscribeEvent
    public void onEntityDrops(LivingDropsEvent event) {
        if (VineLassoUtil.hasLassoData(event.getEntityLiving())) {
            VineLassoUtil.lassoTo(null, event.getEntityLiving());
            event.getDrops().add(new ItemEntity(event.getEntity().f_19853_, event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), new ItemStack((ItemLike)AMItemRegistry.VINE_LASSO.get())));
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(LivingSpawnEvent.SpecialSpawn event) {
        if (event.getEntity() instanceof WanderingTrader && AMConfig.elephantTraderSpawnChance > 0.0) {
            Random rand = new Random();
            Biome biome = (Biome)event.getWorld().m_204166_(event.getEntity().m_142538_()).m_203334_();
            if ((double)rand.nextFloat() <= AMConfig.elephantTraderSpawnChance && (!AMConfig.limitElephantTraderBiomes || biome.m_47554_() >= 1.0f)) {
                WanderingTrader traderEntity = (WanderingTrader)event.getEntity();
                EntityElephant elephant = (EntityElephant)((EntityType)AMEntityRegistry.ELEPHANT.get()).m_20615_(traderEntity.f_19853_);
                elephant.m_20359_((Entity)traderEntity);
                if (elephant.canSpawnWithTraderHere()) {
                    elephant.setTrader(true);
                    elephant.setChested(true);
                    if (!event.getWorld().m_5776_()) {
                        traderEntity.f_19853_.m_7967_((Entity)elephant);
                        traderEntity.m_7998_((Entity)elephant, true);
                    }
                    elephant.addElephantLoot(null, rand.nextInt());
                }
            }
        }
        try {
            if (event.getEntity() != null && event.getEntity() instanceof Spider && AMConfig.spidersAttackFlies) {
                Spider spider = (Spider)event.getEntity();
                spider.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)spider, EntityFly.class, 1, true, false, null));
            }
            if (event.getEntity() != null && event.getEntity() instanceof Wolf && AMConfig.wolvesAttackMoose) {
                Wolf wolf = (Wolf)event.getEntity();
                wolf.f_21346_.m_25352_(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)wolf, EntityMoose.class, false, null));
            }
            if (event.getEntity() != null && event.getEntity() instanceof PolarBear && AMConfig.polarBearsAttackSeals) {
                PolarBear bear = (PolarBear)event.getEntity();
                bear.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)bear, EntitySeal.class, 15, true, true, null));
            }
            if (event.getEntity() != null && event.getEntity() instanceof Creeper) {
                Creeper creeper = (Creeper)event.getEntity();
                creeper.f_21346_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)creeper, EntitySnowLeopard.class, 6.0f, 1.0, 1.2));
                creeper.f_21346_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)creeper, EntityTiger.class, 6.0f, 1.0, 1.2));
            }
            if (event.getEntity() != null && (event.getEntity() instanceof Fox || event.getEntity() instanceof Cat || event.getEntity() instanceof Ocelot) && AMConfig.catsAndFoxesAttackJerboas) {
                Mob mb = (Mob)event.getEntity();
                mb.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal(mb, EntityJerboa.class, 45, true, true, null));
            }
            if (event.getEntity() != null && event.getEntity() instanceof Rabbit && AMConfig.bunfungusTransformation) {
                Rabbit rabbit = (Rabbit)event.getEntity();
                rabbit.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)rabbit, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)AMItemRegistry.MUNGAL_SPORES.get()}), false));
            }
        }
        catch (Exception e) {
            AlexsMobs.LOGGER.warn("Tried to add unique behaviors to vanilla mobs and encountered an error");
        }
    }

    @SubscribeEvent
    public void onPlayerAttackEntityEvent(AttackEntityEvent event) {
        if (event.getPlayer().m_6844_(EquipmentSlot.HEAD).m_41720_() == AMItemRegistry.MOOSE_HEADGEAR.get() && event.getTarget() instanceof LivingEntity) {
            float f1 = 2.0f;
            ((LivingEntity)event.getTarget()).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(event.getPlayer().m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(event.getPlayer().m_146908_() * ((float)Math.PI / 180)))));
        }
        if (event.getPlayer().m_21023_(AMEffectRegistry.TIGERS_BLESSING) && event.getTarget() instanceof LivingEntity && !event.getTarget().m_7307_((Entity)event.getPlayer()) && !(event.getTarget() instanceof EntityTiger)) {
            AABB bb = new AABB(event.getPlayer().m_20185_() - 32.0, event.getPlayer().m_20186_() - 32.0, event.getPlayer().m_20189_() - 32.0, event.getPlayer().m_20189_() + 32.0, event.getPlayer().m_20186_() + 32.0, event.getPlayer().m_20189_() + 32.0);
            List tigers = event.getPlayer().f_19853_.m_6443_(EntityTiger.class, bb, EntitySelector.f_20402_);
            for (EntityTiger tiger : tigers) {
                if (tiger.m_6162_()) continue;
                tiger.m_6710_((LivingEntity)event.getTarget());
            }
        }
    }

    @SubscribeEvent
    public void onLivingDamageEvent(LivingDamageEvent event) {
        LivingEntity attacker;
        if (event.getSource().m_7639_() instanceof LivingEntity) {
            attacker = (LivingEntity)event.getSource().m_7639_();
            if (event.getAmount() > 0.0f && attacker.m_21023_(AMEffectRegistry.SOULSTEAL) && attacker.m_21124_(AMEffectRegistry.SOULSTEAL) != null) {
                int level = attacker.m_21124_(AMEffectRegistry.SOULSTEAL).m_19564_() + 1;
                Random rand = new Random();
                if (attacker.m_21223_() < attacker.m_21233_() && rand.nextFloat() < 0.25f + (float)level * 0.25f) {
                    attacker.m_5634_(Math.min(event.getAmount() / 2.0f * (float)level, (float)(2 + 2 * level)));
                }
            }
        }
        if (event.getEntityLiving() instanceof Player && event.getSource().m_7639_() instanceof LivingEntity) {
            attacker = (LivingEntity)event.getSource().m_7639_();
            Player player = (Player)event.getEntityLiving();
            if (attacker instanceof EntityMimicOctopus && ((EntityMimicOctopus)attacker).m_21830_((LivingEntity)player)) {
                event.setCanceled(true);
                return;
            }
            if (player.m_6844_(EquipmentSlot.HEAD).m_41720_() == AMItemRegistry.SPIKED_TURTLE_SHELL.get()) {
                float f1 = 1.0f;
                if (attacker.m_20270_((Entity)player) < attacker.m_20205_() + player.m_20205_() + 0.5f) {
                    attacker.m_6469_(DamageSource.m_19335_((Entity)player), 1.0f);
                    attacker.m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)((attacker.m_146908_() + 180.0f) * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)((attacker.m_146908_() + 180.0f) * ((float)Math.PI / 180)))));
                }
            }
        }
        if (!event.getEntityLiving().m_6844_(EquipmentSlot.LEGS).m_41619_() && event.getEntityLiving().m_6844_(EquipmentSlot.LEGS).m_41720_() == AMItemRegistry.EMU_LEGGINGS.get() && event.getSource().m_19360_() && (double)event.getEntityLiving().m_21187_().nextFloat() < AMConfig.emuPantsDodgeChance) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onStructureGetSpawnLists(StructureSpawnListGatherEvent event) {
        if (AMConfig.mimicubeSpawnInEndCity && AMConfig.mimicubeSpawnWeight > 0 && event.getStructure() == StructureFeature.f_67026_) {
            event.addEntitySpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.MIMICUBE.get(), AMConfig.mimicubeSpawnWeight, 1, 3));
        }
        if (AMConfig.soulVultureSpawnOnFossil && AMConfig.soulVultureSpawnWeight > 0 && event.getStructure() == StructureFeature.f_67029_) {
            event.addEntitySpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.SOUL_VULTURE.get(), AMConfig.soulVultureSpawnWeight, 1, 1));
        }
    }

    @SubscribeEvent
    public void onLivingSetTargetEvent(LivingSetAttackTargetEvent event) {
        if (event.getTarget() != null && event.getEntityLiving() instanceof Mob && event.getEntityLiving().m_6336_() == MobType.f_21642_ && event.getTarget().m_21023_(AMEffectRegistry.BUG_PHEROMONES) && event.getEntityLiving().m_142581_() != event.getTarget()) {
            ((Mob)event.getEntityLiving()).m_6710_(null);
        }
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        Random random;
        ItemStack boots;
        if (event.getEntityLiving() instanceof Player) {
            if ((double)event.getEntityLiving().m_20192_() < (double)event.getEntityLiving().m_20206_() * 0.5) {
                event.getEntityLiving().m_6210_();
            }
            AttributeInstance modifiableattributeinstance = event.getEntityLiving().m_21051_(Attributes.f_22279_);
            if (event.getEntityLiving().m_6844_(EquipmentSlot.FEET).m_41720_() == AMItemRegistry.ROADDRUNNER_BOOTS.get() || modifiableattributeinstance.m_22109_(SAND_SPEED_BONUS)) {
                boolean sand = event.getEntityLiving().f_19853_.m_8055_(this.getDownPos(event.getEntityLiving().m_142538_(), (LevelAccessor)event.getEntityLiving().f_19853_)).m_204336_(BlockTags.f_13029_);
                if (sand && !modifiableattributeinstance.m_22109_(SAND_SPEED_BONUS)) {
                    modifiableattributeinstance.m_22125_(SAND_SPEED_BONUS);
                }
                if (event.getEntityLiving().f_19797_ % 25 == 0 && (event.getEntityLiving().m_6844_(EquipmentSlot.FEET).m_41720_() != AMItemRegistry.ROADDRUNNER_BOOTS.get() || !sand) && modifiableattributeinstance.m_22109_(SAND_SPEED_BONUS)) {
                    modifiableattributeinstance.m_22130_(SAND_SPEED_BONUS);
                }
            }
            if (event.getEntityLiving().m_6844_(EquipmentSlot.HEAD).m_41720_() == AMItemRegistry.FRONTIER_CAP.get() || modifiableattributeinstance.m_22109_(SNEAK_SPEED_BONUS)) {
                if (event.getEntityLiving().m_6144_() && !modifiableattributeinstance.m_22109_(SNEAK_SPEED_BONUS)) {
                    modifiableattributeinstance.m_22125_(SNEAK_SPEED_BONUS);
                }
                if ((!event.getEntityLiving().m_6144_() || event.getEntityLiving().m_6844_(EquipmentSlot.HEAD).m_41720_() != AMItemRegistry.FRONTIER_CAP.get()) && modifiableattributeinstance.m_22109_(SNEAK_SPEED_BONUS)) {
                    modifiableattributeinstance.m_22130_(SNEAK_SPEED_BONUS);
                }
            }
            if (event.getEntityLiving().m_6844_(EquipmentSlot.HEAD).m_41720_() == AMItemRegistry.SPIKED_TURTLE_SHELL.get() && !event.getEntityLiving().m_204029_(FluidTags.f_13131_)) {
                event.getEntityLiving().m_7292_(new MobEffectInstance(MobEffects.f_19608_, 210, 0, false, false, true));
            }
        }
        if (!(boots = event.getEntityLiving().m_6844_(EquipmentSlot.FEET)).m_41619_() && boots.m_41782_() && boots.m_41784_().m_128441_("BisonFur") && boots.m_41784_().m_128471_("BisonFur")) {
            BlockPos pos = new BlockPos(event.getEntityLiving().m_20185_(), event.getEntity().m_20186_() - 0.5, event.getEntityLiving().m_20189_());
            if (event.getEntityLiving().f_19853_.m_8055_(pos).m_60713_(Blocks.f_152499_)) {
                event.getEntityLiving().m_6853_(true);
                event.getEntityLiving().m_146917_(0);
            }
            if (event.getEntityLiving().f_146808_) {
                float f = 0.0f;
                event.getEntityLiving().m_6034_(event.getEntityLiving().m_20185_(), (double)(pos.m_123342_() + 1), event.getEntityLiving().m_20189_());
            }
        }
        if (event.getEntityLiving().m_6844_(EquipmentSlot.LEGS).m_41720_() == AMItemRegistry.CENTIPEDE_LEGGINGS.get() && event.getEntityLiving().f_19862_ && !event.getEntityLiving().m_20069_()) {
            event.getEntityLiving().f_19789_ = 0.0f;
            Vec3 motion = event.getEntityLiving().m_20184_();
            double d0 = Mth.m_14008_((double)motion.f_82479_, (double)-0.15f, (double)0.15f);
            double d1 = Mth.m_14008_((double)motion.f_82481_, (double)-0.15f, (double)0.15f);
            double d2 = 0.1;
            if (d2 < 0.0 && !event.getEntityLiving().m_146900_().isScaffolding(event.getEntityLiving()) && event.getEntityLiving().m_5791_()) {
                d2 = 0.0;
            }
            motion = new Vec3(d0, d2, d1);
            event.getEntityLiving().m_20256_(motion);
        }
        if (event.getEntityLiving().m_6844_(EquipmentSlot.HEAD).m_41720_() == AMItemRegistry.SOMBRERO.get() && !event.getEntityLiving().f_19853_.f_46443_ && AlexsMobs.isAprilFools() && event.getEntityLiving().m_20072_() && (random = event.getEntityLiving().m_21187_()).nextInt(245) == 0 && !EntitySeaBear.isMobSafe((Entity)event.getEntityLiving())) {
            int dist = 32;
            List nearbySeabears = event.getEntityLiving().f_19853_.m_45976_(EntitySeaBear.class, event.getEntityLiving().m_142469_().m_82377_((double)dist, (double)dist, (double)dist));
            if (nearbySeabears.isEmpty()) {
                EntitySeaBear bear = (EntitySeaBear)((EntityType)AMEntityRegistry.SEA_BEAR.get()).m_20615_(event.getEntityLiving().f_19853_);
                BlockPos at = event.getEntityLiving().m_142538_();
                BlockPos farOff = null;
                for (int i = 0; i < 15; ++i) {
                    int f1 = (int)Math.signum(random.nextFloat() - 0.5f);
                    int f2 = (int)Math.signum(random.nextFloat() - 0.5f);
                    BlockPos pos1 = at.m_142082_(f1 * (10 + random.nextInt(dist - 10)), random.nextInt(1), f2 * (10 + random.nextInt(dist - 10)));
                    BlockState state = event.getEntityLiving().m_183503_().m_8055_(pos1);
                    if (!event.getEntityLiving().f_19853_.m_46801_(pos1)) continue;
                    farOff = pos1;
                }
                if (farOff != null) {
                    bear.m_6034_((float)farOff.m_123341_() + 0.5f, (float)farOff.m_123342_() + 0.5f, (float)farOff.m_123343_() + 0.5f);
                    bear.m_146922_(random.nextFloat() * 360.0f);
                    bear.m_6710_(event.getEntityLiving());
                    event.getEntityLiving().f_19853_.m_7967_((Entity)bear);
                }
            } else {
                for (EntitySeaBear bear : nearbySeabears) {
                    bear.m_6710_(event.getEntityLiving());
                }
            }
        }
        if (VineLassoUtil.hasLassoData(event.getEntityLiving())) {
            VineLassoUtil.tickLasso(event.getEntityLiving());
        }
        if (RockyChestplateUtil.isWearing(event.getEntityLiving())) {
            RockyChestplateUtil.tickRockyRolling(event.getEntityLiving());
        }
    }

    private BlockPos getDownPos(BlockPos entered, LevelAccessor world) {
        for (int i = 0; world.m_46859_(entered) && i < 3; ++i) {
            entered = entered.m_7495_();
        }
        return entered;
    }

    @SubscribeEvent
    public void onFOVUpdate(FOVModifierEvent event) {
        if (event.getEntity().m_21023_(AMEffectRegistry.FEAR) || event.getEntity().m_21023_(AMEffectRegistry.POWER_DOWN)) {
            event.setNewfov(1.0f);
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        Entity attacker;
        if (!event.getEntityLiving().m_21211_().m_41619_() && event.getSource() != null && event.getSource().m_7639_() != null && event.getEntityLiving().m_21211_().m_41720_() == AMItemRegistry.SHIELD_OF_THE_DEEP.get() && (attacker = event.getSource().m_7639_()) instanceof LivingEntity) {
            boolean flag = false;
            if (attacker.m_20270_((Entity)event.getEntityLiving()) <= 4.0f && !((LivingEntity)attacker).m_21023_(AMEffectRegistry.EXSANGUINATION)) {
                ((LivingEntity)attacker).m_7292_(new MobEffectInstance(AMEffectRegistry.EXSANGUINATION, 60, 2));
                flag = true;
            }
            if (event.getEntityLiving().m_20072_()) {
                event.getEntityLiving().m_20301_(Math.min(event.getEntityLiving().m_6062_(), event.getEntityLiving().m_20146_() + 150));
                flag = true;
            }
            if (flag) {
                event.getEntityLiving().m_21211_().m_41622_(1, event.getEntityLiving(), playerIn -> playerIn.m_21190_(event.getEntityLiving().m_7655_()));
            }
        }
    }

    @SubscribeEvent
    public void onChestGenerated(LootTableLoadEvent event) {
        LootPool.Builder builder;
        LootPoolSingletonContainer.Builder item;
        if (AMConfig.addLootToChests) {
            if (event.getName().equals((Object)BuiltInLootTables.f_78686_)) {
                item = LootItem.m_79579_((ItemLike)((ItemLike)AMItemRegistry.ANCIENT_DART.get())).m_79711_(40).m_79707_(1);
                builder = new LootPool.Builder().name("am_dart").m_79076_((LootPoolEntryContainer.Builder)item).m_6509_(LootItemRandomChanceCondition.m_81927_((float)1.0f)).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f));
                event.getTable().addPool(builder.m_79082_());
            }
            if (event.getName().equals((Object)BuiltInLootTables.f_78687_)) {
                item = LootItem.m_79579_((ItemLike)((ItemLike)AMItemRegistry.ANCIENT_DART.get())).m_79711_(20).m_79707_(3);
                builder = new LootPool.Builder().name("am_dart_dispenser").m_79076_((LootPoolEntryContainer.Builder)item).m_6509_(LootItemRandomChanceCondition.m_81927_((float)1.0f)).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f)).m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f));
                event.getTable().addPool(builder.m_79082_());
            }
        }
        if (event.getName().equals((Object)BuiltInLootTables.f_78738_) && AMConfig.tusklinShoesBarteringChance > 0.0) {
            item = LootItem.m_79579_((ItemLike)((ItemLike)AMItemRegistry.PIGSHOES.get())).m_79711_(5).m_79707_(8);
            builder = new LootPool.Builder().name("am_pigshoes").m_79076_((LootPoolEntryContainer.Builder)item).m_6509_(LootItemRandomChanceCondition.m_81927_((float)((float)AMConfig.tusklinShoesBarteringChance))).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f));
            event.getTable().addPool(builder.m_79082_());
        }
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        if (event.getItemStack().m_41782_() && event.getItemStack().m_41784_().m_128441_("BisonFur") && event.getItemStack().m_41784_().m_128471_("BisonFur")) {
            event.getToolTip().add(new TranslatableComponent("item.alexsmobs.insulated_with_fur").m_130940_(ChatFormatting.AQUA));
        }
    }
}

