/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.world;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class AMWorldData
extends SavedData {
    private static final String IDENTIFIER = "alexsmobs_world_data";
    private Level world;
    private int tickCounter;
    private int beachedCachalotSpawnDelay;
    private int beachedCachalotSpawnChance;
    private UUID beachedCachalotID;

    public static AMWorldData get(Level world) {
        if (world instanceof ServerLevel) {
            ServerLevel overworld = world.m_142572_().m_129880_(Level.f_46428_);
            DimensionDataStorage storage = overworld.m_8895_();
            AMWorldData data = (AMWorldData)storage.m_164861_(AMWorldData::load, AMWorldData::new, IDENTIFIER);
            if (data != null) {
                data.world = world;
                data.m_77762_();
            }
            return data;
        }
        return null;
    }

    public int getBeachedCachalotSpawnDelay() {
        return this.beachedCachalotSpawnDelay;
    }

    public void setBeachedCachalotSpawnDelay(int delay) {
        this.beachedCachalotSpawnDelay = delay;
    }

    public int getBeachedCachalotSpawnChance() {
        return this.beachedCachalotSpawnChance;
    }

    public void setBeachedCachalotSpawnChance(int chance) {
        this.beachedCachalotSpawnChance = chance;
    }

    public void setBeachedCachalotID(UUID id) {
        this.beachedCachalotID = id;
    }

    public void debug() {
    }

    public void tick() {
        ++this.tickCounter;
    }

    public static AMWorldData load(CompoundTag nbt) {
        AMWorldData data = new AMWorldData();
        if (nbt.m_128425_("BeachedCachalotSpawnDelay", 99)) {
            data.beachedCachalotSpawnDelay = nbt.m_128451_("BeachedCachalotSpawnDelay");
        }
        if (nbt.m_128425_("BeachedCachalotSpawnChance", 99)) {
            data.beachedCachalotSpawnChance = nbt.m_128451_("BeachedCachalotSpawnChance");
        }
        if (nbt.m_128425_("BeachedCachalotId", 8)) {
            data.beachedCachalotID = UUID.fromString(nbt.m_128461_("BeachedCachalotId"));
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        compound.m_128405_("beachedCachalotSpawnDelay", this.beachedCachalotSpawnDelay);
        compound.m_128405_("beachedCachalotSpawnChance", this.beachedCachalotSpawnChance);
        if (this.beachedCachalotID != null) {
            compound.m_128359_("beachedCachalotId", this.beachedCachalotID.toString());
        }
        return compound;
    }
}

