/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;

public class TagDifferencePresentCondition<T>
implements ICondition {
    private static final ResourceLocation NAME = TConstruct.getResource("tag_difference_present");
    public static final Serializer SERIALIZER = new Serializer();
    private final TagKey<T> base;
    private final List<TagKey<T>> subtracted;

    public TagDifferencePresentCondition(TagKey<T> base, List<TagKey<T>> subtracted) {
        if (subtracted.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a condition with no subtracted");
        }
        this.base = base;
        this.subtracted = subtracted;
    }

    @SafeVarargs
    public static <T> TagDifferencePresentCondition<T> ofKeys(TagKey<T> base, TagKey<T> ... subtracted) {
        return new TagDifferencePresentCondition<T>(base, Arrays.asList(subtracted));
    }

    public static <T> TagDifferencePresentCondition<T> ofNames(ResourceKey<? extends Registry<T>> registry, ResourceLocation base, ResourceLocation ... subtracted) {
        TagKey baseKey = TagKey.m_203882_(registry, (ResourceLocation)base);
        return new TagDifferencePresentCondition<T>(baseKey, Arrays.stream(subtracted).map(name -> TagKey.m_203882_((ResourceKey)registry, (ResourceLocation)name)).toList());
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test() {
        TConstruct.LOG.error("Calling TagDifferencePresentCondition method with no context, unable to properly test");
        return false;
    }

    public boolean test(ICondition.IContext context) {
        Tag base = context.getTag(this.base);
        if (base == null || base.m_6497_().isEmpty()) {
            return false;
        }
        if (this.subtracted.isEmpty()) {
            return true;
        }
        block0: for (Holder entry : base.m_6497_()) {
            for (TagKey<T> tag : this.subtracted) {
                if (!context.getTag(tag).m_6497_().contains(entry)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    private static class Serializer
    implements IConditionSerializer<TagDifferencePresentCondition<?>> {
        private Serializer() {
        }

        public void write(JsonObject json, TagDifferencePresentCondition<?> value) {
            json.addProperty("registry", value.base.f_203867_().m_135782_().toString());
            json.addProperty("base", value.base.f_203868_().toString());
            JsonArray names = new JsonArray();
            for (TagKey name : value.subtracted) {
                names.add(name.f_203868_().toString());
            }
            json.add("subtracted", (JsonElement)names);
        }

        private static <T> TagDifferencePresentCondition<T> readGeneric(JsonObject json) {
            ResourceKey registry = ResourceKey.m_135788_((ResourceLocation)JsonHelper.getResourceLocation((JsonObject)json, (String)"registry"));
            return new TagDifferencePresentCondition(TagKey.m_203882_((ResourceKey)registry, (ResourceLocation)JsonHelper.getResourceLocation((JsonObject)json, (String)"base")), JsonHelper.parseList((JsonObject)json, (String)"subtracted", (e, s) -> TagKey.m_203882_((ResourceKey)registry, (ResourceLocation)JsonHelper.convertToResourceLocation((JsonElement)e, (String)s))));
        }

        public TagDifferencePresentCondition<?> read(JsonObject json) {
            return Serializer.readGeneric(json);
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

