/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.impl;

import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.capability.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class InventoryModifier
extends Modifier
implements ToolInventoryCapability.IInventoryModifier {
    protected static final BiFunction<CompoundTag, String, ListTag> GET_COMPOUND_LIST = (nbt, name) -> nbt.m_128437_(name, 10);
    private static final ValidatedResult HAS_ITEMS = ValidatedResult.failure(TConstruct.makeTranslationKey("modifier", "inventory_cannot_remove"), new Object[0]);
    protected static final String TAG_SLOT = "Slot";
    private final ResourceLocation inventoryKey;
    private final int slotsPerLevel;

    @Override
    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        ToolInventoryCapability.addSlots(volatileData, this.getSlots(context, level));
    }

    @Override
    public ValidatedResult validate(IToolStackView tool, int level) {
        ListTag listNBT;
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(this.inventoryKey, 9) && !(listNBT = persistentData.get(this.inventoryKey, GET_COMPOUND_LIST)).isEmpty()) {
            if (level == 0) {
                return HAS_ITEMS;
            }
            int maxSlots = this.getSlots(tool, level);
            for (int i = 0; i < listNBT.size(); ++i) {
                CompoundTag compoundNBT = listNBT.m_128728_(i);
                if (compoundNBT.m_128451_(TAG_SLOT) < maxSlots) continue;
                return HAS_ITEMS;
            }
        }
        return ValidatedResult.PASS;
    }

    @Override
    public void onRemoved(IToolStackView tool) {
        tool.getPersistentData().remove(this.inventoryKey);
    }

    @Override
    public ItemStack getStack(IToolStackView tool, int level, int slot) {
        ModDataNBT modData = tool.getPersistentData();
        if (slot < this.getSlots(tool, level) && modData.contains(this.inventoryKey, 9)) {
            ListTag list = tool.getPersistentData().get(this.inventoryKey, GET_COMPOUND_LIST);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag compound = list.m_128728_(i);
                if (compound.m_128451_(TAG_SLOT) != slot) continue;
                return ItemStack.m_41712_((CompoundTag)compound);
            }
        }
        return ItemStack.f_41583_;
    }

    @Override
    public void setStack(IToolStackView tool, int level, int slot, ItemStack stack) {
        if (slot < this.getSlots(tool, level)) {
            ListTag list;
            ModDataNBT modData = tool.getPersistentData();
            if (modData.contains(this.inventoryKey, 9)) {
                list = modData.get(this.inventoryKey, GET_COMPOUND_LIST);
                for (int i = 0; i < list.size(); ++i) {
                    CompoundTag compound = list.m_128728_(i);
                    if (compound.m_128451_(TAG_SLOT) != slot) continue;
                    if (stack.m_41619_()) {
                        list.remove(i);
                    } else {
                        compound.m_128431_().clear();
                        stack.m_41739_(compound);
                        compound.m_128405_(TAG_SLOT, slot);
                    }
                    return;
                }
            } else {
                if (stack.m_41619_()) {
                    return;
                }
                list = new ListTag();
                modData.put(this.inventoryKey, (Tag)list);
            }
            if (!stack.m_41619_()) {
                list.add((Object)InventoryModifier.write(stack, slot));
            }
        }
    }

    public int getSlots(IToolContext tool, int level) {
        return level * this.slotsPerLevel;
    }

    @Override
    public final int getSlots(IToolStackView tool, int level) {
        return this.getSlots((IToolContext)tool, level);
    }

    @Override
    @Nullable
    public <T> T getModule(Class<T> type) {
        return InventoryModifier.tryModuleMatch(type, ToolInventoryCapability.IInventoryModifier.class, this);
    }

    protected static CompoundTag write(ItemStack stack, int slot) {
        CompoundTag compound = new CompoundTag();
        stack.m_41739_(compound);
        compound.m_128405_(TAG_SLOT, slot);
        return compound;
    }

    public InventoryModifier(ResourceLocation inventoryKey, int slotsPerLevel) {
        this.inventoryKey = inventoryKey;
        this.slotsPerLevel = slotsPerLevel;
    }
}

