/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.entitymelting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.mantle.recipe.ingredient.EntityIngredient;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class EntityMeltingRecipeBuilder
extends AbstractRecipeBuilder<EntityMeltingRecipeBuilder> {
    private final EntityIngredient ingredient;
    private final FluidStack output;
    private final int damage;

    public static EntityMeltingRecipeBuilder melting(EntityIngredient ingredient, FluidStack output) {
        return EntityMeltingRecipeBuilder.melting(ingredient, output, 2);
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, Objects.requireNonNull(this.output.getFluid().getRegistryName()));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "entity_melting");
        consumer.accept((FinishedRecipe)new Finished(id, advancementId));
    }

    private EntityMeltingRecipeBuilder(EntityIngredient ingredient, FluidStack output, int damage) {
        this.ingredient = ingredient;
        this.output = output;
        this.damage = damage;
    }

    public static EntityMeltingRecipeBuilder melting(EntityIngredient ingredient, FluidStack output, int damage) {
        return new EntityMeltingRecipeBuilder(ingredient, output, damage);
    }

    private class Finished
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Finished(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)EntityMeltingRecipeBuilder.this, ID, advancementID);
        }

        public void m_7917_(JsonObject json) {
            json.add("entity", EntityMeltingRecipeBuilder.this.ingredient.serialize());
            json.add("result", (JsonElement)RecipeHelper.serializeFluidStack((FluidStack)EntityMeltingRecipeBuilder.this.output));
            json.addProperty("damage", (Number)EntityMeltingRecipeBuilder.this.damage);
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)TinkerSmeltery.entityMeltingSerializer.get();
        }
    }
}

