/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.building;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.tconstruct.library.recipe.tinkerstation.building.ToolBuildingRecipe;
import slimeknights.tconstruct.library.tools.item.IModifiable;

public class ToolBuildingRecipeSerializer
extends LoggingRecipeSerializer<ToolBuildingRecipe> {
    public ToolBuildingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
        IModifiable item = (IModifiable)RecipeHelper.deserializeItem((String)GsonHelper.m_13906_((JsonObject)json, (String)"result"), (String)"result", IModifiable.class);
        if (!item.getToolDefinition().isMultipart()) {
            throw new JsonSyntaxException("Modifiable item must have tool parts to get a tool building recipe");
        }
        return new ToolBuildingRecipe(recipeId, group, item);
    }

    @Nullable
    protected ToolBuildingRecipe fromNetworkSafe(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        String group = buffer.m_130136_(Short.MAX_VALUE);
        IModifiable result = (IModifiable)RecipeHelper.readItem((FriendlyByteBuf)buffer, IModifiable.class);
        return new ToolBuildingRecipe(recipeId, group, result);
    }

    protected void toNetworkSafe(FriendlyByteBuf buffer, ToolBuildingRecipe recipe) {
        buffer.m_130070_(recipe.group);
        RecipeHelper.writeItem((FriendlyByteBuf)buffer, (ItemLike)recipe.output);
    }
}

