/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.entity;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.RenderUtils;
import slimeknights.tconstruct.plugin.jei.entity.EntityMeltingRecipeCategory;

public class EntityIngredientRenderer
implements IIngredientRenderer<EntityType> {
    private static final Set<EntityType<?>> IGNORED_ENTITIES = new HashSet();
    private final int size;
    private final Map<EntityType<?>, Entity> ENTITY_MAP = new HashMap();

    public int getWidth() {
        return this.size;
    }

    public int getHeight() {
        return this.size;
    }

    public void render(PoseStack matrixStack, @Nullable EntityType type) {
        if (type != null) {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world != null && !IGNORED_ENTITIES.contains(type)) {
                Object entity = type == EntityType.f_20532_ ? Minecraft.m_91087_().f_91074_ : this.ENTITY_MAP.computeIfAbsent(type, arg_0 -> EntityIngredientRenderer.lambda$render$0((Level)world, arg_0));
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    int scale = this.size / 2;
                    float height = entity.m_20206_();
                    float width = entity.m_20205_();
                    if (height > 2.0f || width > 2.0f) {
                        scale = (int)((float)this.size / Math.max(height, width));
                    }
                    try {
                        PoseStack modelView = RenderSystem.m_157191_();
                        modelView.m_85836_();
                        modelView.m_166854_(matrixStack.m_85850_().m_85861_());
                        InventoryScreen.m_98850_((int)(this.size / 2), (int)this.size, (int)scale, (float)0.0f, (float)10.0f, (LivingEntity)livingEntity);
                        modelView.m_85849_();
                        RenderSystem.m_157182_();
                        return;
                    }
                    catch (Exception e) {
                        TConstruct.LOG.error("Error drawing entity " + type.getRegistryName(), (Throwable)e);
                        IGNORED_ENTITIES.add(type);
                        this.ENTITY_MAP.remove(type);
                    }
                } else {
                    IGNORED_ENTITIES.add(type);
                    this.ENTITY_MAP.remove(type);
                }
            }
            RenderUtils.setup(EntityMeltingRecipeCategory.BACKGROUND_LOC);
            int offset = (this.size - 16) / 2;
            Screen.m_93133_((PoseStack)matrixStack, (int)offset, (int)offset, (float)149.0f, (float)58.0f, (int)16, (int)16, (int)256, (int)256);
        }
    }

    public List<Component> getTooltip(EntityType type, TooltipFlag flag) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add(type.m_20676_());
        if (flag.m_7050_()) {
            tooltip.add((Component)new TextComponent(Objects.requireNonNull(type.getRegistryName()).toString()).m_130940_(ChatFormatting.DARK_GRAY));
        }
        return tooltip;
    }

    public EntityIngredientRenderer(int size) {
        this.size = size;
    }

    private static /* synthetic */ Entity lambda$render$0(Level world, EntityType t) {
        return t.m_20615_(world);
    }
}

