/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.block.entity.NameableBlockEntity;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.entity.inventory.HeaterItemHandler;
import slimeknights.tconstruct.smeltery.menu.SingleItemContainerMenu;

public class HeaterBlockEntity
extends NameableBlockEntity {
    private static final String TAG_ITEM = "item";
    private static final Component TITLE = TConstruct.makeTranslation("gui", "heater");
    private final HeaterItemHandler itemHandler = new HeaterItemHandler((MantleBlockEntity)this);
    private final LazyOptional<IItemHandler> itemCapability = LazyOptional.of(() -> this.itemHandler);

    protected HeaterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, TITLE);
    }

    public HeaterBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TinkerSmeltery.heater.get(), pos, state);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player playerEntity) {
        return new SingleItemContainerMenu(id, inventory, (BlockEntity)this);
    }

    @Nonnull
    public <C> LazyOptional<C> getCapability(Capability<C> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemCapability.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemCapability.invalidate();
    }

    public void m_142466_(CompoundTag tags) {
        super.m_142466_(tags);
        if (tags.m_128425_(TAG_ITEM, 10)) {
            this.itemHandler.readFromNBT(tags.m_128469_(TAG_ITEM));
        }
    }

    public void m_183515_(CompoundTag tags) {
        super.m_183515_(tags);
        tags.m_128365_(TAG_ITEM, (Tag)this.itemHandler.writeToNBT());
    }
}

