/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.MultiModuleScreen;
import slimeknights.mantle.inventory.MultiModuleContainerMenu;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.client.RenderUtils;
import slimeknights.tconstruct.smeltery.block.controller.ControllerBlock;
import slimeknights.tconstruct.smeltery.block.entity.controller.HeatingStructureBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.module.FuelModule;
import slimeknights.tconstruct.smeltery.client.screen.IScreenWithFluidTank;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiFuelModule;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiMeltingModule;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiSmelteryTank;
import slimeknights.tconstruct.smeltery.client.screen.module.HeatingStructureSideInventoryScreen;
import slimeknights.tconstruct.smeltery.menu.HeatingStructureContainerMenu;

public class HeatingStructureScreen
extends MultiModuleScreen<HeatingStructureContainerMenu>
implements IScreenWithFluidTank {
    public static final ResourceLocation BACKGROUND = TConstruct.getResource("textures/gui/smeltery.png");
    private static final ElementScreen SCALA = new ElementScreen(176, 76, 52, 52, 256, 256);
    private final HeatingStructureSideInventoryScreen sideInventory;
    private final HeatingStructureBlockEntity te;
    private final GuiSmelteryTank tank;
    public final GuiMeltingModule melting;
    private final GuiFuelModule fuel;

    public HeatingStructureScreen(HeatingStructureContainerMenu container, Inventory playerInventory, Component title) {
        super((MultiModuleContainerMenu)container, playerInventory, title);
        HeatingStructureBlockEntity te = (HeatingStructureBlockEntity)container.getTile();
        if (te != null) {
            this.te = te;
            this.tank = new GuiSmelteryTank((AbstractContainerScreen<?>)this, te.getTank(), 8, 16, HeatingStructureScreen.SCALA.w, HeatingStructureScreen.SCALA.h);
            int slots = te.getMeltingInventory().getSlots();
            this.sideInventory = new HeatingStructureSideInventoryScreen(this, container.getSideInventory(), playerInventory, slots, HeatingStructureContainerMenu.calcColumns(slots));
            this.addModule(this.sideInventory);
            FuelModule fuelModule = te.getFuelModule();
            this.melting = new GuiMeltingModule((AbstractContainerScreen<?>)this, te.getMeltingInventory(), fuelModule::getTemperature, this.sideInventory::shouldDrawSlot);
            this.fuel = new GuiFuelModule((AbstractContainerScreen<?>)this, fuelModule, 71, 32, 12, 36, 70, 15, false);
        } else {
            this.te = null;
            this.tank = null;
            this.melting = null;
            this.fuel = null;
            this.sideInventory = null;
        }
    }

    protected void m_181908_() {
        super.m_181908_();
        if (this.te == null || !((Boolean)this.te.m_58900_().m_61143_((Property)ControllerBlock.IN_STRUCTURE)).booleanValue() || this.te.getMeltingInventory().getSlots() != this.sideInventory.getSlotCount()) {
            this.m_7379_();
        }
    }

    protected void m_7286_(PoseStack matrices, float partialTicks, int mouseX, int mouseY) {
        GuiUtil.drawBackground(matrices, this, BACKGROUND);
        if (this.fuel != null) {
            this.fuel.draw(matrices);
        }
        super.m_7286_(matrices, partialTicks, mouseX, mouseY);
        if (this.tank != null) {
            this.tank.renderFluids(matrices);
        }
    }

    protected void m_7027_(PoseStack matrices, int mouseX, int mouseY) {
        super.m_7027_(matrices, mouseX, mouseY);
        assert (this.f_96541_ != null);
        RenderUtils.setup(BACKGROUND);
        SCALA.draw(matrices, 8, 16);
        if (this.tank != null) {
            this.tank.renderHighlight(matrices, mouseX, mouseY);
        }
        if (this.fuel != null) {
            this.fuel.renderHighlight(matrices, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (this.melting != null) {
            this.melting.drawHeatBars(matrices);
        }
    }

    protected void m_7025_(PoseStack matrices, int mouseX, int mouseY) {
        super.m_7025_(matrices, mouseX, mouseY);
        if (this.tank != null) {
            this.tank.drawTooltip(matrices, mouseX, mouseY);
        }
        if (this.fuel != null) {
            boolean hasTank = false;
            if (this.te.getStructure() != null) {
                hasTank = this.te.getStructure().hasTanks();
            }
            this.fuel.addTooltip(matrices, mouseX, mouseY, hasTank);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0 && this.tank != null) {
            this.tank.handleClick((int)mouseX - this.cornerX, (int)mouseY - this.cornerY);
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse(double mouseX, double mouseY) {
        FluidStack ingredient = null;
        int checkX = (int)mouseX - this.cornerX;
        int checkY = (int)mouseY - this.cornerY;
        if (this.fuel != null) {
            ingredient = this.fuel.getIngredient(checkX, checkY);
        }
        if (this.tank != null && ingredient == null) {
            ingredient = this.tank.getIngredient(checkX, checkY);
        }
        return ingredient;
    }
}

