/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.block.entity.table;

import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.shared.inventory.ConfigurableInvWrapperCapability;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.block.entity.inventory.CraftingContainerWrapper;
import slimeknights.tconstruct.tables.block.entity.inventory.LazyResultContainer;
import slimeknights.tconstruct.tables.block.entity.table.RetexturedTableBlockEntity;
import slimeknights.tconstruct.tables.menu.CraftingStationContainerMenu;
import slimeknights.tconstruct.tables.network.UpdateCraftingRecipePacket;

public class CraftingStationBlockEntity
extends RetexturedTableBlockEntity
implements LazyResultContainer.ILazyCrafter {
    public static final Component UNCRAFTABLE = TConstruct.makeTranslation("gui", "crafting_station.uncraftable");
    private static final Component NAME = TConstruct.makeTranslation("gui", "crafting_station");
    @Nullable
    private CraftingRecipe lastRecipe;
    private final LazyResultContainer craftingResult;
    private final CraftingContainerWrapper craftingInventory;

    public CraftingStationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TinkerTables.craftingStationTile.get(), pos, state, NAME, 9);
        this.itemHandler = new ConfigurableInvWrapperCapability((Container)this, false, false);
        this.itemHandlerCap = LazyOptional.of(() -> this.itemHandler);
        this.craftingInventory = new CraftingContainerWrapper((Container)this, 3, 3);
        this.craftingResult = new LazyResultContainer(this);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int menuId, Inventory playerInventory, Player playerEntity) {
        return new CraftingStationContainerMenu(menuId, playerInventory, this);
    }

    @Override
    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_, this.f_58858_.m_142082_(1, 2, 1));
    }

    @Override
    public ItemStack calcResult(@Nullable Player player) {
        if (this.f_58857_ == null || this.m_7983_()) {
            return ItemStack.f_41583_;
        }
        ItemStack result = ItemStack.f_41583_;
        if (!this.f_58857_.f_46443_ && this.f_58857_.m_142572_() != null) {
            RecipeManager manager = this.f_58857_.m_142572_().m_129894_();
            CraftingRecipe recipe = this.lastRecipe;
            if (recipe == null || !recipe.m_5818_((Container)this.craftingInventory, this.f_58857_)) {
                recipe = manager.m_44015_(RecipeType.f_44107_, (Container)this.craftingInventory, this.f_58857_).orElse(null);
            }
            if (recipe != null) {
                ForgeHooks.setCraftingPlayer((Player)player);
                result = recipe.m_5874_((Container)this.craftingInventory);
                ForgeHooks.setCraftingPlayer(null);
                if (recipe != this.lastRecipe) {
                    this.lastRecipe = recipe;
                    this.syncToRelevantPlayers(this::syncRecipe);
                }
            }
        } else if (this.lastRecipe != null && this.lastRecipe.m_5818_((Container)this.craftingInventory, this.f_58857_)) {
            ForgeHooks.setCraftingPlayer((Player)player);
            result = this.lastRecipe.m_5874_((Container)this.craftingInventory);
            ForgeHooks.setCraftingPlayer(null);
        }
        return result;
    }

    public ItemStack getResultForPlayer(Player player) {
        ForgeHooks.setCraftingPlayer((Player)player);
        CraftingRecipe recipe = this.lastRecipe;
        if (recipe == null || this.f_58857_ == null || !recipe.m_5818_((Container)this.craftingInventory, this.f_58857_)) {
            ForgeHooks.setCraftingPlayer(null);
            return ItemStack.f_41583_;
        }
        ItemStack result = recipe.m_5874_((Container)this.craftingInventory);
        ForgeHooks.setCraftingPlayer(null);
        return result;
    }

    public void takeResult(Player player, ItemStack result, int amount) {
        CraftingRecipe recipe = this.lastRecipe;
        if (recipe == null || this.f_58857_ == null) {
            return;
        }
        if (!recipe.m_5598_()) {
            player.m_7281_(Collections.singleton(recipe));
        }
        result.m_41678_(this.f_58857_, player, amount);
        ForgeEventFactory.firePlayerCraftingEvent((Player)player, (ItemStack)result, (Container)this.craftingInventory);
        ForgeHooks.setCraftingPlayer((Player)player);
        NonNullList remaining = recipe.m_7457_((Container)this.craftingInventory);
        ForgeHooks.setCraftingPlayer(null);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack original = this.m_8020_(i);
            ItemStack newStack = (ItemStack)remaining.get(i);
            if (original.m_41619_() || original.m_41613_() == 1) {
                this.m_6836_(i, newStack);
                continue;
            }
            if (ItemStack.m_41746_((ItemStack)original, (ItemStack)newStack) && ItemStack.m_41658_((ItemStack)original, (ItemStack)newStack)) {
                newStack.m_41769_(original.m_41613_() - 1);
                this.m_6836_(i, newStack);
                continue;
            }
            this.m_6836_(i, ItemHandlerHelper.copyStackWithSize((ItemStack)original, (int)(original.m_41613_() - 1)));
            if (newStack.m_41619_() || player.m_150109_().m_36054_(newStack)) continue;
            player.m_36176_(newStack, false);
        }
    }

    public void notifyUncraftable(Player player) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            player.m_5661_(UNCRAFTABLE, false);
        }
    }

    @Override
    public void onCraft(Player player, ItemStack result, int amount) {
        int originalSize = result.m_41613_();
        result = ItemStack.f_41583_;
        if (amount > 0) {
            result = this.getResultForPlayer(player);
            if (!result.m_41619_()) {
                this.takeResult(player, result, amount);
            }
            if (originalSize > 0) {
                result.m_41764_(result.m_41613_() + player.f_36096_.m_142621_().m_41613_() - originalSize);
            }
        }
        player.f_36096_.m_142503_(result);
        if (result.m_41619_()) {
            this.notifyUncraftable(player);
        }
    }

    @Override
    public void m_6836_(int slot, ItemStack itemstack) {
        super.m_6836_(slot, itemstack);
        this.craftingResult.m_6211_();
    }

    public void syncRecipe(Player player) {
        if (this.lastRecipe != null && this.f_58857_ != null && !this.f_58857_.f_46443_ && player instanceof ServerPlayer) {
            TinkerNetwork.getInstance().sendTo(new UpdateCraftingRecipePacket(this.f_58858_, this.lastRecipe), (ServerPlayer)player);
        }
    }

    public void updateRecipe(CraftingRecipe recipe) {
        this.lastRecipe = recipe;
        this.craftingResult.m_6211_();
    }

    public LazyResultContainer getCraftingResult() {
        return this.craftingResult;
    }
}

