/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.armor;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.hooks.IArmorInteractModifier;
import slimeknights.tconstruct.library.modifiers.impl.InventoryModifier;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.capability.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ToolBeltModifier
extends InventoryModifier
implements IArmorInteractModifier {
    private static final ResourceLocation KEY = TConstruct.getResource("tool_belt");
    private static final Pattern PATTERN = new Pattern("tconstruct", "tool_belt");

    public ToolBeltModifier() {
        super(KEY, 4);
    }

    @Override
    public int getPriority() {
        return 85;
    }

    @Override
    public int getSlots(IToolContext tool, int level) {
        return Math.min(9, level * 4 + tool.getModifierLevel(TinkerModifiers.pocketChain.getId()));
    }

    @Override
    public boolean startArmorInteract(IToolStackView tool, int level, Player player, EquipmentSlot equipmentSlot) {
        if (!player.m_6144_()) {
            ListTag original;
            if (player.f_19853_.f_46443_) {
                return false;
            }
            boolean didChange = false;
            int slots = this.getSlots(tool, level);
            ModDataNBT persistentData = tool.getPersistentData();
            ListTag list = new ListTag();
            boolean[] swapped = new boolean[slots];
            Inventory inventory = player.m_150109_();
            if (persistentData.contains(KEY, 9) && !(original = (ListTag)persistentData.get(KEY, GET_COMPOUND_LIST)).isEmpty()) {
                for (int i = 0; i < original.size(); ++i) {
                    CompoundTag compoundNBT = original.m_128728_(i);
                    int slot = compoundNBT.m_128451_("Slot");
                    if (slot >= slots) continue;
                    ItemStack hotbar = inventory.m_8020_(slot);
                    if (hotbar.m_41619_() || !ToolInventoryCapability.isBlacklisted(hotbar)) {
                        ItemStack parsed = ItemStack.m_41712_((CompoundTag)compoundNBT);
                        inventory.m_6836_(slot, parsed);
                        if (!hotbar.m_41619_()) {
                            list.add((Object)ToolBeltModifier.write(hotbar, slot));
                        }
                        didChange = true;
                    }
                    swapped[slot] = true;
                }
            }
            for (int i = 0; i < slots; ++i) {
                ItemStack hotbar;
                if (swapped[i] || (hotbar = player.m_150109_().m_8020_(i)).m_41619_() || ToolInventoryCapability.isBlacklisted(hotbar)) continue;
                list.add((Object)ToolBeltModifier.write(hotbar, i));
                inventory.m_6836_(i, ItemStack.f_41583_);
                didChange = true;
            }
            if (didChange) {
                persistentData.put(KEY, (Tag)list);
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11675_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        return false;
    }

    @Override
    @Nullable
    public Pattern getPattern(IToolStackView tool, int level, int slot, boolean hasStack) {
        return PATTERN;
    }

    @Override
    @Nullable
    public <T> T getModule(Class<T> type) {
        if (type == IArmorInteractModifier.class) {
            return (T)this;
        }
        return super.getModule(type);
    }
}

