/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.interaction;

import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ToolAction;
import slimeknights.tconstruct.library.modifiers.impl.InteractionModifier;
import slimeknights.tconstruct.library.tools.definition.aoe.CircleAOEIterator;
import slimeknights.tconstruct.library.tools.definition.aoe.IAreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class FirestarterModifier
extends InteractionModifier.NoLevels {
    private static final ToolAction LIGHT_CAMPFIRE = ToolAction.get((String)"light_campfire");
    private final int priority;

    @Override
    public boolean shouldDisplay(boolean advanced) {
        return this.priority > Short.MIN_VALUE;
    }

    @Override
    public boolean canPerformAction(IToolStackView tool, int level, ToolAction toolAction) {
        return toolAction == LIGHT_CAMPFIRE;
    }

    @Override
    public InteractionResult afterEntityUse(IToolStackView tool, int level, Player player, LivingEntity target, InteractionHand hand, EquipmentSlot slotType) {
        if (target instanceof Creeper) {
            Creeper creeper = (Creeper)target;
            player.f_19853_.m_6263_(player, creeper.m_20185_(), creeper.m_20186_(), creeper.m_20189_(), SoundEvents.f_11942_, creeper.m_5720_(), 1.0f, RANDOM.nextFloat() * 0.4f + 0.8f);
            if (!player.f_19853_.f_46443_) {
                creeper.m_32312_();
                ToolDamageUtil.damageAnimated(tool, 1, (LivingEntity)player, slotType);
            }
            return InteractionResult.m_19078_((boolean)player.f_19853_.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private static boolean ignite(IToolStackView tool, Level world, BlockPos pos, BlockState state, Direction sideHit, Direction horizontalFacing, @Nullable Player player) {
        if (CampfireBlock.m_51321_((BlockState)state)) {
            world.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, RANDOM.nextFloat() * 0.4f + 0.8f);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 11);
            return true;
        }
        Block block = state.m_60734_();
        if (block instanceof TntBlock) {
            TntBlock tnt = (TntBlock)block;
            tnt.onCaughtFire(state, world, pos, sideHit, (LivingEntity)player);
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
            return true;
        }
        BlockPos offset = pos.m_142300_(sideHit);
        if (BaseFireBlock.m_49255_((Level)world, (BlockPos)offset, (Direction)horizontalFacing)) {
            world.m_5594_(player, offset, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, RANDOM.nextFloat() * 0.4f + 0.8f);
            world.m_7731_(offset, BaseFireBlock.m_49245_((BlockGetter)world, (BlockPos)offset), 11);
            return true;
        }
        return false;
    }

    @Override
    public InteractionResult afterBlockUse(IToolStackView tool, int level, UseOnContext context, EquipmentSlot slotType) {
        if (tool.isBroken()) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction sideHit = context.m_43719_();
        BlockState state = world.m_8055_(pos);
        boolean targetingFire = false;
        if (state.m_204336_(BlockTags.f_13076_)) {
            pos = pos.m_142300_(sideHit.m_122424_());
            targetingFire = true;
        }
        int range = tool.getModifierLevel(TinkerModifiers.fireprimer.getId()) + tool.getModifierLevel(TinkerModifiers.expanded.getId());
        Iterable<Object> targets = Collections.emptyList();
        if (range > 0 && player != null) {
            targets = CircleAOEIterator.calculate(tool, ItemStack.f_41583_, world, player, pos, sideHit, 1 + range, true, IAreaOfEffectIterator.AOEMatchType.TRANSFORM);
        }
        Direction horizontalFacing = context.m_8125_();
        boolean didIgnite = false;
        ItemStack stack = context.m_43722_();
        if (!targetingFire && (didIgnite = FirestarterModifier.ignite(tool, world, pos, state, sideHit, horizontalFacing, player)) && ToolDamageUtil.damage(tool, 1, (LivingEntity)player, stack)) {
            if (player != null) {
                player.m_21166_(slotType);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        for (BlockPos target : targets) {
            if (!FirestarterModifier.ignite(tool, world, target, world.m_8055_(target), sideHit, horizontalFacing, player)) continue;
            didIgnite = true;
            if (!ToolDamageUtil.damage(tool, 1, (LivingEntity)player, stack)) continue;
            if (player == null) break;
            player.m_21166_(slotType);
            break;
        }
        return didIgnite ? InteractionResult.m_19078_((boolean)world.f_46443_) : InteractionResult.PASS;
    }

    public FirestarterModifier(int priority) {
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }
}

