/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.general;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.world.BlockEvent;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.helper.ModifierLootingHandler;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ExperiencedModifier
extends Modifier {
    public ExperiencedModifier() {
        MinecraftForge.EVENT_BUS.addListener(this::onEntityKill);
        MinecraftForge.EVENT_BUS.addListener(this::beforeBlockBreak);
    }

    private static int boost(int original, int level) {
        return (int)((double)original * (1.0 + 0.5 * (double)level));
    }

    private void beforeBlockBreak(BlockEvent.BreakEvent event) {
        int level = 0;
        ToolStack tool = ExperiencedModifier.getHeldTool((LivingEntity)event.getPlayer(), InteractionHand.MAIN_HAND);
        if (tool != null) {
            level = tool.getModifierLevel(this);
        }
        if ((tool = ExperiencedModifier.getHeldTool((LivingEntity)event.getPlayer(), EquipmentSlot.LEGS)) != null) {
            level += tool.getModifierLevel(this);
        }
        if (level > 0) {
            event.setExpToDrop(ExperiencedModifier.boost(event.getExpToDrop(), level));
        }
    }

    private void onEntityKill(LivingExperienceDropEvent event) {
        Player player = event.getAttackingPlayer();
        if (player != null) {
            int level = 0;
            ToolStack tool = ExperiencedModifier.getHeldTool((LivingEntity)player, ModifierLootingHandler.getLootingSlot((LivingEntity)player));
            if (tool != null) {
                level = tool.getModifierLevel(this);
            }
            if ((tool = ExperiencedModifier.getHeldTool((LivingEntity)player, EquipmentSlot.LEGS)) != null) {
                level += tool.getModifierLevel(this);
            }
            if (level > 0) {
                event.setDroppedExperience(ExperiencedModifier.boost(event.getDroppedExperience(), level));
            }
        }
    }
}

