/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.stats;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraftforge.common.TierSortingRegistry;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.stats.BaseMaterialStats;
import slimeknights.tconstruct.library.materials.stats.IRepairableMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class HeadMaterialStats
extends BaseMaterialStats
implements IRepairableMaterialStats {
    public static final MaterialStatsId ID = new MaterialStatsId(TConstruct.getResource("head"));
    public static final HeadMaterialStats DEFAULT = new HeadMaterialStats(1, 1.0f, (Tier)Tiers.WOOD, 1.0f);
    private static final List<Component> DESCRIPTION = ImmutableList.of((Object)ToolStats.DURABILITY.getDescription(), (Object)ToolStats.HARVEST_TIER.getDescription(), (Object)ToolStats.MINING_SPEED.getDescription(), (Object)ToolStats.ATTACK_DAMAGE.getDescription());
    private static final ResourceLocation WOOD_TIER = new ResourceLocation("wood");
    private final int durability;
    private final float miningSpeed;
    private final ResourceLocation harvestTier;
    private final float attack;
    private transient Tier tier;

    public HeadMaterialStats(int durability, float miningSpeed, Tier tier, float attack) {
        this.durability = durability;
        this.miningSpeed = miningSpeed;
        this.harvestTier = Objects.requireNonNull(TierSortingRegistry.getName((Tier)tier), "Cannot create head material stats with unsorted tier");
        this.tier = tier;
        this.attack = attack;
    }

    public HeadMaterialStats(FriendlyByteBuf buffer) {
        this.durability = buffer.readInt();
        this.miningSpeed = buffer.readFloat();
        this.harvestTier = buffer.m_130281_();
        this.attack = buffer.readFloat();
    }

    public ResourceLocation getTierId() {
        return this.harvestTier;
    }

    public Tier getTier() {
        if (this.tier == null) {
            if (this.harvestTier != null) {
                this.tier = TierSortingRegistry.byName((ResourceLocation)this.harvestTier);
            }
            if (this.tier == null) {
                TConstruct.LOG.error("Failed to find tool tier by name " + this.harvestTier);
                this.tier = DEFAULT.getTier();
            }
        }
        return this.tier;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.durability);
        buffer.writeFloat(this.miningSpeed);
        if (this.harvestTier == null) {
            TConstruct.LOG.error("Unset harvest tier for head stats");
            buffer.m_130085_(WOOD_TIER);
        } else {
            buffer.m_130085_(this.harvestTier);
        }
        buffer.writeFloat(this.attack);
    }

    @Override
    public MaterialStatsId getIdentifier() {
        return ID;
    }

    @Override
    public List<Component> getLocalizedInfo() {
        ArrayList info = Lists.newArrayList();
        info.add(ToolStats.DURABILITY.formatValue(this.durability));
        info.add(ToolStats.HARVEST_TIER.formatValue(this.getTier()));
        info.add(ToolStats.MINING_SPEED.formatValue(this.miningSpeed));
        info.add(ToolStats.ATTACK_DAMAGE.formatValue(this.attack));
        return info;
    }

    @Override
    public List<Component> getLocalizedDescriptions() {
        return DESCRIPTION;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeadMaterialStats that = (HeadMaterialStats)o;
        return this.durability == that.durability && this.miningSpeed == that.miningSpeed && this.attack == that.attack && Objects.equals(this.harvestTier, that.harvestTier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.durability, Float.valueOf(this.miningSpeed), this.harvestTier, Float.valueOf(this.attack));
    }

    public String toString() {
        return "HeadMaterialStats(durability=" + this.getDurability() + ", miningSpeed=" + this.getMiningSpeed() + ", harvestTier=" + this.harvestTier + ", attack=" + this.getAttack() + ", tier=" + this.getTier() + ")";
    }

    @Override
    public int getDurability() {
        return this.durability;
    }

    public float getMiningSpeed() {
        return this.miningSpeed;
    }

    public float getAttack() {
        return this.attack;
    }
}

