/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.Create;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.repack.registrate.builders.BlockBuilder;
import com.simibubi.create.repack.registrate.builders.ItemBuilder;
import com.simibubi.create.repack.registrate.providers.ProviderType;
import com.simibubi.create.repack.registrate.util.nullness.NonNullFunction;
import java.util.Collections;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AllTags {
    private static final CreateRegistrate REGISTRATE = (CreateRegistrate)Create.registrate().creativeModeTab(() -> Create.BASE_CREATIVE_TAB);

    public static <T extends IForgeRegistryEntry<T>> TagKey<T> optionalTag(IForgeRegistry<T> registry, ResourceLocation id) {
        return registry.tags().createOptionalTagKey(id, Collections.emptySet());
    }

    public static <T extends IForgeRegistryEntry<T>> TagKey<T> forgeTag(IForgeRegistry<T> registry, String path) {
        return AllTags.optionalTag(registry, new ResourceLocation("forge", path));
    }

    public static TagKey<Block> forgeBlockTag(String path) {
        return AllTags.forgeTag(ForgeRegistries.BLOCKS, path);
    }

    public static TagKey<Item> forgeItemTag(String path) {
        return AllTags.forgeTag(ForgeRegistries.ITEMS, path);
    }

    public static TagKey<Fluid> forgeFluidTag(String path) {
        return AllTags.forgeTag(ForgeRegistries.FLUIDS, path);
    }

    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> axeOrPickaxe() {
        return b -> b.tag(BlockTags.f_144280_).tag(BlockTags.f_144282_);
    }

    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> axeOnly() {
        return b -> b.tag(BlockTags.f_144280_);
    }

    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> pickaxeOnly() {
        return b -> b.tag(BlockTags.f_144282_);
    }

    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, ItemBuilder<BlockItem, BlockBuilder<T, P>>> tagBlockAndItem(String ... path) {
        return b -> {
            for (String p : path) {
                b.tag(AllTags.forgeBlockTag(p));
            }
            ItemBuilder item = b.item();
            for (String p : path) {
                item.tag(AllTags.forgeItemTag(p));
            }
            return item;
        };
    }

    public static void register() {
        AllFluidTags.BOTTOMLESS_ALLOW.add(new Fluid[]{Fluids.f_76193_, Fluids.f_76195_});
        AllItemTags.CREATE_INGOTS.includeIn(AllItemTags.BEACON_PAYMENT);
        AllItemTags.CREATE_INGOTS.includeIn((TagKey<Item>)Tags.Items.INGOTS);
        AllItemTags.UPRIGHT_ON_BELT.add(Items.f_42590_, Items.f_42589_, Items.f_42736_, Items.f_42739_, Items.f_42787_, Items.f_42502_);
        AllBlockTags.WINDMILL_SAILS.includeAll((TagKey<Block>)BlockTags.f_13089_);
        AllBlockTags.BRITTLE.includeAll((TagKey<Block>)BlockTags.f_13103_);
        AllBlockTags.BRITTLE.includeAll((TagKey<Block>)BlockTags.f_13038_);
        AllBlockTags.BRITTLE.add(Blocks.f_50276_, Blocks.f_50680_, Blocks.f_50262_);
        AllBlockTags.FAN_TRANSPARENT.includeAll((TagKey<Block>)BlockTags.f_13039_);
        AllBlockTags.FAN_TRANSPARENT.add(Blocks.f_50183_, Blocks.f_50683_, Blocks.f_50684_);
        AllBlockTags.FAN_HEATERS.add(Blocks.f_50450_, Blocks.f_50683_, Blocks.f_49991_, Blocks.f_50083_, Blocks.f_50084_, Blocks.f_50684_);
        AllBlockTags.SAFE_NBT.includeAll((TagKey<Block>)BlockTags.f_13068_);
        AllBlockTags.WRENCH_PICKUP.includeAll((TagKey<Block>)BlockTags.f_13034_);
        AllBlockTags.WRENCH_PICKUP.includeAll((TagKey<Block>)BlockTags.f_13093_);
        AllBlockTags.WRENCH_PICKUP.includeAll((TagKey<Block>)BlockTags.f_13099_);
        AllBlockTags.WRENCH_PICKUP.add(Blocks.f_50088_, Blocks.f_50174_, Blocks.f_50146_, Blocks.f_50164_, Blocks.f_50328_, Blocks.f_50455_, Blocks.f_50123_, Blocks.f_50039_, Blocks.f_50032_, Blocks.f_50267_, Blocks.f_50266_, Blocks.f_50329_, Blocks.f_50716_);
        AllBlockTags.ORE_OVERRIDE_STONE.includeAll((TagKey<Block>)BlockTags.f_144266_);
    }

    public static enum AllFluidTags {
        BOTTOMLESS_ALLOW(NameSpace.MOD, "bottomless/allow"),
        BOTTOMLESS_DENY(NameSpace.MOD, "bottomless/deny"),
        HONEY(NameSpace.FORGE);

        public final TagKey<Fluid> tag;

        private AllFluidTags() {
            this(NameSpace.MOD);
        }

        private AllFluidTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllFluidTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllFluidTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllFluidTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId(this.name()) : path);
            this.tag = optional ? AllTags.optionalTag(ForgeRegistries.FLUIDS, id) : FluidTags.create((ResourceLocation)id);
            if (alwaysDatagen) {
                REGISTRATE.addDataGenerator(ProviderType.FLUID_TAGS, prov -> prov.m_206424_(this.tag));
            }
        }

        public boolean matches(Fluid fluid) {
            return fluid.m_205067_(this.tag);
        }

        public boolean matches(FluidState state) {
            return state.m_205070_(this.tag);
        }

        public void add(Fluid ... values) {
            REGISTRATE.addDataGenerator(ProviderType.FLUID_TAGS, prov -> prov.m_206424_(this.tag).m_126584_((Object[])values));
        }

        public void includeIn(TagKey<Fluid> parent) {
            REGISTRATE.addDataGenerator(ProviderType.FLUID_TAGS, prov -> prov.m_206424_(parent).m_206428_(this.tag));
        }

        public void includeIn(AllFluidTags parent) {
            this.includeIn(parent.tag);
        }

        public void includeAll(TagKey<Fluid> child) {
            REGISTRATE.addDataGenerator(ProviderType.FLUID_TAGS, prov -> prov.m_206424_(this.tag).m_206428_(child));
        }
    }

    public static enum AllItemTags {
        BLAZE_BURNER_FUEL_REGULAR(NameSpace.MOD, "blaze_burner_fuel/regular"),
        BLAZE_BURNER_FUEL_SPECIAL(NameSpace.MOD, "blaze_burner_fuel/special"),
        CREATE_INGOTS,
        CRUSHED_ORES,
        SANDPAPER,
        SEATS,
        TOOLBOXES,
        UPRIGHT_ON_BELT,
        VALVE_HANDLES,
        BEACON_PAYMENT(NameSpace.FORGE),
        PLATES(NameSpace.FORGE);

        public final TagKey<Item> tag;

        private AllItemTags() {
            this(NameSpace.MOD);
        }

        private AllItemTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllItemTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllItemTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllItemTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId(this.name()) : path);
            this.tag = optional ? AllTags.optionalTag(ForgeRegistries.ITEMS, id) : ItemTags.create((ResourceLocation)id);
            if (alwaysDatagen) {
                REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> prov.m_206424_(this.tag));
            }
        }

        public boolean matches(Item item) {
            return item.m_204114_().m_203656_(this.tag);
        }

        public boolean matches(ItemStack stack) {
            return stack.m_204117_(this.tag);
        }

        public void add(Item ... values) {
            REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> prov.m_206424_(this.tag).m_126584_((Object[])values));
        }

        public void includeIn(TagKey<Item> parent) {
            REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> prov.m_206424_(parent).m_206428_(this.tag));
        }

        public void includeIn(AllItemTags parent) {
            this.includeIn(parent.tag);
        }

        public void includeAll(TagKey<Item> child) {
            REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> prov.m_206424_(this.tag).m_206428_(child));
        }
    }

    public static enum AllBlockTags {
        BRITTLE,
        FAN_HEATERS,
        FAN_TRANSPARENT,
        ORE_OVERRIDE_STONE,
        SAFE_NBT,
        SEATS,
        TOOLBOXES,
        VALVE_HANDLES,
        WINDMILL_SAILS,
        WINDOWABLE,
        WRENCH_PICKUP,
        RELOCATION_NOT_SUPPORTED(NameSpace.FORGE),
        WG_STONE(NameSpace.FORGE),
        SLIMY_LOGS(NameSpace.TIC);

        public final TagKey<Block> tag;

        private AllBlockTags() {
            this(NameSpace.MOD);
        }

        private AllBlockTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllBlockTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllBlockTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllBlockTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId(this.name()) : path);
            this.tag = optional ? AllTags.optionalTag(ForgeRegistries.BLOCKS, id) : BlockTags.create((ResourceLocation)id);
            if (alwaysDatagen) {
                REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> prov.m_206424_(this.tag));
            }
        }

        public boolean matches(Block block) {
            return block.m_204297_().m_203656_(this.tag);
        }

        public boolean matches(BlockState state) {
            return state.m_204336_(this.tag);
        }

        public void add(Block ... values) {
            REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> prov.m_206424_(this.tag).m_126584_((Object[])values));
        }

        public void includeIn(TagKey<Block> parent) {
            REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> prov.m_206424_(parent).m_206428_(this.tag));
        }

        public void includeIn(AllBlockTags parent) {
            this.includeIn(parent.tag);
        }

        public void includeAll(TagKey<Block> child) {
            REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> prov.m_206424_(this.tag).m_206428_(child));
        }
    }

    public static enum NameSpace {
        MOD("create", false, true),
        FORGE("forge"),
        TIC("tconstruct");

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }
}

