/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.saw;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.saw.SawBlock;
import com.simibubi.create.content.contraptions.components.saw.SawTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderDispatcher;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class SawRenderer
extends SafeTileEntityRenderer<SawTileEntity> {
    public SawRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    protected void renderSafe(SawTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        this.renderBlade(te, ms, buffer, light);
        this.renderItems(te, partialTicks, ms, buffer, light, overlay);
        FilteringRenderer.renderOnTileEntity(te, partialTicks, ms, buffer, light, overlay);
        if (Backend.canUseInstancing((Level)te.m_58904_())) {
            return;
        }
        this.renderShaft(te, ms, buffer, light, overlay);
    }

    protected void renderBlade(SawTileEntity te, PoseStack ms, MultiBufferSource buffer, int light) {
        PartialModel partial;
        BlockState blockState = te.m_58900_();
        float speed = te.getSpeed();
        boolean rotate = false;
        if (SawBlock.isHorizontal(blockState)) {
            partial = speed > 0.0f ? AllBlockPartials.SAW_BLADE_HORIZONTAL_ACTIVE : (speed < 0.0f ? AllBlockPartials.SAW_BLADE_HORIZONTAL_REVERSED : AllBlockPartials.SAW_BLADE_HORIZONTAL_INACTIVE);
        } else {
            partial = te.getSpeed() > 0.0f ? AllBlockPartials.SAW_BLADE_VERTICAL_ACTIVE : (speed < 0.0f ? AllBlockPartials.SAW_BLADE_VERTICAL_REVERSED : AllBlockPartials.SAW_BLADE_VERTICAL_INACTIVE);
            if (((Boolean)blockState.m_61143_((Property)SawBlock.AXIS_ALONG_FIRST_COORDINATE)).booleanValue()) {
                rotate = true;
            }
        }
        SuperByteBuffer superBuffer = CachedBufferer.partialFacing(partial, blockState);
        if (rotate) {
            superBuffer.rotateCentered(Direction.UP, AngleHelper.rad(90.0));
        }
        superBuffer.color(0xFFFFFF).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110457_()));
    }

    protected void renderShaft(SawTileEntity te, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        KineticTileEntityRenderer.renderRotatingBuffer(te, this.getRotatedModel(te), ms, buffer.m_6299_(RenderType.m_110451_()), light);
    }

    protected void renderItems(SawTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        boolean processingMode;
        boolean bl = processingMode = te.m_58900_().m_61143_((Property)SawBlock.FACING) == Direction.UP;
        if (processingMode && !te.inventory.isEmpty()) {
            boolean alongZ = (Boolean)te.m_58900_().m_61143_((Property)SawBlock.AXIS_ALONG_FIRST_COORDINATE) == false;
            ms.m_85836_();
            boolean moving = te.inventory.recipeDuration != 0.0f;
            float offset = moving ? te.inventory.remainingTime / te.inventory.recipeDuration : 0.0f;
            float processingSpeed = Mth.m_14036_((float)(Math.abs(te.getSpeed()) / 32.0f), (float)1.0f, (float)128.0f);
            if (moving) {
                offset = Mth.m_14036_((float)(offset + (-partialTicks + 0.5f) * processingSpeed / te.inventory.recipeDuration), (float)0.125f, (float)1.0f);
                if (!te.inventory.appliedRecipe) {
                    offset += 1.0f;
                }
                offset /= 2.0f;
            }
            if (te.getSpeed() == 0.0f) {
                offset = 0.5f;
            }
            if (te.getSpeed() < 0.0f ^ alongZ) {
                offset = 1.0f - offset;
            }
            for (int i = 0; i < te.inventory.getSlots(); ++i) {
                ItemStack stack = te.inventory.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                BakedModel modelWithOverrides = itemRenderer.m_174264_(stack, te.m_58904_(), null, 0);
                boolean blockItem = modelWithOverrides.m_7539_();
                ms.m_85837_(alongZ ? (double)offset : 0.5, blockItem ? (double)0.925f : 0.8125, alongZ ? 0.5 : (double)offset);
                ms.m_85841_(0.5f, 0.5f, 0.5f);
                if (alongZ) {
                    ms.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
                }
                ms.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                itemRenderer.m_174269_(stack, ItemTransforms.TransformType.FIXED, light, overlay, ms, buffer, 0);
                break;
            }
            ms.m_85849_();
        }
    }

    protected SuperByteBuffer getRotatedModel(KineticTileEntity te) {
        BlockState state = te.m_58900_();
        if (((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_().m_122479_()) {
            return CachedBufferer.partialFacing(AllBlockPartials.SHAFT_HALF, state.rotate((LevelAccessor)te.m_58904_(), te.m_58899_(), Rotation.CLOCKWISE_180));
        }
        return CachedBufferer.block(KineticTileEntityRenderer.KINETIC_TILE, this.getRenderedBlockState(te));
    }

    protected BlockState getRenderedBlockState(KineticTileEntity te) {
        return KineticTileEntityRenderer.shaft(KineticTileEntityRenderer.getRotationAxisOf(te));
    }

    public static void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        boolean shouldAnimate;
        BlockState state = context.state;
        Direction facing = (Direction)state.m_61143_((Property)SawBlock.FACING);
        Vec3 facingVec = Vec3.m_82528_((Vec3i)((Direction)context.state.m_61143_((Property)SawBlock.FACING)).m_122436_());
        facingVec = (Vec3)context.rotation.apply(facingVec);
        Direction closestToFacing = Direction.m_122366_((double)facingVec.f_82479_, (double)facingVec.f_82480_, (double)facingVec.f_82481_);
        boolean horizontal = closestToFacing.m_122434_().m_122479_();
        boolean backwards = VecHelper.isVecPointingTowards(context.relativeMotion, facing.m_122424_());
        boolean moving = context.getAnimationSpeed() != 0.0f;
        boolean bl = shouldAnimate = context.contraption.stalled && horizontal || !context.contraption.stalled && !backwards && moving;
        SuperByteBuffer superBuffer = SawBlock.isHorizontal(state) ? (shouldAnimate ? CachedBufferer.partial(AllBlockPartials.SAW_BLADE_HORIZONTAL_ACTIVE, state) : CachedBufferer.partial(AllBlockPartials.SAW_BLADE_HORIZONTAL_INACTIVE, state)) : (shouldAnimate ? CachedBufferer.partial(AllBlockPartials.SAW_BLADE_VERTICAL_ACTIVE, state) : CachedBufferer.partial(AllBlockPartials.SAW_BLADE_VERTICAL_INACTIVE, state));
        ((SuperByteBuffer)((SuperByteBuffer)superBuffer.transform(matrices.getModel()).centre()).rotateY(AngleHelper.horizontalAngle(facing))).rotateX(AngleHelper.verticalAngle(facing));
        if (!SawBlock.isHorizontal(state)) {
            superBuffer.rotateZ((Boolean)state.m_61143_((Property)SawBlock.AXIS_ALONG_FIRST_COORDINATE) != false ? 90.0 : 0.0);
        }
        ((SuperByteBuffer)superBuffer.unCentre()).light(matrices.getWorld(), ContraptionRenderDispatcher.getContraptionWorldLight(context, renderWorld)).renderInto(matrices.getViewProjection(), buffer.m_6299_(RenderType.m_110457_()));
    }
}

