/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.bearing;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.flwdata.RotatingData;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.BearingInstance;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.StabilizedBearingMovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ActorInstance;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class StabilizedBearingInstance
extends ActorInstance {
    final OrientedData topInstance;
    final RotatingData shaft;
    final Direction facing;
    final Vector3f rotationAxis;
    final Quaternion blockOrientation;

    public StabilizedBearingInstance(MaterialManager materialManager, VirtualRenderWorld simulationWorld, MovementContext context) {
        super(materialManager, simulationWorld, context);
        BlockState blockState = context.state;
        this.facing = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61372_);
        this.rotationAxis = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.facing.m_122434_()).m_122432_();
        this.blockOrientation = BearingInstance.getBlockStateOrientation(this.facing);
        this.topInstance = (OrientedData)materialManager.defaultSolid().material(Materials.ORIENTED).getModel(AllBlockPartials.BEARING_TOP, blockState).createInstance();
        int blockLight = this.localBlockLight();
        this.topInstance.setPosition(context.localPos).setRotation(this.blockOrientation).setBlockLight(blockLight);
        this.shaft = (RotatingData)materialManager.defaultSolid().material(AllMaterialSpecs.ROTATING).getModel(AllBlockPartials.SHAFT_HALF, blockState, ((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61372_)).m_122424_()).createInstance();
        this.shaft.setPosition(context.localPos).setBlockLight(blockLight);
    }

    @Override
    public void beginFrame() {
        float counterRotationAngle = StabilizedBearingMovementBehaviour.getCounterRotationAngle(this.context, this.facing, AnimationTickHolder.getPartialTicks());
        Quaternion rotation = this.rotationAxis.m_122240_(counterRotationAngle);
        rotation.m_80148_(this.blockOrientation);
        this.topInstance.setRotation(rotation);
    }
}

