/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.client.screen.control;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import it.zerono.mods.zerocore.base.CommonConstants;
import it.zerono.mods.zerocore.base.client.screen.BaseIcons;
import it.zerono.mods.zerocore.base.client.screen.control.AbstractVerticalIconGaugeBar;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.text.BindableTextComponent;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class EnergyBar
extends AbstractVerticalIconGaugeBar {
    private final EnergySystem _system;

    public EnergyBar(ModContainerScreen<? extends ModContainer> gui, String name, EnergySystem system, WideAmount maxValue, Supplier<WideAmount> valueSupplier, @Nullable String optionalTooltipLine) {
        super(gui, name, maxValue.doubleValue(), () -> ((WideAmount)valueSupplier.get()).doubleValue(), BaseIcons.PowerBar, BaseIcons.PowerBattery);
        this._system = system;
        BindableTextComponent valueText = new BindableTextComponent(this::getValueText);
        BindableTextComponent percentageText = new BindableTextComponent(this::getPercentageText);
        ImmutableList.Builder tipsBuilder = ImmutableList.builder();
        tipsBuilder.add((Object[])new Component[]{new TranslatableComponent("gui.zerocore.base.control.energybar.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), CodeHelper.TEXT_EMPTY_LINE, new TranslatableComponent("gui.zerocore.base.control.energybar.line2a").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE).m_7220_((Component)new TranslatableComponent("gui.zerocore.base.control.energybar.line2b", new Object[]{CodeHelper.formatAsHumanReadableNumber(maxValue.doubleValue(), system.getUnit())})), new TranslatableComponent("gui.zerocore.base.control.energybar.line3a").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE).m_7220_((Component)new TranslatableComponent("gui.zerocore.base.control.energybar.line3b"))});
        if (!Strings.isNullOrEmpty((String)optionalTooltipLine)) {
            tipsBuilder.add((Object)new TranslatableComponent(optionalTooltipLine));
        }
        this._bar.setTooltips((List<Component>)tipsBuilder.build(), (List<Object>)ImmutableList.of(valueText, percentageText));
        gui.addDataBinding(valueSupplier, valueText, percentageText);
        this._icon.useTooltipsFrom(this._bar);
    }

    private Component getValueText(WideAmount amount) {
        return new TextComponent(CodeHelper.formatAsHumanReadableNumber(amount.doubleValue(), this._system.getUnit())).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE);
    }

    private Component getPercentageText(WideAmount amount) {
        double percentage = amount.percentage(WideAmount.from(this._bar.getMaxValue()));
        return new TextComponent(String.format("%d", (int)(percentage * 100.0))).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE);
    }
}

