/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.multiblock.part.io;

import it.zerono.mods.zerocore.base.multiblock.part.AbstractMultiblockEntity;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.IIoEntity;
import it.zerono.mods.zerocore.lib.data.IoMode;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockPart;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullPredicate;

public abstract class AbstractIOPortHandler<Controller extends AbstractCuboidMultiblockController<Controller>, T extends AbstractMultiblockEntity<Controller>> {
    private final T _part;
    private final IoMode _mode;

    public T getPart() {
        return this._part;
    }

    public boolean isInput() {
        return ((IIoEntity)this.getPart()).getIoDirection().isInput();
    }

    public boolean isOutput() {
        return ((IIoEntity)this.getPart()).getIoDirection().isOutput();
    }

    public boolean isActive() {
        return this._mode.isActive();
    }

    public boolean isPassive() {
        return this._mode.isPassive();
    }

    protected AbstractIOPortHandler(T part, IoMode mode) {
        this._part = part;
        this._mode = mode;
    }

    @Nullable
    protected <C> C lookupConsumer(@Nullable Level world, BlockPos position, @Nullable Capability<C> requestedCapability, NonNullPredicate<BlockEntity> isSameHandler, @Nullable C currentConsumer) {
        boolean isConnectedNow;
        LazyOptional capability;
        BlockEntity te;
        if (null == world) {
            return null;
        }
        boolean wasConnected = null != currentConsumer;
        Object foundConsumer = null;
        Direction approachDirection = ((AbstractCuboidMultiblockPart)this.getPart()).getOutwardDirection().orElse(null);
        if (null == approachDirection) {
            wasConnected = false;
        } else if (null != requestedCapability && null != (te = WorldHelper.getLoadedTile(world, position.m_142300_(approachDirection))) && !isSameHandler.test((Object)te) && (capability = te.getCapability(requestedCapability, approachDirection.m_122424_())).isPresent()) {
            foundConsumer = capability.orElseThrow(RuntimeException::new);
        }
        boolean bl = isConnectedNow = null != foundConsumer;
        if (wasConnected != isConnectedNow && CodeHelper.calledByLogicalClient(world)) {
            WorldHelper.notifyBlockUpdate(world, position, null, null);
        }
        return (C)foundConsumer;
    }
}

