/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.layout;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.client.gui.DesiredDimension;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.IControlContainer;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalAlignment;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;

public abstract class AbstractLayoutEngine<E extends AbstractLayoutEngine<?>>
implements ILayoutEngine {
    private int _controlsSpacing = 5;
    private int _horizontalMargin = 5;
    private HorizontalAlignment _horizontalAlignment = HorizontalAlignment.Center;
    private int _verticalMargin = 2;
    private VerticalAlignment _verticalAlignment = VerticalAlignment.Center;

    public int getControlsSpacing() {
        return this._controlsSpacing;
    }

    public E setControlsSpacing(int spacing) {
        Preconditions.checkArgument((spacing >= 0 ? 1 : 0) != 0, (Object)"The controls spacing must be equal or greater than zero");
        this._controlsSpacing = spacing;
        return this.self();
    }

    public int getHorizontalMargin() {
        return this._horizontalMargin;
    }

    public E setHorizontalMargin(int horizontalMargin) {
        Preconditions.checkArgument((horizontalMargin >= 0 ? 1 : 0) != 0, (Object)"The horizontal margin must be equal or greater than zero");
        this._horizontalMargin = horizontalMargin;
        return this.self();
    }

    public int getVerticalMargin() {
        return this._verticalMargin;
    }

    public E setVerticalMargin(int verticalMargin) {
        Preconditions.checkArgument((verticalMargin >= 0 ? 1 : 0) != 0, (Object)"The vertical margin must be equal or greater than zero");
        this._verticalMargin = verticalMargin;
        return this.self();
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this._horizontalAlignment;
    }

    public E setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this._horizontalAlignment = horizontalAlignment;
        return this.self();
    }

    public VerticalAlignment getVerticalAlignment() {
        return this._verticalAlignment;
    }

    public E setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this._verticalAlignment = verticalAlignment;
        return this.self();
    }

    public E setZeroMargins() {
        this.setHorizontalMargin(0);
        this.setVerticalMargin(0);
        this.setControlsSpacing(0);
        return this.self();
    }

    protected int getControlDesiredDimension(IControl control, DesiredDimension dimension, int defaultValue) {
        int value = control.getDesiredDimension(dimension);
        return -1 == value ? defaultValue : value;
    }

    protected Rectangle getControlAlignedBounds(IControl control, int x, int y, int maxWidth, int maxHeight) {
        int desiredWidth = Math.min(maxWidth, this.getControlDesiredDimension(control, DesiredDimension.Width, maxWidth));
        int desiredHeight = Math.min(maxHeight, this.getControlDesiredDimension(control, DesiredDimension.Height, maxHeight));
        return new Rectangle(this._horizontalAlignment.align(x, desiredWidth, maxWidth), this._verticalAlignment.align(y, desiredHeight, maxHeight), desiredWidth, desiredHeight);
    }

    protected int computeUndefinedDimensionSize(IControlContainer controlsContainer, DesiredDimension dimension, int availableSize) {
        int controlsCount = 0;
        int fixedCount = 0;
        int fixedSize = 0;
        for (IControl control : controlsContainer) {
            int controlSize = control.getDesiredDimension(dimension);
            if (-1 != controlSize) {
                fixedSize += controlSize;
                ++fixedCount;
            }
            ++controlsCount;
        }
        fixedSize += this.getControlsSpacing() * (controlsCount - 1);
        int undefinedSize = 0;
        if (fixedCount < controlsCount && (undefinedSize = (availableSize - (fixedSize += 2 * (DesiredDimension.Width == dimension ? this.getHorizontalMargin() : this.getVerticalMargin()))) / (controlsCount - fixedCount)) <= 0) {
            undefinedSize = 1;
        }
        return undefinedSize;
    }

    private E self() {
        return (E)this;
    }
}

