/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.model;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.zerono.mods.zerocore.lib.client.model.AbstractDynamicBakedModel;
import it.zerono.mods.zerocore.lib.client.model.data.GenericProperties;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class BlockVariantsModel
extends AbstractDynamicBakedModel {
    private final Int2ObjectMap<BlockEntry> _entries;

    public BlockVariantsModel(int blocksCount, boolean ambientOcclusion, boolean guid3D, boolean builtInRenderer) {
        super(ambientOcclusion, guid3D, builtInRenderer);
        this._entries = new Int2ObjectArrayMap(blocksCount);
    }

    public void addBlock(int blockId, boolean hasGeneralQuads, BakedModel ... variants) {
        this._entries.put(blockId, (Object)new BlockEntry(hasGeneralQuads, variants));
    }

    public void addBlock(int blockId, boolean hasGeneralQuads, List<BakedModel> variants) {
        this._entries.put(blockId, (Object)new BlockEntry(hasGeneralQuads, variants));
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction renderSide, Random rand, IModelData data) {
        if (data.hasProperty(GenericProperties.ID) && data.hasProperty(GenericProperties.VARIANT_INDEX) && this.containsBlock(data)) {
            return this.getBlock(data).getQuads(GenericProperties.getVariantIndex(data), state, renderSide, rand, data);
        }
        return ModRenderHelper.getMissingModel().getQuads(state, renderSide, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    public TextureAtlasSprite getParticleIcon(IModelData data) {
        if (data.hasProperty(GenericProperties.ID) && data.hasProperty(GenericProperties.VARIANT_INDEX) && this.containsBlock(data)) {
            return this.getBlock(data).getParticleTexture(GenericProperties.getVariantIndex(data), data);
        }
        return ModRenderHelper.getMissingModel().getParticleIcon((IModelData)EmptyModelData.INSTANCE);
    }

    private boolean containsBlock(IModelData data) {
        return data.hasProperty(GenericProperties.ID) && this._entries.containsKey(GenericProperties.getId(data));
    }

    private BlockEntry getBlock(IModelData data) {
        return (BlockEntry)this._entries.get(GenericProperties.getId(data));
    }

    private static class BlockEntry {
        private final List<BakedModel> _variants;
        private final boolean _noGeneralQuads;

        BlockEntry(boolean hasGeneralQuads, BakedModel ... variants) {
            this._variants = ImmutableList.copyOf((Object[])variants);
            this._noGeneralQuads = !hasGeneralQuads;
        }

        BlockEntry(boolean hasGeneralQuads, List<BakedModel> variants) {
            this._variants = ImmutableList.copyOf(variants);
            this._noGeneralQuads = !hasGeneralQuads;
        }

        List<BakedQuad> getQuads(int variantIndex, @Nullable BlockState state, @Nullable Direction renderSide, Random rand, IModelData data) {
            if (null == renderSide && this._noGeneralQuads) {
                return Collections.emptyList();
            }
            return this._variants.get(variantIndex).getQuads(state, renderSide, rand, data);
        }

        TextureAtlasSprite getParticleTexture(int variantIndex, IModelData data) {
            return this._variants.get(variantIndex).getParticleIcon(data);
        }
    }
}

