/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.render;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import it.zerono.mods.zerocore.ZeroCore;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.IRichText;
import it.zerono.mods.zerocore.lib.client.gui.Orientation;
import it.zerono.mods.zerocore.lib.client.gui.Padding;
import it.zerono.mods.zerocore.lib.client.gui.sprite.AtlasSpriteTextureMap;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.data.geometry.Point;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import it.zerono.mods.zerocore.lib.data.geometry.Vector3d;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public final class ModRenderHelper {
    public static final float ONE_PIXEL = 0.0625f;
    public static final int GUI_TOPMOST_Z = 900;
    public static final int GUI_ITEM_Z = 600;
    public static final NonNullSupplier<Font> DEFAULT_FONT_RENDERER = () -> Minecraft.m_91087_().f_91062_;
    private static final Colour ITEMSTACK_HIGHLIGHT = Colour.fromARGB(-2130706433);

    public static long getLastRenderTime() {
        return ZeroCore.getProxy().getLastRenderTime();
    }

    public static ModelManager getModelManager() {
        return Minecraft.m_91087_().m_91289_().m_110907_().m_110881_();
    }

    public static UnbakedModel getModel(ResourceLocation location) {
        return ForgeModelBakery.instance().getModelOrMissing(location);
    }

    public static BakedModel getModel(BlockState state) {
        return Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(state);
    }

    public static BakedModel getModel(ModelResourceLocation modelLocation) {
        return ModRenderHelper.getModelManager().m_119422_(modelLocation);
    }

    public static BakedModel getMissingModel() {
        return ModRenderHelper.getModelManager().m_119409_();
    }

    public static void bindTexture(ResourceLocation textureLocation) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)textureLocation);
    }

    public static void bindTexture(ISprite sprite) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)sprite.getTextureMap().getTextureLocation());
    }

    public static void bindBlocksTexture() {
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
    }

    public static TextureAtlasSprite getTextureSprite(ResourceLocation location) {
        return ModRenderHelper.getTextureSprite(InventoryMenu.f_39692_, location);
    }

    public static TextureAtlasSprite getTextureSprite(ResourceLocation atlasName, ResourceLocation spriteName) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(atlasName).apply(spriteName);
    }

    public static TextureAtlasSprite getFluidStillSprite(Fluid fluid) {
        return ModRenderHelper.getTextureSprite(fluid.getAttributes().getStillTexture());
    }

    public static TextureAtlasSprite getFluidStillSprite(FluidStack fluid) {
        return ModRenderHelper.getTextureSprite(fluid.getFluid().getAttributes().getStillTexture(fluid));
    }

    public static TextureAtlasSprite getFluidFlowingSprite(Fluid fluid) {
        return ModRenderHelper.getTextureSprite(fluid.getAttributes().getFlowingTexture());
    }

    public static TextureAtlasSprite getFluidFlowingSprite(FluidStack fluid) {
        return ModRenderHelper.getTextureSprite(fluid.getFluid().getAttributes().getFlowingTexture(fluid));
    }

    public static TextureAtlasSprite getMissingTexture(ResourceLocation atlasName) {
        return ModRenderHelper.getTextureSprite(atlasName, MissingTextureAtlasSprite.m_118071_());
    }

    public static TextureAtlasSprite getMissingTexture() {
        return ModRenderHelper.getTextureSprite(MissingTextureAtlasSprite.m_118071_());
    }

    @Nullable
    public static TextureAtlasSprite getFluidOverlaySprite(Fluid fluid) {
        ResourceLocation rl = fluid.getAttributes().getOverlayTexture();
        return null != rl ? ModRenderHelper.getTextureSprite(rl) : null;
    }

    @Nullable
    public static TextureAtlasSprite getFluidOverlaySprite(FluidStack fluid) {
        ResourceLocation rl = fluid.getFluid().getAttributes().getOverlayTexture();
        return null != rl ? ModRenderHelper.getTextureSprite(rl) : null;
    }

    public static ISprite getStillFluidSprite(Fluid fluid) {
        return ModRenderHelper.buildSprite(ModRenderHelper.getFluidStillSprite(fluid), null);
    }

    public static ISprite getStillFluidSpriteWithOverlay(Fluid fluid) {
        return ModRenderHelper.buildSprite(ModRenderHelper.getFluidStillSprite(fluid), ModRenderHelper.getFluidOverlaySprite(fluid));
    }

    public static ISprite getFlowingFluidSprite(Fluid fluid) {
        return ModRenderHelper.buildSprite(ModRenderHelper.getFluidFlowingSprite(fluid), null);
    }

    public static ISprite getFlowingFluidSpriteWithOverlay(Fluid fluid) {
        return ModRenderHelper.buildSprite(ModRenderHelper.getFluidFlowingSprite(fluid), ModRenderHelper.getFluidOverlaySprite(fluid));
    }

    private static ISprite buildSprite(TextureAtlasSprite main, @Nullable TextureAtlasSprite overlay) {
        ISprite s = AtlasSpriteTextureMap.from(main).sprite(main);
        if (null != overlay) {
            return s.copyWith(AtlasSpriteTextureMap.from(overlay).sprite(overlay));
        }
        return s;
    }

    public static List<FormattedText> splitLines(Font font, String line, int maxLineWidth) {
        return ModRenderHelper.splitLines(font, line, maxLineWidth, Style.f_131099_);
    }

    public static List<FormattedText> splitLines(Font font, String line, int maxLineWidth, Style lineStyle) {
        return font.m_92865_().m_92432_(line, maxLineWidth, lineStyle);
    }

    public static List<FormattedText> splitLines(Font font, FormattedText line, int maxLineWidth) {
        return ModRenderHelper.splitLines(font, line, maxLineWidth, Style.f_131099_);
    }

    public static List<FormattedText> splitLines(Font font, FormattedText line, int maxLineWidth, Style lineStyle) {
        return font.m_92865_().m_92414_(line, maxLineWidth, lineStyle);
    }

    @Deprecated
    public static List<FormattedText> wrapLines(FormattedText line, int maxLineWidth, Font font) {
        return ModRenderHelper.wrapLines(line, Style.f_131099_, maxLineWidth, font);
    }

    @Deprecated
    public static List<FormattedText> wrapLines(FormattedText line, Style lineStyle, int maxLineWidth, Font font) {
        return font.m_92865_().m_92414_(line, maxLineWidth, lineStyle);
    }

    @Deprecated
    public static List<String> wrapLines(String text, int maxLineWidth, Font font) {
        LinkedList lines = Lists.newLinkedList();
        int spaceWidth = font.m_92895_(" ");
        String[] tokens = text.split("\\s+");
        Integer[] tokenWidths = (Integer[])Arrays.stream(tokens).map(arg_0 -> ((Font)font).m_92895_(arg_0)).toArray(Integer[]::new);
        StringBuilder wrappedLine = new StringBuilder(text.length());
        int lineWidth = 0;
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            int tokenWidth = tokenWidths[i];
            if (lineWidth + tokenWidth + spaceWidth > maxLineWidth) {
                lines.add(wrappedLine.toString());
                wrappedLine = new StringBuilder(text.length());
                lineWidth = 0;
            }
            if (i < tokens.length - 1 && lineWidth + tokenWidth + spaceWidth + tokenWidths[i + 1] <= maxLineWidth) {
                wrappedLine.append(token);
                wrappedLine.append(" ");
                lineWidth += tokenWidth + spaceWidth;
                continue;
            }
            wrappedLine.append(token);
            lineWidth += tokenWidth;
        }
        if (wrappedLine.length() > 0) {
            lines.add(wrappedLine.toString());
        }
        return lines;
    }

    public static void renderQuads(PoseStack matrix, VertexConsumer builder, List<BakedQuad> quads, int combinedLight, int combinedOverlay) {
        PoseStack.Pose entry = matrix.m_85850_();
        for (BakedQuad quad : quads) {
            builder.putBulkData(entry, quad, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay, true);
        }
    }

    public static void renderQuads(PoseStack matrix, VertexConsumer builder, List<BakedQuad> quads, int combinedLight, int combinedOverlay, IntFunction<Colour> quadTintGetter) {
        PoseStack.Pose entry = matrix.m_85850_();
        for (BakedQuad quad : quads) {
            float blue;
            float green;
            float red;
            if (quad.m_111304_()) {
                Colour tint = quadTintGetter.apply(quad.m_111305_());
                red = tint.R;
                green = tint.G;
                blue = tint.B;
            } else {
                blue = 1.0f;
                green = 1.0f;
                red = 1.0f;
            }
            builder.putBulkData(entry, quad, red, green, blue, combinedLight, combinedOverlay, true);
        }
    }

    public static void renderModel(BakedModel model, IModelData data, PoseStack matrix, VertexConsumer builder, int combinedLight, int combinedOverlay) {
        for (Direction direction : CodeHelper.DIRECTIONS) {
            ModRenderHelper.renderQuads(matrix, builder, model.getQuads(null, direction, CodeHelper.fakeRandom(), data), combinedLight, combinedOverlay);
        }
        ModRenderHelper.renderQuads(matrix, builder, model.getQuads(null, null, CodeHelper.fakeRandom(), data), combinedLight, combinedOverlay);
    }

    public static void renderModel(BakedModel model, IModelData data, PoseStack matrix, VertexConsumer builder, int combinedLight, int combinedOverlay, IntFunction<Colour> quadTintGetter) {
        for (Direction direction : CodeHelper.DIRECTIONS) {
            ModRenderHelper.renderQuads(matrix, builder, model.getQuads(null, direction, CodeHelper.fakeRandom(), data), combinedLight, combinedOverlay, quadTintGetter);
        }
        ModRenderHelper.renderQuads(matrix, builder, model.getQuads(null, null, CodeHelper.fakeRandom(), data), combinedLight, combinedOverlay, quadTintGetter);
    }

    public static Vector3d[] getQuadVerticesFor(Direction face, float width, float height, float depth) {
        return ModRenderHelper.getQuadVerticesFor(face, width, height, depth, Vector3d.ZERO);
    }

    public static Vector3d[] getQuadVerticesFor(Direction face, float width, float height, float depth, Vector3d offset) {
        Vector3d bottomToTop;
        Vector3d leftToRight;
        Vector3d nearToFar = switch (face) {
            case Direction.NORTH -> {
                leftToRight = Vector3d.XN;
                bottomToTop = Vector3d.YP;
                yield Vector3d.ZN;
            }
            case Direction.SOUTH -> {
                leftToRight = Vector3d.XP;
                bottomToTop = Vector3d.YP;
                yield Vector3d.ZP;
            }
            case Direction.EAST -> {
                leftToRight = Vector3d.ZN;
                bottomToTop = Vector3d.YP;
                yield Vector3d.XP;
            }
            default -> {
                leftToRight = Vector3d.ZP;
                bottomToTop = Vector3d.YP;
                yield Vector3d.XN;
            }
            case Direction.UP -> {
                leftToRight = Vector3d.XN;
                bottomToTop = Vector3d.ZP;
                yield Vector3d.YP;
            }
            case Direction.DOWN -> {
                leftToRight = Vector3d.XP;
                bottomToTop = Vector3d.ZP;
                yield Vector3d.YN;
            }
        };
        leftToRight = leftToRight.multiply((double)width * 0.5);
        bottomToTop = bottomToTop.multiply((double)height * 0.5);
        nearToFar = nearToFar.multiply((double)depth * 0.5);
        Vector3d[] vertices = new Vector3d[]{Vector3d.HALF.subtract(leftToRight).subtract(bottomToTop).add(nearToFar).add(offset), Vector3d.HALF.add(leftToRight).subtract(bottomToTop).add(nearToFar).add(offset), Vector3d.HALF.add(leftToRight).add(bottomToTop).add(nearToFar).add(offset), Vector3d.HALF.subtract(leftToRight).add(bottomToTop).add(nearToFar).add(offset)};
        return vertices;
    }

    public static void paintVoxelShape(PoseStack matrix, VoxelShape shape, VertexConsumer vertexBuilder, double originX, double originY, double originZ, Colour colour) {
        Matrix4f m = matrix.m_85850_().m_85861_();
        float red = colour.glRed();
        float green = colour.glGreen();
        float blue = colour.glBlue();
        float alpha = colour.glAlpha();
        shape.m_83224_((x1, y1, z1, x2, y2, z2) -> {
            vertexBuilder.m_85982_(m, (float)(x1 + originX), (float)(y1 + originY), (float)(z1 + originZ)).m_85950_(red, green, blue, alpha).m_5752_();
            vertexBuilder.m_85982_(m, (float)(x2 + originX), (float)(y2 + originY), (float)(z2 + originZ)).m_85950_(red, green, blue, alpha).m_5752_();
        });
    }

    public static void paintSprite(PoseStack matrix, ISprite sprite, Point screenXY, int zLevel, int width, int height) {
        ModRenderHelper.paintSprite(matrix, sprite, screenXY.X, screenXY.Y, zLevel, width, height);
    }

    public static void paintSprite(PoseStack matrix, ISprite sprite, int x, int y, int zLevel, int width, int height) {
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        ModRenderHelper.bindTexture(sprite);
        ModRenderHelper.blitSprite(matrix, x, x + width, y, y + height, zLevel, sprite.getWidth(), sprite.getHeight(), sprite.getU(), sprite.getV(), sprite.getTextureMap().getWidth(), sprite.getTextureMap().getHeight());
        RenderSystem.m_69461_();
        sprite.applyOverlay((NonNullConsumer<ISprite>)((NonNullConsumer)o -> ModRenderHelper.paintSprite(matrix, o, x, y, zLevel, width, height)));
    }

    public static void paintSprite(PoseStack matrix, ISprite sprite, int xOffset, int yOffset, int zLevel, Padding padding, int width, int height, int maskTop, int maskBottom, int maskLeft, int maskRight) {
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        ModRenderHelper.bindTexture(sprite);
        int x = xOffset + padding.getLeft() + maskLeft;
        int y = yOffset + padding.getTop() + maskTop;
        int u = sprite.getU() + maskLeft;
        int v = sprite.getV() + maskTop;
        int paintWidth = width - maskRight - maskLeft;
        int paintHeight = height - maskBottom - maskTop;
        float widthRatio = 1.0f / (float)sprite.getTextureMap().getWidth();
        float heightRatio = 1.0f / (float)sprite.getTextureMap().getHeight();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        Matrix4f pose = matrix.m_85850_().m_85861_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_85982_(pose, (float)x, (float)(y + paintHeight), (float)zLevel).m_7421_((float)u * widthRatio, ((float)v + (float)paintHeight) * heightRatio).m_5752_();
        bufferbuilder.m_85982_(pose, (float)(x + paintWidth), (float)(y + paintHeight), (float)zLevel).m_7421_(((float)u + (float)paintWidth) * widthRatio, ((float)v + (float)paintHeight) * heightRatio).m_5752_();
        bufferbuilder.m_85982_(pose, (float)(x + paintWidth), (float)y, (float)zLevel).m_7421_(((float)u + (float)paintWidth) * widthRatio, (float)v * heightRatio).m_5752_();
        bufferbuilder.m_85982_(pose, (float)x, (float)y, (float)zLevel).m_7421_((float)u * widthRatio, (float)v * heightRatio).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69461_();
        sprite.applyOverlay((NonNullConsumer<ISprite>)((NonNullConsumer)o -> ModRenderHelper.paintSprite(matrix, o, xOffset, yOffset, zLevel, padding, width, height, maskTop, maskBottom, maskLeft, maskRight)));
    }

    public static int paintVerticalProgressSprite(PoseStack matrix, ISprite sprite, Colour tint, Point screenXY, int zLevel, Rectangle area, int skip, double progress) {
        return ModRenderHelper.paintVerticalProgressSprite(matrix, sprite, tint, screenXY.X, screenXY.Y, zLevel, area.Width, area.Height, skip, progress);
    }

    public static int paintVerticalProgressSprite(PoseStack matrix, ISprite sprite, Colour tint, int x, int y, int zLevel, int areaWidth, int areaHeight, int skip, double progress) {
        if (progress < 0.01) {
            return 0;
        }
        int filledHeight = (int)((double)areaHeight * progress);
        int y2 = y + areaHeight - skip;
        int y1 = y2 - filledHeight;
        ModRenderHelper.paintProgressSprite(matrix, sprite, tint, x, y1, x + areaWidth, y2, zLevel);
        return filledHeight;
    }

    @Deprecated
    public static void paintVerticalProgressBarSprite(PoseStack matrix, ISprite sprite, Point screenXY, int zLevel, Rectangle area, double progress) {
        ModRenderHelper.paintVerticalProgressBarSprite(matrix, sprite, screenXY.X, screenXY.Y, zLevel, area.Width, area.Height, progress, Colour.WHITE);
    }

    @Deprecated
    public static void paintVerticalProgressBarSprite(PoseStack matrix, ISprite sprite, Point screenXY, int zLevel, Rectangle area, double progress, Colour tint) {
        ModRenderHelper.paintVerticalProgressBarSprite(matrix, sprite, screenXY.X, screenXY.Y, zLevel, area.Width, area.Height, progress, tint);
    }

    @Deprecated
    public static void paintVerticalProgressBarSprite(PoseStack matrix, ISprite sprite, int x, int y, int zLevel, int areaWidth, int areaHeight, double progress) {
        ModRenderHelper.paintVerticalProgressBarSprite(matrix, sprite, x, y, zLevel, areaWidth, areaHeight, progress, Colour.WHITE);
    }

    @Deprecated
    public static void paintVerticalProgressBarSprite(PoseStack matrix, ISprite sprite, int x, int y, int zLevel, int areaWidth, int areaHeight, double progress, Colour tint) {
        if (progress < 0.01) {
            return;
        }
        int filledHeight = (int)((double)areaHeight * progress);
        int y1 = y + (areaHeight - filledHeight);
        int y2 = y + areaHeight;
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        ModRenderHelper.bindTexture(sprite);
        if (sprite.getHeight() == areaHeight) {
            ModRenderHelper.blitSprite(matrix, x, x + sprite.getWidth(), y, y + sprite.getHeight(), zLevel, sprite.getWidth(), sprite.getHeight(), sprite.getU(), sprite.getV(), sprite.getTextureMap().getWidth(), sprite.getTextureMap().getHeight(), tint);
        } else {
            int spriteHeight = sprite.getHeight();
            float verticalSlices = (float)filledHeight / (float)spriteHeight;
            int verticalSliceIdx = 0;
            while ((float)verticalSliceIdx <= verticalSlices - 1.0f) {
                int sliceY2 = y2 - verticalSliceIdx * spriteHeight;
                int sliceY1 = sliceY2 - spriteHeight;
                ModRenderHelper.blitSprite(matrix, x, x + areaWidth + 16, sliceY1, sliceY2, zLevel, sprite.getWidth(), sprite.getHeight(), sprite.getU(), sprite.getV(), sprite.getTextureMap().getWidth(), sprite.getTextureMap().getHeight(), tint);
                verticalSliceIdx = 5;
                ++verticalSliceIdx;
            }
            float missing = verticalSlices - (float)verticalSliceIdx;
            if (missing > 0.0f) {
                int sliceY2 = y2 - verticalSliceIdx * spriteHeight;
                int sliceY1 = sliceY2 - (int)Math.ceil((float)spriteHeight * missing);
                ModRenderHelper.blitSprite(matrix, x, x + areaWidth, sliceY1, sliceY2, zLevel, sprite.getWidth(), sprite.getHeight(), sprite.getU(), sprite.getV(), sprite.getTextureMap().getWidth(), sprite.getTextureMap().getHeight(), tint);
            }
        }
        RenderSystem.m_69461_();
        sprite.applyOverlay((NonNullConsumer<ISprite>)((NonNullConsumer)o -> ModRenderHelper.paintSprite(matrix, o, x, y, zLevel, areaWidth, areaHeight)));
    }

    @Deprecated
    public static void paintFlippedVerticalProgressBarSprite(PoseStack matrix, ISprite sprite, Point screenXY, int zLevel, Rectangle area, double progress) {
        ModRenderHelper.paintFlippedVerticalProgressBarSprite(matrix, sprite, screenXY.X, screenXY.Y, zLevel, area.Width, area.Height, progress, Colour.WHITE);
    }

    @Deprecated
    public static void paintFlippedVerticalProgressBarSprite(PoseStack matrix, ISprite sprite, Point screenXY, int zLevel, Rectangle area, double progress, Colour tint) {
        ModRenderHelper.paintFlippedVerticalProgressBarSprite(matrix, sprite, screenXY.X, screenXY.Y, zLevel, area.Width, area.Height, progress, tint);
    }

    @Deprecated
    public static void paintFlippedVerticalProgressBarSprite(PoseStack matrix, ISprite sprite, int x, int y, int zLevel, int areaWidth, int areaHeight, double progress) {
        ModRenderHelper.paintFlippedVerticalProgressBarSprite(matrix, sprite, x, y, zLevel, areaWidth, areaHeight, progress, Colour.WHITE);
    }

    @Deprecated
    public static void paintFlippedVerticalProgressBarSprite(PoseStack matrix, ISprite sprite, int x, int y, int zLevel, int areaWidth, int areaHeight, double progress, Colour tint) {
        if (progress < 0.01) {
            return;
        }
        int spriteHeight = sprite.getHeight();
        int filledHeight = (int)((double)areaHeight * progress);
        int y1 = y;
        int y2 = y + filledHeight;
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        ModRenderHelper.bindTexture(sprite);
        if (spriteHeight == areaHeight) {
            ModRenderHelper.blitSprite(matrix, x, x + areaWidth, y1, y2, zLevel, sprite.getWidth(), filledHeight, sprite.getU(), sprite.getV() + (sprite.getHeight() - filledHeight), sprite.getTextureMap().getWidth(), sprite.getTextureMap().getHeight(), tint);
        } else {
            float verticalSlices = (float)filledHeight / 16.0f;
            int verticalSliceIdx = 0;
            while ((float)verticalSliceIdx <= verticalSlices - 1.0f) {
                int sliceY1 = y1 + verticalSliceIdx * 16;
                int sliceY2 = sliceY1 + 16;
                ModRenderHelper.blitSprite(matrix, x, x + areaWidth, sliceY1, sliceY2, zLevel, sprite.getWidth(), sprite.getHeight(), sprite.getU(), sprite.getV(), sprite.getTextureMap().getWidth(), sprite.getTextureMap().getHeight(), tint);
                ++verticalSliceIdx;
            }
            float missing = verticalSlices - (float)verticalSliceIdx;
            if (missing > 0.0f) {
                int h = (int)Math.ceil(16.0f * missing);
                int sliceY1 = y1 + verticalSliceIdx * 16;
                int sliceY2 = sliceY1 + h;
                ModRenderHelper.blitSprite(matrix, x, x + areaWidth, sliceY1, sliceY2, zLevel, sprite.getWidth(), h, sprite.getU(), sprite.getV(), sprite.getTextureMap().getWidth(), sprite.getTextureMap().getHeight(), tint);
            }
        }
        RenderSystem.m_69461_();
        sprite.applyOverlay((NonNullConsumer<ISprite>)((NonNullConsumer)o -> ModRenderHelper.paintSprite(matrix, o, x, y, zLevel, areaWidth, areaHeight)));
    }

    @Deprecated
    public static int paintHorizontalProgressSprite(PoseStack matrix, ISprite sprite, Colour tint, Point screenXY, int zLevel, Rectangle area, int skip, double progress) {
        return ModRenderHelper.paintHorizontalProgressSprite(matrix, sprite, tint, screenXY.X, screenXY.Y, zLevel, area.Width, area.Height, skip, progress);
    }

    @Deprecated
    public static int paintHorizontalProgressSprite(PoseStack matrix, ISprite sprite, Colour tint, int x, int y, int zLevel, int areaWidth, int areaHeight, int skip, double progress) {
        if (progress < 0.01) {
            return 0;
        }
        int filledWidth = (int)((double)areaWidth * progress);
        int x1 = x + skip;
        int x2 = x1 + filledWidth;
        ModRenderHelper.paintProgressSprite(matrix, sprite, tint, x1, y, x2, y + areaHeight, zLevel);
        return filledWidth;
    }

    @Deprecated
    private static void paintProgressSprite(PoseStack matrix, ISprite sprite, Colour tint, int x1, int y1, int x2, int y2, int zLevel) {
        ModRenderHelper.bindTexture(sprite);
        ModRenderHelper.blitSprite(matrix.m_85850_().m_85861_(), x1, x2, y1, y2, zLevel, sprite.getMinU(), sprite.getMaxU(), sprite.getMinV(), sprite.getMaxV(), tint);
        sprite.applyOverlay((NonNullConsumer<ISprite>)((NonNullConsumer)o -> ModRenderHelper.paintProgressSprite(matrix, o, tint, x1, y1, x2, y2, zLevel)));
    }

    public static void paintOrientedProgressBarSprite(PoseStack matrix, Orientation orientation, ISprite sprite, Point screenXY, int zLevel, Rectangle area, double progress, Colour tint) {
        switch (orientation) {
            case BottomToTop: {
                ModRenderHelper.paintBottomToTopTiledSprite(matrix, sprite, tint, screenXY.X, screenXY.Y + area.Height, zLevel, area.Width, (int)((double)area.Height * progress));
                break;
            }
            case TopToBottom: {
                ModRenderHelper.paintTopToBottomTiledSprite(matrix, sprite, tint, screenXY.X, screenXY.Y, zLevel, area.Width, (int)((double)area.Height * progress));
                break;
            }
            case LeftToRight: {
                ModRenderHelper.paintLeftToRightTiledSprite(matrix, sprite, tint, screenXY.X, screenXY.Y, zLevel, (int)((double)area.Width * progress), area.Height);
                break;
            }
            case RightToLeft: {
                ModRenderHelper.paintRightToLeftTiledSprite(matrix, sprite, tint, screenXY.X + area.Width, screenXY.Y, zLevel, (int)((double)area.Width * progress), area.Height);
            }
        }
    }

    public static void paintOrientedProgressBarSprite(PoseStack matrix, Orientation orientation, ISprite sprite, int x, int y, int zLevel, int areaWidth, int areaHeight, double progress, Colour tint) {
        switch (orientation) {
            case BottomToTop: {
                ModRenderHelper.paintBottomToTopTiledSprite(matrix, sprite, tint, x, y + areaHeight, zLevel, areaWidth, (int)((double)areaHeight * progress));
                break;
            }
            case TopToBottom: {
                ModRenderHelper.paintTopToBottomTiledSprite(matrix, sprite, tint, x, y, zLevel, areaWidth, (int)((double)areaHeight * progress));
                break;
            }
            case LeftToRight: {
                ModRenderHelper.paintLeftToRightTiledSprite(matrix, sprite, tint, x, y, zLevel, (int)((double)areaWidth * progress), areaHeight);
                break;
            }
            case RightToLeft: {
                ModRenderHelper.paintRightToLeftTiledSprite(matrix, sprite, tint, x + areaWidth, y, zLevel, (int)((double)areaWidth * progress), areaHeight);
            }
        }
    }

    public static void paintTopToBottomTiledSprite(PoseStack matrix, ISprite sprite, Colour tint, int x, int y, int zLevel, int paintWidth, int paintHeight) {
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        Matrix4f pose = matrix.m_85850_().m_85861_();
        float spriteMinU = sprite.getMinU();
        float spriteMaxU = sprite.getMaxU();
        float spriteMinV = sprite.getMinV();
        float spriteMaxV = sprite.getMaxV();
        float deltaU = spriteMaxU - spriteMinU;
        float deltaV = spriteMaxV - spriteMinV;
        int spriteWidth = sprite.getWidth();
        int spriteHeight = sprite.getHeight();
        int horizontalTiles = paintWidth / spriteWidth;
        int verticalTiles = paintHeight / spriteHeight;
        int leftoverWidth = paintWidth - horizontalTiles * spriteWidth;
        int leftoverHeight = paintHeight - verticalTiles * spriteHeight;
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        ModRenderHelper.bindTexture(sprite);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        block0: for (int horizontalTile = 0; horizontalTile <= horizontalTiles; ++horizontalTile) {
            int width;
            int n = width = horizontalTile == horizontalTiles ? leftoverWidth : spriteWidth;
            if (0 == width) break;
            int skippedWidth = spriteWidth - width;
            float tileMaxU = spriteMaxU - deltaU * (float)skippedWidth / (float)spriteWidth;
            int tileX1 = x + horizontalTile * spriteWidth;
            int tileX2 = tileX1 + spriteWidth - skippedWidth;
            for (int verticalTile = 0; verticalTile <= verticalTiles; ++verticalTile) {
                int height;
                int n2 = height = verticalTile == verticalTiles ? leftoverHeight : spriteHeight;
                if (0 == height) continue block0;
                int skippedHeight = spriteHeight - height;
                float tileMaxV = spriteMaxV - deltaV * (float)skippedHeight / (float)spriteHeight;
                int tileY1 = y + verticalTile * spriteHeight;
                int tileY2 = tileY1 + height;
                bufferBuilder.m_85982_(pose, (float)tileX1, (float)tileY2, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(spriteMinU, tileMaxV).m_5752_();
                bufferBuilder.m_85982_(pose, (float)tileX2, (float)tileY2, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(tileMaxU, tileMaxV).m_5752_();
                bufferBuilder.m_85982_(pose, (float)tileX2, (float)tileY1, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(tileMaxU, spriteMinV).m_5752_();
                bufferBuilder.m_85982_(pose, (float)tileX1, (float)tileY1, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(spriteMinU, spriteMinV).m_5752_();
            }
        }
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
        RenderSystem.m_69461_();
    }

    public static void paintBottomToTopTiledSprite(PoseStack matrix, ISprite sprite, Colour tint, int x, int y, int zLevel, int paintWidth, int paintHeight) {
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        Matrix4f pose = matrix.m_85850_().m_85861_();
        float spriteMinU = sprite.getMinU();
        float spriteMaxU = sprite.getMaxU();
        float spriteMinV = sprite.getMinV();
        float spriteMaxV = sprite.getMaxV();
        float deltaU = spriteMaxU - spriteMinU;
        float deltaV = spriteMaxV - spriteMinV;
        int spriteWidth = sprite.getWidth();
        int spriteHeight = sprite.getHeight();
        int horizontalTiles = paintWidth / spriteWidth;
        int verticalTiles = paintHeight / spriteHeight;
        int leftoverWidth = paintWidth - horizontalTiles * spriteWidth;
        int leftoverHeight = paintHeight - verticalTiles * spriteHeight;
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        ModRenderHelper.bindTexture(sprite);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        block0: for (int horizontalTile = 0; horizontalTile <= horizontalTiles; ++horizontalTile) {
            int width;
            int n = width = horizontalTile == horizontalTiles ? leftoverWidth : spriteWidth;
            if (0 == width) break;
            int skippedWidth = spriteWidth - width;
            float tileMaxU = spriteMaxU - deltaU * (float)skippedWidth / (float)spriteWidth;
            int tileX1 = x + horizontalTile * spriteWidth;
            int tileX2 = tileX1 + spriteWidth - skippedWidth;
            for (int verticalTile = 0; verticalTile <= verticalTiles; ++verticalTile) {
                int height;
                int n2 = height = verticalTile == verticalTiles ? leftoverHeight : spriteHeight;
                if (0 == height) continue block0;
                int skippedHeight = spriteHeight - height;
                float tileMinV = spriteMaxV - deltaV * (float)height / (float)spriteHeight;
                int baseY = y - (verticalTile + 1) * spriteHeight;
                int tileY1 = baseY + skippedHeight;
                int tileY2 = baseY + spriteHeight;
                bufferBuilder.m_85982_(pose, (float)tileX1, (float)tileY2, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(spriteMinU, spriteMaxV).m_5752_();
                bufferBuilder.m_85982_(pose, (float)tileX2, (float)tileY2, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(tileMaxU, spriteMaxV).m_5752_();
                bufferBuilder.m_85982_(pose, (float)tileX2, (float)tileY1, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(tileMaxU, tileMinV).m_5752_();
                bufferBuilder.m_85982_(pose, (float)tileX1, (float)tileY1, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(spriteMinU, tileMinV).m_5752_();
            }
        }
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
        RenderSystem.m_69461_();
    }

    public static void paintLeftToRightTiledSprite(PoseStack matrix, ISprite sprite, Colour tint, int x, int y, int zLevel, int paintWidth, int paintHeight) {
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        Matrix4f pose = matrix.m_85850_().m_85861_();
        float spriteMinU = sprite.getMinU();
        float spriteMaxU = sprite.getMaxU();
        float spriteMinV = sprite.getMinV();
        float spriteMaxV = sprite.getMaxV();
        float deltaU = spriteMaxU - spriteMinU;
        float deltaV = spriteMaxV - spriteMinV;
        int spriteWidth = sprite.getWidth();
        int spriteHeight = sprite.getHeight();
        int horizontalTiles = paintWidth / spriteWidth;
        int verticalTiles = paintHeight / spriteHeight;
        int leftoverWidth = paintWidth - horizontalTiles * spriteWidth;
        int leftoverHeight = paintHeight - verticalTiles * spriteHeight;
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        ModRenderHelper.bindTexture(sprite);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        block0: for (int horizontalTile = 0; horizontalTile <= horizontalTiles; ++horizontalTile) {
            int width;
            int n = width = horizontalTile == horizontalTiles ? leftoverWidth : spriteWidth;
            if (0 == width) break;
            int skippedWidth = spriteWidth - width;
            float tileMaxU = spriteMaxU - deltaU * (float)skippedWidth / (float)spriteWidth;
            int tileX1 = x + horizontalTile * spriteWidth;
            int tileX2 = tileX1 + spriteWidth - skippedWidth;
            for (int verticalTile = 0; verticalTile <= verticalTiles; ++verticalTile) {
                int height;
                int n2 = height = verticalTile == verticalTiles ? leftoverHeight : spriteHeight;
                if (0 == height) continue block0;
                int skippedHeight = spriteHeight - height;
                float tileMaxV = spriteMaxV - deltaV * (float)skippedHeight / (float)spriteHeight;
                int baseY = y + verticalTile * spriteHeight;
                int tileY1 = baseY + skippedHeight;
                int tileY2 = baseY + spriteHeight;
                bufferBuilder.m_85982_(pose, (float)tileX1, (float)tileY2, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(spriteMinU, tileMaxV).m_5752_();
                bufferBuilder.m_85982_(pose, (float)tileX2, (float)tileY2, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(tileMaxU, tileMaxV).m_5752_();
                bufferBuilder.m_85982_(pose, (float)tileX2, (float)tileY1, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(tileMaxU, spriteMinV).m_5752_();
                bufferBuilder.m_85982_(pose, (float)tileX1, (float)tileY1, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(spriteMinU, spriteMinV).m_5752_();
            }
        }
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
        RenderSystem.m_69461_();
    }

    public static void paintRightToLeftTiledSprite(PoseStack matrix, ISprite sprite, Colour tint, int x, int y, int zLevel, int paintWidth, int paintHeight) {
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        Matrix4f pose = matrix.m_85850_().m_85861_();
        float spriteMinU = sprite.getMinU();
        float spriteMaxU = sprite.getMaxU();
        float spriteMinV = sprite.getMinV();
        float spriteMaxV = sprite.getMaxV();
        float deltaU = spriteMaxU - spriteMinU;
        float deltaV = spriteMaxV - spriteMinV;
        int spriteWidth = sprite.getWidth();
        int spriteHeight = sprite.getHeight();
        int horizontalTiles = paintWidth / spriteWidth;
        int verticalTiles = paintHeight / spriteHeight;
        int leftoverWidth = paintWidth - horizontalTiles * spriteWidth;
        int leftoverHeight = paintHeight - verticalTiles * spriteHeight;
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        ModRenderHelper.bindTexture(sprite);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        block0: for (int horizontalTile = 0; horizontalTile <= horizontalTiles; ++horizontalTile) {
            int width;
            int n = width = horizontalTile == horizontalTiles ? leftoverWidth : spriteWidth;
            if (0 == width) break;
            int skippedWidth = spriteWidth - width;
            float tileMinU = spriteMaxU - deltaU * (float)width / (float)spriteWidth;
            int tileX2 = x - horizontalTile * spriteWidth;
            int tileX1 = tileX2 - spriteWidth + skippedWidth;
            for (int verticalTile = 0; verticalTile <= verticalTiles; ++verticalTile) {
                int height;
                int n2 = height = verticalTile == verticalTiles ? leftoverHeight : spriteHeight;
                if (0 == height) continue block0;
                int skippedHeight = spriteHeight - height;
                float tileMaxV = spriteMaxV - deltaV * (float)skippedHeight / (float)spriteHeight;
                int baseY = y + verticalTile * spriteHeight;
                int tileY1 = baseY + skippedHeight;
                int tileY2 = baseY + spriteHeight;
                bufferBuilder.m_85982_(pose, (float)tileX1, (float)tileY2, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(tileMinU, tileMaxV).m_5752_();
                bufferBuilder.m_85982_(pose, (float)tileX2, (float)tileY2, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(spriteMaxU, tileMaxV).m_5752_();
                bufferBuilder.m_85982_(pose, (float)tileX2, (float)tileY1, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(spriteMaxU, spriteMinV).m_5752_();
                bufferBuilder.m_85982_(pose, (float)tileX1, (float)tileY1, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(tileMinU, spriteMinV).m_5752_();
            }
        }
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
        RenderSystem.m_69461_();
    }

    public static void paintSolidRect(PoseStack matrix, Point screenXY1, Point screenXY2, int zLevel, Colour colour) {
        ModRenderHelper.fill(matrix.m_85850_().m_85861_(), screenXY1.X, screenXY1.Y, screenXY2.X, screenXY2.Y, zLevel, colour.toARGB());
    }

    public static void paintSolidRect(PoseStack matrix, int x1, int y1, int x2, int y2, int zLevel, Colour colour) {
        ModRenderHelper.fill(matrix.m_85850_().m_85861_(), x1, y1, x2, y2, zLevel, colour.toARGB());
    }

    public static void paintHollowRect(PoseStack matrix, Point screenXY, int width, int height, int zLevel, Colour colour) {
        ModRenderHelper.paintHollowRect(matrix, screenXY.X, screenXY.Y, width, height, zLevel, colour);
    }

    public static void paintHollowRect(PoseStack matrix, int x1, int y1, int width, int height, int zLevel, Colour colour) {
        ModRenderHelper.paintHorizontalLine(matrix, x1, y1, width, zLevel, colour);
        ModRenderHelper.paintVerticalLine(matrix, x1 + width - 1, y1 + 1, height - 2, zLevel, colour);
        ModRenderHelper.paintHorizontalLine(matrix, x1, y1 + height - 1, width, zLevel, colour);
        ModRenderHelper.paintVerticalLine(matrix, x1, y1 + 1, height - 2, zLevel, colour);
    }

    public static void paintTriangularGradientRect(PoseStack matrix, int x, int y, int width, int height, int zLevel, Colour lightColour, Colour darkColour) {
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder builder = tessellator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f pose = matrix.m_85850_().m_85861_();
        float startAlpha = lightColour.glAlpha();
        float startRed = lightColour.glRed();
        float startGreen = lightColour.glGreen();
        float startBlue = lightColour.glBlue();
        float endAlpha = darkColour.glAlpha();
        float endRed = darkColour.glRed();
        float endGreen = darkColour.glGreen();
        float endBlue = darkColour.glBlue();
        int x2 = x + width - 1;
        int y2 = y + height - 1;
        builder.m_85982_(pose, (float)x2, (float)y, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        builder.m_85982_(pose, (float)x, (float)y, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        builder.m_85982_(pose, (float)x, (float)y2, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        builder.m_85982_(pose, (float)x2, (float)y2, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public static void paintHorizontalLine(PoseStack matrix, Point screenXY, int length, int zLevel, Colour colour) {
        ModRenderHelper.fill(matrix.m_85850_().m_85861_(), screenXY.X, screenXY.Y, screenXY.X + length + 1, screenXY.Y + 1, zLevel, colour.toARGB());
    }

    public static void paintHorizontalLine(PoseStack matrix, int x, int y, int length, int zLevel, Colour colour) {
        ModRenderHelper.fill(matrix.m_85850_().m_85861_(), x, y, x + length, y + 1, zLevel, colour.toARGB());
    }

    public static void paintVerticalLine(PoseStack matrix, Point screenXY, int length, int zLevel, Colour colour) {
        ModRenderHelper.fill(matrix.m_85850_().m_85861_(), screenXY.X, screenXY.Y, screenXY.X + 1, screenXY.Y + length + 1, zLevel, colour.toARGB());
    }

    public static void paintVerticalLine(PoseStack matrix, int x, int y, int length, int zLevel, Colour colour) {
        ModRenderHelper.fill(matrix.m_85850_().m_85861_(), x, y, x + 1, y + length, zLevel, colour.toARGB());
    }

    public static void paintButton3D(PoseStack matrix, Point screenXY, int width, int height, int zLevel, Colour darkOutlineColour, Colour gradientLightColour, Colour gradientDarkColour, Colour borderLightColour, Colour borderDarkColour) {
        ModRenderHelper.paintButton3D(matrix, screenXY.X, screenXY.Y, width, height, zLevel, darkOutlineColour, gradientLightColour, gradientDarkColour, borderLightColour, borderDarkColour);
    }

    public static void paintButton3D(PoseStack matrix, int x, int y, int width, int height, int zLevel, Colour darkOutlineColour, Colour gradientLightColour, Colour gradientDarkColour, Colour borderLightColour, Colour borderDarkColour) {
        ModRenderHelper.paintHollowRect(matrix, x, y, width, height, zLevel, darkOutlineColour);
        ModRenderHelper.paintTriangularGradientRect(matrix, x + 2, y + 2, width - 3, height - 3, zLevel, gradientLightColour, gradientDarkColour);
        ModRenderHelper.paintHorizontalLine(matrix, x + 1, y + 1, width - 3 + 1, zLevel, borderLightColour);
        ModRenderHelper.paintVerticalLine(matrix, x + 1, y + 1, height - 3, zLevel, borderLightColour);
        ModRenderHelper.paintHorizontalLine(matrix, x + 1, y + height - 2, width - 2, zLevel, borderDarkColour);
        ModRenderHelper.paintVerticalLine(matrix, x + width - 2, y + 1 + 1, height - 3, zLevel, borderDarkColour);
    }

    public static void paintMessage(PoseStack matrix, IRichText message, int x, int y, int zLevel, int margin, Colour background, Colour highlight1, Colour highlight2) {
        Rectangle boxBounds = message.bounds().expand(margin * 2, margin * 2).offset(x, y);
        ModRenderHelper.paintVerticalLine(matrix, boxBounds.getX1(), boxBounds.getY1() + 1, boxBounds.Height - 2, zLevel, background);
        ModRenderHelper.paintSolidRect(matrix, boxBounds.getX1() + 1, boxBounds.getY1(), boxBounds.getX2(), boxBounds.getY2() + 1, zLevel, background);
        ModRenderHelper.paintVerticalLine(matrix, boxBounds.getX2(), boxBounds.getY1() + 1, boxBounds.Height - 2, zLevel, background);
        ModRenderHelper.paintVerticalGradientLine(matrix, boxBounds.getX1() + 1, boxBounds.getY1() + 1, boxBounds.Height - 2, zLevel, highlight1, highlight2);
        ModRenderHelper.paintHorizontalGradientLine(matrix, boxBounds.getX1() + 2, boxBounds.getY1() + 1, boxBounds.Width - 4, zLevel, highlight1, highlight2);
        ModRenderHelper.paintHorizontalGradientLine(matrix, boxBounds.getX1() + 2, boxBounds.getY2() - 1, boxBounds.Width - 4, zLevel, highlight1, highlight2);
        ModRenderHelper.paintVerticalGradientLine(matrix, boxBounds.getX2() - 1, boxBounds.getY1() + 1, boxBounds.Height - 2, zLevel, highlight1, highlight2);
        message.paint(matrix, boxBounds.getX1() + margin, boxBounds.getY1() + margin, zLevel + 1);
    }

    private static void blitSprite(Matrix4f matrix, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV) {
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_85982_(matrix, (float)x1, (float)y2, (float)blitOffset).m_7421_(minU, maxV).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)x2, (float)y2, (float)blitOffset).m_7421_(maxU, maxV).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)x2, (float)y1, (float)blitOffset).m_7421_(maxU, minV).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)x1, (float)y1, (float)blitOffset).m_7421_(minU, minV).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
    }

    private static void blitSprite(Matrix4f matrix, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV, Colour tint) {
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        bufferbuilder.m_85982_(matrix, (float)x1, (float)y2, (float)blitOffset).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(minU, maxV).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)x2, (float)y2, (float)blitOffset).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(maxU, maxV).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)x2, (float)y1, (float)blitOffset).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(maxU, minV).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)x1, (float)y1, (float)blitOffset).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(minU, minV).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
    }

    private static void blitSprite(PoseStack matrix, int x1, int x2, int y1, int y2, int blitOffset, int spriteWidth, int spriteHeight, float u, float v, int textureWidth, int textureHeight) {
        ModRenderHelper.blitSprite(matrix.m_85850_().m_85861_(), x1, x2, y1, y2, blitOffset, (u + 0.0f) / (float)textureWidth, (u + (float)spriteWidth) / (float)textureWidth, (v + 0.0f) / (float)textureHeight, (v + (float)spriteHeight) / (float)textureHeight);
    }

    private static void blitSprite(PoseStack matrix, int x1, int x2, int y1, int y2, int blitOffset, int spriteWidth, int spriteHeight, float u, float v, int textureWidth, int textureHeight, Colour tint) {
        ModRenderHelper.blitSprite(matrix.m_85850_().m_85861_(), x1, x2, y1, y2, blitOffset, (u + 0.0f) / (float)textureWidth, (u + (float)spriteWidth) / (float)textureWidth, (v + 0.0f) / (float)textureHeight, (v + (float)spriteHeight) / (float)textureHeight, tint);
    }

    private static void fill(Matrix4f matrix, int minX, int minY, int maxX, int maxY, int zLevel, int color) {
        if (minX < maxX) {
            int i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            int j = minY;
            minY = maxY;
            maxY = j;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_85982_(matrix, (float)minX, (float)maxY, (float)zLevel).m_85950_(r, g, b, a).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)maxX, (float)maxY, (float)zLevel).m_85950_(r, g, b, a).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)maxX, (float)minY, (float)zLevel).m_85950_(r, g, b, a).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)minX, (float)minY, (float)zLevel).m_85950_(r, g, b, a).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }

    public static boolean paintItemStack(PoseStack matrix, ItemStack stack, int x, int y, String text, boolean highlight) {
        if (stack.m_41619_()) {
            return false;
        }
        if (highlight) {
            ModRenderHelper.fill(matrix.m_85850_().m_85861_(), x, y, x + 16, y + 16, 599, -2130706433);
        }
        Minecraft mc = Minecraft.m_91087_();
        ItemRenderer itemRenderer = mc.m_91291_();
        float saveZ = itemRenderer.f_115093_;
        PoseStack viewModelMatrix = RenderSystem.m_157191_();
        viewModelMatrix.m_85836_();
        viewModelMatrix.m_166854_(matrix.m_85850_().m_85861_());
        RenderSystem.m_157182_();
        itemRenderer.f_115093_ = 600.0f;
        RenderSystem.m_69482_();
        itemRenderer.m_115203_(stack, x, y);
        itemRenderer.m_115174_(mc.f_91062_, stack, x + 4, y, text);
        itemRenderer.f_115093_ = saveZ;
        viewModelMatrix.m_85849_();
        RenderSystem.m_157182_();
        return true;
    }

    public static boolean paintItemStackWithCount(PoseStack matrix, ItemStack stack, int x, int y, boolean highlight) {
        return !stack.m_41619_() && ModRenderHelper.paintItemStack(matrix, stack, x, y, CodeHelper.formatAsHumanReadableNumber(stack.m_41613_(), ""), highlight);
    }

    public static void paintSolidLines(PoseStack matrix, Colour colour, double thickness, double zLevel, double ... vertices) {
        GlStateManager.m_84525_();
        GlStateManager.m_84110_();
        GlStateManager.m_84335_((int)GlStateManager.SourceFactor.SRC_ALPHA.f_84751_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.f_84646_, (int)GlStateManager.SourceFactor.ONE.f_84751_, (int)GlStateManager.DestFactor.ZERO.f_84646_);
        RenderSystem.m_69832_((float)((float)thickness));
        int verticesCount = vertices.length;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder builder = tessellator.m_85915_();
        Matrix4f pose = matrix.m_85850_().m_85861_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        builder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        for (int i = 0; i < verticesCount; i += 2) {
            builder.m_85982_(pose, (float)vertices[i], (float)vertices[i + 1], (float)zLevel).m_6122_((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A).m_5752_();
        }
        tessellator.m_85914_();
        GlStateManager.m_84109_();
        GlStateManager.m_84519_();
    }

    public static void paintSolidRects(PoseStack matrix, Colour colour, double zLevel, int ... vertices) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder builder = tessellator.m_85915_();
        Matrix4f pose = matrix.m_85850_().m_85861_();
        GlStateManager.m_84525_();
        GlStateManager.m_84110_();
        GlStateManager.m_84335_((int)GlStateManager.SourceFactor.SRC_ALPHA.f_84751_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.f_84646_, (int)GlStateManager.SourceFactor.ONE.f_84751_, (int)GlStateManager.DestFactor.ZERO.f_84646_);
        ModRenderHelper.glSetColour(colour);
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        int verticesCount = vertices.length;
        for (int i = 0; i < verticesCount; i += 4) {
            int x1 = vertices[i];
            int y1 = vertices[i + 1];
            int x2 = vertices[i + 2];
            int y2 = vertices[i + 3];
            builder.m_85982_(pose, (float)x1, (float)y2, (float)zLevel).m_5752_();
            builder.m_85982_(pose, (float)x2, (float)y2, (float)zLevel).m_5752_();
            builder.m_85982_(pose, (float)x2, (float)y1, (float)zLevel).m_5752_();
            builder.m_85982_(pose, (float)x1, (float)y1, (float)zLevel).m_5752_();
        }
        tessellator.m_85914_();
        GlStateManager.m_84109_();
        GlStateManager.m_84519_();
    }

    public static void paintSolidTriangles(PoseStack matrix, Colour colour, double zLevel, int ... vertices) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder builder = tessellator.m_85915_();
        Matrix4f pose = matrix.m_85850_().m_85861_();
        GlStateManager.m_84525_();
        GlStateManager.m_84110_();
        GlStateManager.m_84335_((int)GlStateManager.SourceFactor.SRC_ALPHA.f_84751_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.f_84646_, (int)GlStateManager.SourceFactor.ONE.f_84751_, (int)GlStateManager.DestFactor.ZERO.f_84646_);
        ModRenderHelper.glSetColour(colour);
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        builder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85814_);
        int verticesCount = vertices.length;
        for (int i = 0; i < verticesCount; i += 6) {
            int x1 = vertices[i];
            int y1 = vertices[i + 1];
            int x2 = vertices[i + 2];
            int y2 = vertices[i + 3];
            int x3 = vertices[i + 4];
            int y3 = vertices[i + 5];
            builder.m_85982_(pose, (float)x1, (float)y1, (float)zLevel).m_5752_();
            builder.m_85982_(pose, (float)x2, (float)y2, (float)zLevel).m_5752_();
            builder.m_85982_(pose, (float)x3, (float)y3, (float)zLevel).m_5752_();
        }
        tessellator.m_85914_();
        GlStateManager.m_84109_();
        GlStateManager.m_84519_();
    }

    public static void paintHorizontalGradientLine(PoseStack matrix, int x, int y, int length, double zLevel, Colour startColour, Colour endColour) {
        ModRenderHelper.paintHorizontalGradientRect(matrix, x, y, x + length, y + 1, zLevel, startColour, endColour);
    }

    public static void paintVerticalGradientLine(PoseStack matrix, int x, int y, int length, double zLevel, Colour startColour, Colour endColour) {
        ModRenderHelper.paintVerticalGradientRect(matrix, x, y, x + 1, y + length, zLevel, startColour, endColour);
    }

    public static void paintVerticalGradientRect(PoseStack matrix, int x1, int y1, int x2, int y2, double zLevel, Colour startColour, Colour endColour) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder builder = tessellator.m_85915_();
        Matrix4f pose = matrix.m_85850_().m_85861_();
        float startAlpha = startColour.glAlpha();
        float startRed = startColour.glRed();
        float startGreen = startColour.glGreen();
        float startBlue = startColour.glBlue();
        float endAlpha = endColour.glAlpha();
        float endRed = endColour.glRed();
        float endGreen = endColour.glGreen();
        float endBlue = endColour.glBlue();
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69411_((int)GlStateManager.SourceFactor.SRC_ALPHA.f_84751_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.f_84646_, (int)GlStateManager.SourceFactor.ONE.f_84751_, (int)GlStateManager.DestFactor.ZERO.f_84646_);
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        builder.m_85982_(pose, (float)x2, (float)y1, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        builder.m_85982_(pose, (float)x1, (float)y1, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        builder.m_85982_(pose, (float)x1, (float)y2, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        builder.m_85982_(pose, (float)x2, (float)y2, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public static void paintHorizontalGradientRect(PoseStack matrix, int x1, int y1, int x2, int y2, double zLevel, Colour startColour, Colour endColour) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder builder = tessellator.m_85915_();
        Matrix4f pose = matrix.m_85850_().m_85861_();
        float startAlpha = startColour.glAlpha();
        float startRed = startColour.glRed();
        float startGreen = startColour.glGreen();
        float startBlue = startColour.glBlue();
        float endAlpha = endColour.glAlpha();
        float endRed = endColour.glRed();
        float endGreen = endColour.glGreen();
        float endBlue = endColour.glBlue();
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69411_((int)GlStateManager.SourceFactor.SRC_ALPHA.f_84751_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.f_84646_, (int)GlStateManager.SourceFactor.ONE.f_84751_, (int)GlStateManager.DestFactor.ZERO.f_84646_);
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        builder.m_85982_(pose, (float)x1, (float)y1, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        builder.m_85982_(pose, (float)x1, (float)y2, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        builder.m_85982_(pose, (float)x2, (float)y2, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        builder.m_85982_(pose, (float)x2, (float)y1, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public static void paint3DGradientRect(PoseStack matrix, int x1, int y1, int x2, int y2, double zLevel, Colour lightColour, Colour darkColour) {
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69411_((int)GlStateManager.SourceFactor.SRC_ALPHA.f_84751_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.f_84646_, (int)GlStateManager.SourceFactor.ONE.f_84751_, (int)GlStateManager.DestFactor.ZERO.f_84646_);
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder builder = tessellator.m_85915_();
        Matrix4f pose = matrix.m_85850_().m_85861_();
        float startAlpha = lightColour.glAlpha();
        float startRed = lightColour.glRed();
        float startGreen = lightColour.glGreen();
        float startBlue = lightColour.glBlue();
        float endAlpha = darkColour.glAlpha();
        float endRed = darkColour.glRed();
        float endGreen = darkColour.glGreen();
        float endBlue = darkColour.glBlue();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        builder.m_85982_(pose, (float)x2, (float)y1, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        builder.m_85982_(pose, (float)x1, (float)y1, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        builder.m_85982_(pose, (float)x1, (float)y2, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        builder.m_85982_(pose, (float)x2, (float)y2, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public static void paint3DGradientTriangle(PoseStack matrix, double x1, double y1, double x2, double y2, double x3, double y3, double zLevel, Colour lightColour, Colour darkColour) {
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69411_((int)GlStateManager.SourceFactor.SRC_ALPHA.f_84751_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.f_84646_, (int)GlStateManager.SourceFactor.ONE.f_84751_, (int)GlStateManager.DestFactor.ZERO.f_84646_);
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder builder = tessellator.m_85915_();
        Matrix4f pose = matrix.m_85850_().m_85861_();
        float startAlpha = lightColour.glAlpha();
        float startRed = lightColour.glRed();
        float startGreen = lightColour.glGreen();
        float startBlue = lightColour.glBlue();
        float endAlpha = darkColour.glAlpha();
        float endRed = darkColour.glRed();
        float endGreen = darkColour.glGreen();
        float endBlue = darkColour.glBlue();
        builder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        builder.m_85982_(pose, (float)x2, (float)y2, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        builder.m_85982_(pose, (float)x1, (float)y1, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        builder.m_85982_(pose, (float)x3, (float)y3, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public static void paintTexturedRect(PoseStack matrix, int x, int y, double zLevel, int width, int height, int minU, int minV) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder builder = tessellator.m_85915_();
        Matrix4f pose = matrix.m_85850_().m_85861_();
        float textureScale = 0.00390625f;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        builder.m_85982_(pose, (float)x, (float)(y + height), (float)zLevel).m_7421_(0.00390625f * (float)minU, 0.00390625f * (float)(minV + height)).m_5752_();
        builder.m_85982_(pose, (float)(x + width), (float)(y + height), (float)zLevel).m_7421_(0.00390625f * (float)(minU + width), 0.00390625f * (float)(minV + height)).m_5752_();
        builder.m_85982_(pose, (float)(x + width), (float)y, (float)zLevel).m_7421_(0.00390625f * (float)(minU + width), 0.00390625f * (float)minV).m_5752_();
        builder.m_85982_(pose, (float)x, (float)y, (float)zLevel).m_7421_(0.00390625f * (float)minU, 0.00390625f * (float)minV).m_5752_();
        tessellator.m_85914_();
    }

    public static void paint3DSunkenBox(PoseStack matrix, int x1, int y1, int x2, int y2, double zLevel, Colour gradientLightColour, Colour gradientDarkColour, Colour borderLightColour, Colour borderDarkColour) {
        ModRenderHelper.paint3DGradientRect(matrix, x1 + 1, y1 + 1, x2 - 1, y2 - 1, zLevel, gradientLightColour, gradientDarkColour);
        ModRenderHelper.paintSolidRects(matrix, borderDarkColour, zLevel, x1, y1, x2, y1 + 1, x1, y1, x1 + 1, y2);
        ModRenderHelper.paintSolidRects(matrix, borderLightColour, zLevel, x1, y2 - 1, x2, y2, x2 - 1, y1, x2, y2);
    }

    public static void glSetColour(Colour colour) {
        RenderSystem.m_157429_((float)colour.glRed(), (float)colour.glGreen(), (float)colour.glBlue(), (float)colour.glAlpha());
    }

    public static void glSetViewport(int x, int y, int width, int height) {
        RenderSystem.m_69949_((int)x, (int)y, (int)width, (int)height);
    }

    public static void glSetViewport(double x, double y, double width, double height) {
        RenderSystem.m_69949_((int)Mth.m_14107_((double)x), (int)Mth.m_14107_((double)y), (int)Mth.m_14107_((double)width), (int)Mth.m_14107_((double)height));
    }

    public static void glSetDefaultViewport() {
        RenderSystem.m_69949_((int)0, (int)0, (int)Minecraft.m_91087_().m_91268_().m_85441_(), (int)Minecraft.m_91087_().m_91268_().m_85442_());
    }

    public static Matrix4f glPerspectiveMatrix(float fov, float aspect, float zNear, float zFar) {
        return Matrix4f.m_27625_((double)fov, (float)aspect, (float)zNear, (float)zFar);
    }

    private ModRenderHelper() {
    }
}

