/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.compat.jei.drawable;

import com.mojang.blaze3d.vertex.PoseStack;
import it.zerono.mods.zerocore.lib.client.gui.Padding;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import net.minecraftforge.common.util.NonNullSupplier;

public class SpriteDrawable
implements IDrawableStatic {
    private final NonNullSupplier<ISprite> _sprite;
    private final Padding _padding;
    private final int _zLevel;

    public SpriteDrawable(NonNullSupplier<ISprite> sprite, int zLevel) {
        this(sprite, zLevel, Padding.ZERO);
    }

    public SpriteDrawable(NonNullSupplier<ISprite> sprite, int zLevel, Padding padding) {
        this._sprite = sprite;
        this._padding = padding;
        this._zLevel = zLevel;
    }

    public ISprite getSprite() {
        return (ISprite)this._sprite.get();
    }

    public Padding getPadding() {
        return this._padding;
    }

    public int getZLevel() {
        return this._zLevel;
    }

    public int getWidth() {
        return this.getSprite().getWidth();
    }

    public int getHeight() {
        return this.getSprite().getHeight();
    }

    public void draw(PoseStack matrix, int xOffset, int yOffset) {
        ModRenderHelper.paintSprite(matrix, this.getSprite(), xOffset + this.getPadding().getLeft(), yOffset + this.getPadding().getTop(), this._zLevel, this.getWidth(), this.getHeight());
    }

    public void draw(PoseStack matrix, int xOffset, int yOffset, int maskTop, int maskBottom, int maskLeft, int maskRight) {
        ModRenderHelper.paintSprite(matrix, this.getSprite(), xOffset, yOffset, this._zLevel, this.getPadding(), this.getWidth(), this.getHeight(), maskTop, maskBottom, maskLeft, maskRight);
    }
}

