/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.geometry;

import it.unimi.dsi.fastutil.ints.IntComparator;
import it.zerono.mods.zerocore.lib.CodeHelper;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.NonNullFunction;

public class CuboidBoundingBox {
    public static final CuboidBoundingBox EMPTY = new CuboidBoundingBox(){

        @Override
        public AABB getAABB() {
            return CodeHelper.EMPTY_BOUNDING_BOX;
        }

        @Override
        public CuboidBoundingBox add(BlockPos position) {
            return new CuboidBoundingBox((Vec3i)position, (Vec3i)position);
        }

        @Override
        public boolean equals(Object other) {
            return other == EMPTY;
        }
    };
    private final BlockPos.MutableBlockPos _min;
    private final BlockPos.MutableBlockPos _max;
    private AABB _aabb;

    public CuboidBoundingBox() {
        this((Vec3i)CodeHelper.MAX_BLOCKPOS, (Vec3i)CodeHelper.MIN_BLOCKPOS);
    }

    public CuboidBoundingBox(Vec3i min, Vec3i max) {
        this._min = new BlockPos.MutableBlockPos(min.m_123341_(), min.m_123342_(), min.m_123343_());
        this._max = new BlockPos.MutableBlockPos(max.m_123341_(), max.m_123342_(), max.m_123343_());
    }

    public CuboidBoundingBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this._min = new BlockPos.MutableBlockPos(minX, minY, minZ);
        this._max = new BlockPos.MutableBlockPos(maxX, maxY, maxZ);
    }

    public BlockPos getMin() {
        return this._min;
    }

    public BlockPos getMax() {
        return this._max;
    }

    public AABB getAABB() {
        if (null == this._aabb) {
            this._aabb = new AABB((BlockPos)this._min, (BlockPos)this._max);
        }
        return this._aabb;
    }

    public boolean isEmpty() {
        return this == EMPTY || 0 == this._min.compareTo((Vec3i)this._max);
    }

    public CuboidBoundingBox add(BlockPos position) {
        if (position.compareTo((Vec3i)this._min) < 0) {
            this._min.m_122190_((Vec3i)position);
            this._aabb = null;
        }
        if (position.compareTo((Vec3i)this._max) > 0) {
            this._max.m_122190_((Vec3i)position);
            this._aabb = null;
        }
        return this;
    }

    public CuboidBoundingBox combine(CuboidBoundingBox other) {
        if (other._min.compareTo((Vec3i)this._min) < 0) {
            this._min.m_122190_((Vec3i)other._min);
        }
        if (other._max.compareTo((Vec3i)this._max) > 0) {
            this._max.m_122190_((Vec3i)other._max);
        }
        return this;
    }

    public boolean contains(Vec3i vec) {
        return this.contains(vec.m_123341_(), vec.m_123342_(), vec.m_123343_());
    }

    public boolean contains(int x, int y, int z) {
        return x >= this._min.m_123341_() && x < this._max.m_123341_() && y >= this._min.m_123342_() && y < this._max.m_123342_() && z >= this._min.m_123343_() && z < this._max.m_123343_();
    }

    public int getLengthX() {
        return this._max.m_123341_() - this._min.m_123341_() + 1;
    }

    public int getLengthY() {
        return this._max.m_123342_() - this._min.m_123342_() + 1;
    }

    public int getLengthZ() {
        return this._max.m_123343_() - this._min.m_123343_() + 1;
    }

    public int getVolume() {
        return this.isEmpty() ? 0 : CodeHelper.mathVolume((BlockPos)this._min, (BlockPos)this._max);
    }

    public int getInternalVolume() {
        return this.isEmpty() ? 0 : CodeHelper.mathVolume(this._min.m_142082_(1, 1, 1), this._max.m_142082_(-1, -1, -1));
    }

    public BlockPos getCenter() {
        return this._min.m_142082_(this.getLengthX() / 2, this.getLengthY() / 2, this.getLengthZ() / 2);
    }

    public int commonVertices(Vec3i position) {
        return CodeHelper.commonVertices(position, (Vec3i)this._min) + CodeHelper.commonVertices(position, (Vec3i)this._max);
    }

    public <R> R map(BiFunction<BlockPos, BlockPos, R> mapper) {
        return mapper.apply(this.getMin(), this.getMax());
    }

    public <R> R map(BiFunction<BlockPos, BlockPos, R> mapper, NonNullFunction<BlockPos, BlockPos> minRemapper, NonNullFunction<BlockPos, BlockPos> maxRemapper) {
        return mapper.apply((BlockPos)minRemapper.apply((Object)this.getMin()), (BlockPos)maxRemapper.apply((Object)this.getMax()));
    }

    public void accept(BiConsumer<BlockPos, BlockPos> consumer) {
        consumer.accept(this.getMin(), this.getMax());
    }

    public void accept(BiConsumer<BlockPos, BlockPos> consumer, NonNullFunction<BlockPos, BlockPos> minRemapper, NonNullFunction<BlockPos, BlockPos> maxRemapper) {
        consumer.accept((BlockPos)minRemapper.apply((Object)this.getMin()), (BlockPos)maxRemapper.apply((Object)this.getMax()));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CuboidBoundingBox)) {
            return false;
        }
        CuboidBoundingBox otherBB = (CuboidBoundingBox)other;
        return 0 == this._min.compareTo((Vec3i)otherBB._min) && 0 == this._max.compareTo((Vec3i)otherBB._max);
    }

    public int hashCode() {
        return Objects.hash(this._min, this._max);
    }

    public String toString() {
        return String.format("Bounding box %s -> %s", CodeHelper.toString((Vec3i)this._min), CodeHelper.toString((Vec3i)this._max));
    }

    private static boolean adjustPosition(BlockPos.MutableBlockPos currentPosition, BlockPos newPosition, IntComparator minMax) {
        int curX = currentPosition.m_123341_();
        int curY = currentPosition.m_123342_();
        int curZ = currentPosition.m_123343_();
        int newX = minMax.compare(currentPosition.m_123341_(), newPosition.m_123341_());
        int newY = minMax.compare(currentPosition.m_123342_(), newPosition.m_123342_());
        int newZ = minMax.compare(currentPosition.m_123343_(), newPosition.m_123343_());
        if (newX != curX || newY != curY || newZ != curZ) {
            currentPosition.m_122178_(newX, newY, newZ);
            return true;
        }
        return false;
    }
}

