/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.filter;

import com.google.common.collect.Maps;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.item.inventory.filter.IFilterComponent;
import it.zerono.mods.zerocore.lib.item.inventory.filter.IFilterComponentFactory;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public final class FilterManager<T extends IFilterComponent> {
    private Map<ResourceLocation, IFilterComponentFactory<T>> _factories;
    private static final FilterManager s_instance = new FilterManager();
    private static final String KEY_COMPONENT_ID = "cid";
    private static final String KEY_COMPONENT_DATA = "cdata";

    public static <T extends IFilterComponent> FilterManager<T> getInstance() {
        return s_instance;
    }

    public Optional<T> createComponent(ResourceLocation componentId) {
        Optional<IFilterComponentFactory<IFilterComponentFactory>> factory = this.getFactory(componentId);
        if (!factory.isPresent()) {
            Log.LOGGER.warn("Unable to create filter component: no factory found for {}}", (Object)componentId);
            return Optional.empty();
        }
        return factory.flatMap(f -> f.createComponent(componentId));
    }

    public Optional<T> loadComponentFromNBT(CompoundTag nbt) {
        if (!nbt.m_128441_(KEY_COMPONENT_ID) || !nbt.m_128441_(KEY_COMPONENT_DATA)) {
            return Optional.empty();
        }
        ResourceLocation componentId = new ResourceLocation(nbt.m_128461_(KEY_COMPONENT_ID));
        Optional<IFilterComponentFactory<IFilterComponentFactory>> factory = this.getFactory(componentId);
        if (!factory.isPresent()) {
            Log.LOGGER.warn("Unable to load filter component: no factory found for {}", (Object)componentId);
            return Optional.empty();
        }
        return factory.flatMap(f -> f.createComponent(componentId, nbt.m_128469_(KEY_COMPONENT_DATA)));
    }

    public CompoundTag storeComponentToNBT(T component) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_(KEY_COMPONENT_ID, component.getComponentId().toString());
        tag.m_128365_(KEY_COMPONENT_DATA, component.serializeNBT());
        return tag;
    }

    public void registerFactory(ResourceLocation componentId, IFilterComponentFactory<T> factory) {
        if (null == this._factories) {
            this._factories = Maps.newHashMap();
        }
        this._factories.put(componentId, factory);
    }

    private Optional<IFilterComponentFactory<T>> getFactory(ResourceLocation componentId) {
        return null != this._factories && this._factories.containsKey(componentId) ? Optional.of(this._factories.get(componentId)) : Optional.empty();
    }

    private FilterManager() {
    }
}

