/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.network;

import it.zerono.mods.zerocore.lib.network.IModMessage;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandler {
    private final String _protocolVersion;
    private final SimpleChannel _channel;
    private int _nextIndex = 0;

    public NetworkHandler(ResourceLocation channelName, String protocolVersion) {
        this._protocolVersion = protocolVersion;
        this._channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)channelName).clientAcceptedVersions(this._protocolVersion::equals).serverAcceptedVersions(this._protocolVersion::equals).networkProtocolVersion(() -> this._protocolVersion).simpleChannel();
    }

    public <T extends IModMessage> void registerMessage(Class<T> messageType, Function<FriendlyByteBuf, T> messageFactory) {
        this._channel.registerMessage(this._nextIndex++, messageType, IModMessage::encodeTo, messageFactory, NetworkHandler::handleMessage);
    }

    public <T extends IModMessage> void sendToServer(T message) {
        this._channel.sendToServer(message);
    }

    public <T extends IModMessage> void sendToPlayer(T message, ServerPlayer player) {
        if (!(player instanceof FakePlayer)) {
            this._channel.sendTo(message, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public <T extends IModMessage> void sendReply(T message, NetworkEvent.Context originalContext) {
        this._channel.reply(message, originalContext);
    }

    public <T extends IModMessage> void sendTo(T message, PacketDistributor.PacketTarget target) {
        this._channel.send(target, message);
    }

    public <T extends IModMessage> void sendToAllAround(T message, Supplier<PacketDistributor.TargetPoint> targetSupplier) {
        this.sendTo(message, PacketDistributor.NEAR.with(targetSupplier));
    }

    public <T extends IModMessage> void sendToAllAround(T message, double x, double y, double z, double radius, ResourceKey<Level> dimension) {
        this.sendToAllAround(message, PacketDistributor.TargetPoint.p((double)x, (double)y, (double)z, (double)radius, dimension));
    }

    public <T extends IModMessage> void sendToAllAround(T message, BlockPos center, double radius, ResourceKey<Level> dimension) {
        this.sendToAllAround(message, PacketDistributor.TargetPoint.p((double)center.m_123341_(), (double)center.m_123342_(), (double)center.m_123343_(), (double)radius, dimension));
    }

    public <T extends IModMessage> void sendToDimension(T message, ResourceKey<Level> dimension) {
        this.sendTo(message, PacketDistributor.DIMENSION.with(() -> dimension));
    }

    public <T extends IModMessage> void sendToAllPlayers(T message) {
        this.sendTo(message, PacketDistributor.ALL.noArg());
    }

    private static <T extends IModMessage> void handleMessage(T message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context messageContext = contextSupplier.get();
        messageContext.enqueueWork(() -> message.processMessage(messageContext));
        messageContext.setPacketHandled(true);
    }
}

