/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.world;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import it.zerono.mods.zerocore.internal.gamecontent.Content;
import it.zerono.mods.zerocore.lib.block.ModBlock;
import it.zerono.mods.zerocore.lib.world.AbstractWorldGenRegisteredFeature;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraftforge.common.util.NonNullFunction;

public class OreGenRegisteredFeature
extends AbstractWorldGenRegisteredFeature<OreGenRegisteredFeature, OreConfiguration, Feature<OreConfiguration>> {
    public static OreGenRegisteredFeature generation(String name, NonNullFunction<String, ResourceLocation> idFactory, Supplier<ModBlock> oreBlock, RuleTest matchRule, int oresPerVein) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        return new OreGenRegisteredFeature(name + "_gen", idFactory, (Supplier<Feature<OreConfiguration>>)Content.FEATURE_ORE, oreBlock, matchRule, oresPerVein);
    }

    public static OreGenRegisteredFeature regeneration(String name, NonNullFunction<String, ResourceLocation> idFactory, Supplier<ModBlock> oreBlock, RuleTest matchRule, int oresPerVein) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        return new OreGenRegisteredFeature(name + "_regen", idFactory, (Supplier<Feature<OreConfiguration>>)Content.FEATURE_ORE_REGEN, oreBlock, matchRule, oresPerVein);
    }

    public OreGenRegisteredFeature standardVein(int veinsPerChunk, int minY, int maxY) {
        return (OreGenRegisteredFeature)this.placement(new PlacementModifier[]{CountPlacement.m_191628_((int)veinsPerChunk), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)minY), (VerticalAnchor)VerticalAnchor.m_158922_((int)maxY))});
    }

    public OreGenRegisteredFeature deepVein(int veinsPerChunk) {
        return (OreGenRegisteredFeature)this.placement(new PlacementModifier[]{CountPlacement.m_191628_((int)veinsPerChunk), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)-48))});
    }

    protected OreGenRegisteredFeature(String name, NonNullFunction<String, ResourceLocation> idFactory, Supplier<Feature<OreConfiguration>> featureSupplier, Supplier<ModBlock> oreBlock, RuleTest matchRule, int oresPerCluster) {
        super(name, idFactory, featureSupplier, () -> new OreConfiguration(matchRule, ((ModBlock)oreBlock.get()).m_49966_(), oresPerCluster));
    }
}

