/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.world;

import it.zerono.mods.zerocore.lib.block.ModBlock;
import it.zerono.mods.zerocore.lib.world.AbstractWorldGenFeaturesMap;
import it.zerono.mods.zerocore.lib.world.OreGenRegisteredFeature;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class WorldGenManager
extends AbstractWorldGenFeaturesMap<BiomeLoadingEvent> {
    public static final WorldGenManager INSTANCE = new WorldGenManager();

    public static Predicate<BiomeLoadingEvent> matchAll() {
        return id -> true;
    }

    public static Predicate<BiomeLoadingEvent> matchOnly(ResourceLocation biomeId) {
        return event -> null != event.getName() && event.getName().equals((Object)biomeId);
    }

    public static Predicate<BiomeLoadingEvent> anyExcept(ResourceLocation biomeId) {
        return event -> null == event.getName() || !event.getName().equals((Object)biomeId);
    }

    public static Predicate<BiomeLoadingEvent> onlyNether() {
        return event -> Biome.BiomeCategory.NETHER == event.getCategory();
    }

    public static Predicate<BiomeLoadingEvent> exceptNether() {
        return event -> Biome.BiomeCategory.NETHER != event.getCategory();
    }

    public static Predicate<BiomeLoadingEvent> onlyTheEnd() {
        return event -> Biome.BiomeCategory.THEEND == event.getCategory();
    }

    public static Predicate<BiomeLoadingEvent> exceptTheEnd() {
        return event -> Biome.BiomeCategory.THEEND != event.getCategory();
    }

    public static OreGenRegisteredFeature oreVein(String name, NonNullFunction<String, ResourceLocation> idFactory, Supplier<ModBlock> oreBlock, RuleTest matchRule, int oresPerVein, int veinsPerChunk, int minY, int maxY) {
        return OreGenRegisteredFeature.generation(name, idFactory, oreBlock, matchRule, oresPerVein).standardVein(veinsPerChunk, minY, maxY);
    }

    public static OreGenRegisteredFeature oreDeepVein(String name, NonNullFunction<String, ResourceLocation> idFactory, Supplier<ModBlock> oreBlock, RuleTest matchRule, int oresPerVein, int veinsPerChunk) {
        return OreGenRegisteredFeature.generation(name, idFactory, oreBlock, matchRule, oresPerVein).deepVein(veinsPerChunk);
    }

    private WorldGenManager() {
        MinecraftForge.EVENT_BUS.addListener(this::onBiomesLoaded);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBiomesLoaded(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder builder = event.getGeneration();
        for (GenerationStep.Decoration stage : this._entries.keySet()) {
            List biomeFeatures = builder.getFeatures(stage);
            this._entries.getOrDefault(stage, Collections.emptyList()).stream().filter(p -> ((Predicate)p.getKey()).test(event)).forEach(p -> biomeFeatures.add((Holder)((Supplier)p.getValue()).get()));
        }
    }
}

