/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import jeresources.compatibility.CompatBase;
import net.minecraft.data.loot.EntityLoot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;

public class MobTableBuilder {
    private final Map<ResourceLocation, Supplier<LivingEntity>> mobTables = new HashMap<ResourceLocation, Supplier<LivingEntity>>();
    private final MyEntityLoot entityLootHelper = new MyEntityLoot();
    private final Level level = CompatBase.getLevel();

    public void add(ResourceLocation resourceLocation, EntityType<?> entityType) {
        if (this.entityLootHelper.isNonLiving(entityType)) {
            return;
        }
        this.mobTables.put(resourceLocation, () -> (LivingEntity)entityType.m_20615_(this.level));
    }

    public void addSheep(ResourceLocation resourceLocation, EntityType<Sheep> entityType, DyeColor dye) {
        this.mobTables.put(resourceLocation, () -> {
            Sheep sheep = (Sheep)entityType.m_20615_(this.level);
            assert (sheep != null);
            sheep.m_29855_(dye);
            return sheep;
        });
    }

    public Map<ResourceLocation, Supplier<LivingEntity>> getMobTables() {
        return this.mobTables;
    }

    private static class MyEntityLoot
    extends EntityLoot {
        private MyEntityLoot() {
        }

        public boolean isNonLiving(@Nonnull EntityType<?> entitytype) {
            return super.isNonLiving(entitytype);
        }
    }
}

