/*
 * Decompiled with CFR 0.152.
 */
package be.florens.expandability.mixin.swimming;

import be.florens.expandability.EventDispatcher;
import be.florens.expandability.Util;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Player.class})
public abstract class PlayerMixin {
    @Redirect(method={"attack", "checkMovementStatistics", "tryToStartFallFlying"}, require=3, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;isInWater()Z"))
    private boolean setInWater(Player player) {
        return Util.processEventResult(EventDispatcher.onPlayerSwim(player), () -> ((Player)player).m_20069_());
    }

    @Redirect(method={"checkMovementStatistics"}, require=0, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;isEyeInFluid(Lnet/minecraft/tags/TagKey;)Z"))
    private boolean setEyeInFluid(Player player, TagKey<Fluid> tag) {
        return Util.processEventResult(EventDispatcher.onPlayerSwim(player), () -> player.m_204029_(tag));
    }

    @Redirect(method={"travel"}, allow=1, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/material/FluidState;isEmpty()Z"))
    private boolean cancelSurfaceCheck(FluidState fluidState) {
        Player self = (Player)this;
        return Util.processEventResult(EventDispatcher.onPlayerSwim(self), false, true, () -> ((FluidState)fluidState).m_76178_());
    }
}

