/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.platform.serverconfig;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import me.lucko.spark.common.platform.serverconfig.ServerConfigProvider;

public abstract class AbstractServerConfigProvider<T extends Enum<T>>
implements ServerConfigProvider {
    private final Map<String, T> files;
    private final Collection<String> hiddenPaths;

    protected AbstractServerConfigProvider(Map<String, T> files, Collection<String> hiddenPaths) {
        this.files = files;
        this.hiddenPaths = hiddenPaths;
    }

    @Override
    public final Map<String, JsonElement> loadServerConfigurations() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.files.forEach((path, type) -> {
            try {
                JsonElement json = this.load((String)path, (T)type);
                if (json != null) {
                    AbstractServerConfigProvider.delete(json, this.hiddenPaths);
                    builder.put(path, (Object)json);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return builder.build();
    }

    protected abstract JsonElement load(String var1, T var2) throws IOException;

    private static void delete(JsonElement json, Collection<String> paths) {
        for (String path : paths) {
            LinkedList<String> pathDeque = new LinkedList<String>(Arrays.asList(path.split("\\.")));
            AbstractServerConfigProvider.delete(json, pathDeque);
        }
    }

    private static void delete(JsonElement json, Deque<String> path) {
        String member;
        if (path.isEmpty()) {
            return;
        }
        if (!json.isJsonObject()) {
            return;
        }
        JsonObject jsonObject = json.getAsJsonObject();
        if (!jsonObject.has(member = path.removeFirst().replace("<dot>", "."))) {
            return;
        }
        if (path.isEmpty()) {
            jsonObject.remove(member);
        } else {
            AbstractServerConfigProvider.delete(jsonObject.get(member), path);
        }
    }
}

