/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.java;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.command.sender.CommandSender;
import me.lucko.spark.common.sampler.AbstractSampler;
import me.lucko.spark.common.sampler.ThreadDumper;
import me.lucko.spark.common.sampler.ThreadGrouper;
import me.lucko.spark.common.sampler.java.JavaDataAggregator;
import me.lucko.spark.common.sampler.java.SimpleDataAggregator;
import me.lucko.spark.common.sampler.java.TickedDataAggregator;
import me.lucko.spark.common.sampler.node.MergeMode;
import me.lucko.spark.common.sampler.node.ThreadNode;
import me.lucko.spark.common.tick.TickHook;
import me.lucko.spark.common.util.ClassSourceLookup;
import me.lucko.spark.proto.SparkSamplerProtos;

public class JavaSampler
extends AbstractSampler
implements Runnable {
    private static final AtomicInteger THREAD_ID = new AtomicInteger(0);
    private final ScheduledExecutorService workerPool = Executors.newScheduledThreadPool(6, new ThreadFactoryBuilder().setNameFormat("spark-worker-" + THREAD_ID.getAndIncrement() + "-%d").build());
    private ScheduledFuture<?> task;
    private final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
    private final JavaDataAggregator dataAggregator;

    public JavaSampler(int interval, ThreadDumper threadDumper, ThreadGrouper threadGrouper, long endTime, boolean ignoreSleeping, boolean ignoreNative) {
        super(interval, threadDumper, endTime);
        this.dataAggregator = new SimpleDataAggregator(this.workerPool, threadGrouper, interval, ignoreSleeping, ignoreNative);
    }

    public JavaSampler(int interval, ThreadDumper threadDumper, ThreadGrouper threadGrouper, long endTime, boolean ignoreSleeping, boolean ignoreNative, TickHook tickHook, int tickLengthThreshold) {
        super(interval, threadDumper, endTime);
        this.dataAggregator = new TickedDataAggregator(this.workerPool, threadGrouper, interval, ignoreSleeping, ignoreNative, tickHook, tickLengthThreshold);
    }

    @Override
    public void start() {
        this.startTime = System.currentTimeMillis();
        this.task = this.workerPool.scheduleAtFixedRate(this, 0L, this.interval, TimeUnit.MICROSECONDS);
    }

    @Override
    public void stop() {
        this.task.cancel(false);
    }

    @Override
    public void run() {
        try {
            if (this.endTime != -1L && this.endTime <= System.currentTimeMillis()) {
                this.future.complete(this);
                this.stop();
                return;
            }
            ThreadInfo[] threadDumps = this.threadDumper.dumpThreads(this.threadBean);
            this.workerPool.execute(new InsertDataTask(this.dataAggregator, threadDumps));
        }
        catch (Throwable t) {
            this.future.completeExceptionally(t);
            this.stop();
        }
    }

    @Override
    public SparkSamplerProtos.SamplerData toProto(SparkPlatform platform, CommandSender creator, Comparator<? super Map.Entry<String, ThreadNode>> outputOrder, String comment, MergeMode mergeMode, ClassSourceLookup classSourceLookup) {
        SparkSamplerProtos.SamplerData.Builder proto = SparkSamplerProtos.SamplerData.newBuilder();
        this.writeMetadataToProto(proto, platform, creator, comment, this.dataAggregator);
        this.writeDataToProto(proto, this.dataAggregator, outputOrder, mergeMode, classSourceLookup);
        return (SparkSamplerProtos.SamplerData)proto.build();
    }

    private static final class InsertDataTask
    implements Runnable {
        private final JavaDataAggregator dataAggregator;
        private final ThreadInfo[] threadDumps;

        InsertDataTask(JavaDataAggregator dataAggregator, ThreadInfo[] threadDumps) {
            this.dataAggregator = dataAggregator;
            this.threadDumps = threadDumps;
        }

        @Override
        public void run() {
            for (ThreadInfo threadInfo : this.threadDumps) {
                if (threadInfo.getThreadName() == null || threadInfo.getStackTrace() == null) continue;
                this.dataAggregator.insertData(threadInfo);
            }
        }
    }
}

